/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.CombatEntry;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.Ageable;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.damage.source.DamageSource;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.entity.EntityBridge;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.tick.EntityTickContext;
import org.spongepowered.common.event.tracking.phase.tick.TickPhaseState;
import org.spongepowered.common.mixin.core.util.CombatEntryAccessor;
import org.spongepowered.common.mixin.core.util.CombatTrackerAccessor;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.BlockChange;

class EntityTickPhaseState
extends TickPhaseState<EntityTickContext> {
    private final BiConsumer<CauseStackManager.StackFrame, EntityTickContext> ENTITY_TICK_MODIFIER = super.getFrameModifier().andThen((frame, context) -> {
        Entity tickingEntity = context.getSource(Entity.class).orElseThrow(TrackingUtil.throwWithContext("Not ticking on an Entity!", context));
        if (tickingEntity instanceof EntityFallingBlock) {
            context.getOwner().ifPresent(frame::pushCause);
        }
        frame.pushCause(tickingEntity);
    });

    EntityTickPhaseState() {
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, EntityTickContext> getFrameModifier() {
        return this.ENTITY_TICK_MODIFIER;
    }

    @Override
    public void unwind(EntityTickContext phaseContext) {
        Entity tickingEntity = phaseContext.getSource(Entity.class).orElseThrow(TrackingUtil.throwWithContext("Not ticking on an Entity!", phaseContext));
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            this.processCaptures(tickingEntity, phaseContext, frame);
        }
    }

    protected void processCaptures(Entity tickingEntity, EntityTickContext phaseContext, CauseStackManager.StackFrame frame) {
        phaseContext.addNotifierAndOwnerToCauseStack(frame);
        if (phaseContext.allowsBulkBlockCaptures() && !TrackingUtil.processBlockCaptures(phaseContext)) {
            ((EntityBridge)((Object)tickingEntity)).bridge$onCancelledBlockChange(phaseContext);
        }
        if (!phaseContext.allowsBulkEntityCaptures()) {
            return;
        }
        phaseContext.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> {
            ArrayList<Entity> experience = new ArrayList<Entity>(entities.size());
            ArrayList<Entity> nonExp = new ArrayList<Entity>(entities.size());
            ArrayList<Entity> breeding = new ArrayList<Entity>(entities.size());
            ArrayList<Entity> projectile = new ArrayList<Entity>(entities.size());
            for (Entity entity : entities) {
                if (entity instanceof EntityXPOrb) {
                    experience.add(entity);
                    continue;
                }
                if (tickingEntity instanceof Ageable && tickingEntity.getClass() == entity.getClass()) {
                    breeding.add(entity);
                    continue;
                }
                if (entity instanceof Projectile) {
                    projectile.add(entity);
                    continue;
                }
                nonExp.add(entity);
            }
            if (!experience.isEmpty()) {
                frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.EXPERIENCE);
                this.appendContextOfPossibleEntityDeath(tickingEntity, frame);
                SpongeCommonEventFactory.callSpawnEntity(experience, phaseContext);
                frame.removeContext(EventContextKeys.LAST_DAMAGE_SOURCE);
            }
            if (!breeding.isEmpty()) {
                EntityPlayerMP playerInLove;
                frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.BREEDING);
                if (tickingEntity instanceof EntityAnimal && (playerInLove = ((EntityAnimal)tickingEntity).func_191993_do()) != null) {
                    frame.addContext(EventContextKeys.PLAYER, (Player)playerInLove);
                }
                SpongeCommonEventFactory.callSpawnEntity(breeding, phaseContext);
                frame.removeContext(EventContextKeys.PLAYER);
            }
            if (!projectile.isEmpty()) {
                frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PROJECTILE);
                SpongeCommonEventFactory.callSpawnEntity(projectile, phaseContext);
                frame.removeContext(EventContextKeys.SPAWN_TYPE);
            }
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PASSIVE);
            SpongeCommonEventFactory.callSpawnEntity(nonExp, phaseContext);
            frame.removeContext(EventContextKeys.SPAWN_TYPE);
        });
        phaseContext.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(entities -> {
            ArrayList<Entity> capturedEntities = new ArrayList<Entity>();
            for (EntityItem entity : entities) {
                capturedEntities.add((Entity)entity);
            }
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            SpongeCommonEventFactory.callDropItemCustom(capturedEntities, phaseContext);
            frame.removeContext(EventContextKeys.SPAWN_TYPE);
        });
        phaseContext.getBlockItemDropSupplier().acceptAndClearIfNotEmpty(map -> {
            List<SpongeBlockSnapshot> capturedBlocks = phaseContext.getCapturedOriginalBlocksChanged();
            for (SpongeBlockSnapshot snapshot : capturedBlocks) {
                BlockPos blockPos = snapshot.getBlockPos();
                Collection entityItems = map.get(blockPos);
                if (entityItems.isEmpty()) continue;
                frame.pushCause(snapshot);
                frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
                List<Entity> items = entityItems.stream().map(entity -> (Entity)entity).collect(Collectors.toList());
                SpongeCommonEventFactory.callDropItemDestruct(items, phaseContext);
                frame.popCause();
            }
        });
        phaseContext.getCapturedItemStackSupplier().acceptAndClearIfNotEmpty(drops -> {
            List<Entity> items = drops.stream().map(drop -> drop.create((WorldServer)tickingEntity.getWorld())).map(entity -> (Entity)entity).collect(Collectors.toList());
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            SpongeCommonEventFactory.callDropItemCustom(items, phaseContext);
        });
        phaseContext.getPerBlockEntitySpawnSuppplier().acceptAndClearIfNotEmpty(blockDrops -> blockDrops.asMap().forEach((pos, drops) -> {
            List<Entity> nonItems;
            List<Entity> items = drops.stream().filter(entity -> entity instanceof EntityItem).map(entity2 -> (Entity)entity2).collect(Collectors.toList());
            BlockSnapshot snapshot = tickingEntity.getWorld().createSnapshot(VecHelper.toVector3i(pos));
            frame.pushCause(snapshot);
            if (!items.isEmpty()) {
                frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
                SpongeCommonEventFactory.callDropItemCustom(items, phaseContext);
            }
            if (!(nonItems = drops.stream().filter(entity -> !(entity instanceof EntityItem)).map(entity1 -> (Entity)entity1).collect(Collectors.toList())).isEmpty()) {
                frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.BLOCK_SPAWNING);
                SpongeCommonEventFactory.callSpawnEntityCustom(nonItems, phaseContext);
            }
        }));
    }

    private void appendContextOfPossibleEntityDeath(Entity tickingEntity, CauseStackManager.StackFrame frame) {
        CombatEntry entry;
        if (EntityUtil.isEntityDead((net.minecraft.entity.Entity)tickingEntity) && tickingEntity instanceof EntityLivingBase && (entry = ((CombatTrackerAccessor)((EntityLivingBase)tickingEntity).func_110142_aN()).accessor$getBestCombatEntry()) != null && ((CombatEntryAccessor)entry).accessor$getDamageSrc() != null) {
            frame.addContext(EventContextKeys.LAST_DAMAGE_SOURCE, (DamageSource)((CombatEntryAccessor)entry).accessor$getDamageSrc());
        }
    }

    @Override
    protected EntityTickContext createNewContext() {
        return (EntityTickContext)new EntityTickContext(this).addCaptures();
    }

    @Override
    public void postBlockTransactionApplication(BlockChange blockChange, Transaction<? extends BlockSnapshot> transaction, EntityTickContext context) {
        if (blockChange == BlockChange.BREAK) {
            Entity tickingEntity = context.getSource(Entity.class).get();
            BlockPos blockPos = VecHelper.toBlockPos(transaction.getOriginal().getPosition());
            List hangingEntities = ((WorldServer)tickingEntity.getWorld()).func_175647_a(EntityHanging.class, new AxisAlignedBB(blockPos, blockPos).func_72314_b(1.1, 1.1, 1.1), entityIn -> {
                if (entityIn == null) {
                    return false;
                }
                BlockPos entityPos = entityIn.func_180425_c();
                if (entityPos.equals((Object)blockPos.func_177982_a(0, 1, 0))) {
                    return true;
                }
                EnumFacing entityFacing = entityIn.func_174811_aO();
                if (entityFacing == EnumFacing.NORTH) {
                    return entityPos.equals((Object)blockPos.func_177971_a((Vec3i)Constants.Entity.HANGING_OFFSET_NORTH));
                }
                if (entityFacing == EnumFacing.SOUTH) {
                    return entityIn.func_180425_c().equals((Object)blockPos.func_177971_a((Vec3i)Constants.Entity.HANGING_OFFSET_SOUTH));
                }
                if (entityFacing == EnumFacing.WEST) {
                    return entityIn.func_180425_c().equals((Object)blockPos.func_177971_a((Vec3i)Constants.Entity.HANGING_OFFSET_WEST));
                }
                if (entityFacing == EnumFacing.EAST) {
                    return entityIn.func_180425_c().equals((Object)blockPos.func_177971_a((Vec3i)Constants.Entity.HANGING_OFFSET_EAST));
                }
                return false;
            });
            for (EntityHanging entityHanging : hangingEntities) {
                if (!(entityHanging instanceof EntityItemFrame)) continue;
                EntityItemFrame itemFrame = (EntityItemFrame)entityHanging;
                if (!itemFrame.field_70128_L) {
                    itemFrame.func_146065_b((net.minecraft.entity.Entity)tickingEntity, true);
                }
                itemFrame.func_70106_y();
            }
        }
    }

    @Override
    public void appendContextPreExplosion(ExplosionContext explosionContext, EntityTickContext context) {
        if (!context.applyNotifierIfAvailable(explosionContext::owner)) {
            context.applyOwnerIfAvailable(explosionContext::owner);
        }
        explosionContext.source(context.getSource(Entity.class).orElseThrow(() -> new IllegalStateException("Ticking a non Entity")));
    }

    @Override
    public boolean spawnEntityOrCapture(EntityTickContext context, Entity entity, int chunkX, int chunkZ) {
        Entity tickingEntity = context.getSource(Entity.class).orElseThrow(TrackingUtil.throwWithContext("Not ticking on an Entity!", context));
        if (context.allowsBulkEntityCaptures()) {
            Optional<BlockPos> pos = context.getCaptureBlockPos().getPos();
            if (pos.isPresent()) {
                return ((ArrayListMultimap)context.getPerBlockEntitySpawnSuppplier().get()).put(pos.get(), (net.minecraft.entity.Entity)entity);
            }
            return context.getCapturedEntities().add(entity);
        }
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            context.addNotifierAndOwnerToCauseStack(frame);
            frame.pushCause(tickingEntity);
            if (entity instanceof EntityXPOrb) {
                frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.EXPERIENCE);
                this.appendContextOfPossibleEntityDeath(tickingEntity, frame);
                ArrayList<Entity> experience = new ArrayList<Entity>(1);
                experience.add(entity);
                boolean bl2 = SpongeCommonEventFactory.callSpawnEntity(experience, context);
                return bl2;
            }
            if (tickingEntity instanceof Ageable && tickingEntity.getClass() == entity.getClass()) {
                EntityPlayerMP playerInLove;
                frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.BREEDING);
                if (tickingEntity instanceof EntityAnimal && (playerInLove = ((EntityAnimal)tickingEntity).func_191993_do()) != null) {
                    frame.addContext(EventContextKeys.PLAYER, (Player)playerInLove);
                }
                ArrayList<Entity> breeding = new ArrayList<Entity>(1);
                breeding.add(entity);
                boolean bl3 = SpongeCommonEventFactory.callSpawnEntity(breeding, context);
                return bl3;
            }
            if (entity instanceof Projectile) {
                frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PROJECTILE);
                ArrayList<Entity> projectile = new ArrayList<Entity>(1);
                projectile.add(entity);
                boolean bl4 = SpongeCommonEventFactory.callSpawnEntity(projectile, context);
                return bl4;
            }
            ArrayList<Entity> nonExp = new ArrayList<Entity>(1);
            nonExp.add(entity);
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PASSIVE);
            boolean bl5 = SpongeCommonEventFactory.callSpawnEntity(nonExp, context);
            return bl5;
        }
    }

    @Override
    public boolean doesCaptureEntitySpawns() {
        return false;
    }

    @Override
    public boolean alreadyProcessingBlockItemDrops() {
        return true;
    }

    @Override
    public boolean doesBulkBlockCapture(EntityTickContext context) {
        return context.allowsBulkBlockCaptures();
    }

    @Override
    public boolean doesBlockEventTracking(EntityTickContext context) {
        return context.allowsBlockEvents();
    }
}

