/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import java.util.ArrayList;
import java.util.function.BiConsumer;
import net.minecraft.entity.item.EntityXPOrb;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.tick.LocationBasedTickPhaseState;
import org.spongepowered.common.event.tracking.phase.tick.NeighborNotificationContext;

class NeighborNotificationState
extends LocationBasedTickPhaseState<NeighborNotificationContext> {
    private final BiConsumer<CauseStackManager.StackFrame, NeighborNotificationContext> FRAME_MODIFIER = IPhaseState.DEFAULT_OWNER_NOTIFIER.andThen((frame, context) -> {
        if (context.notificationSnapshot != null) {
            frame.addContext(EventContextKeys.NEIGHBOR_NOTIFY_SOURCE, context.notificationSnapshot);
        }
    });

    NeighborNotificationState() {
    }

    @Override
    public NeighborNotificationContext createNewContext() {
        return (NeighborNotificationContext)new NeighborNotificationContext(this).addCaptures();
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, NeighborNotificationContext> getFrameModifier() {
        return this.FRAME_MODIFIER;
    }

    @Override
    LocatableBlock getLocatableBlockSourceFromContext(PhaseContext<?> context) {
        return context.getSource(LocatableBlock.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be ticking over at a location!", context));
    }

    @Override
    public void appendContextPreExplosion(ExplosionContext explosionContext, NeighborNotificationContext context) {
        context.applyNotifierIfAvailable(explosionContext::notifier);
        context.applyOwnerIfAvailable(explosionContext::owner);
        LocatableBlock locatableBlock = this.getLocatableBlockSourceFromContext(context);
        explosionContext.source(locatableBlock);
    }

    @Override
    public boolean spawnEntityOrCapture(NeighborNotificationContext context, Entity entity, int chunkX, int chunkZ) {
        LocatableBlock locatableBlock = this.getLocatableBlockSourceFromContext(context);
        if (!context.allowsEntityEvents() || !ShouldFire.SPAWN_ENTITY_EVENT) {
            return EntityUtil.processEntitySpawn(entity, EntityUtil.ENTITY_CREATOR_FUNCTION.apply(context));
        }
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(locatableBlock);
            if (entity instanceof EntityXPOrb) {
                frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.EXPERIENCE);
                ArrayList<Entity> entities = new ArrayList<Entity>(1);
                entities.add(entity);
                boolean bl2 = SpongeCommonEventFactory.callSpawnEntity(entities, context);
                return bl2;
            }
            ArrayList<Entity> nonExpEntities = new ArrayList<Entity>(1);
            nonExpEntities.add(entity);
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.BLOCK_SPAWNING);
            boolean bl3 = SpongeCommonEventFactory.callSpawnEntity(nonExpEntities, context);
            return bl3;
        }
    }

    @Override
    public void provideNotifierForNeighbors(NeighborNotificationContext context, NeighborNotificationContext notification) {
        super.provideNotifierForNeighbors(context, notification);
        notification.setDepth(context.getDepth() + 1);
    }

    @Override
    public boolean isNotReEntrant() {
        return false;
    }

    @Override
    public boolean doesBulkBlockCapture(NeighborNotificationContext context) {
        return false;
    }

    @Override
    public boolean doesBlockEventTracking(NeighborNotificationContext context) {
        return context.allowsBlockEvents();
    }

    @Override
    public boolean doesCaptureEntityDrops(NeighborNotificationContext context) {
        return false;
    }
}

