/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.spongepowered.api.item.FireworkEffect;
import org.spongepowered.api.item.FireworkShape;
import org.spongepowered.api.item.FireworkShapes;
import org.spongepowered.api.util.Color;
import org.spongepowered.common.item.SpongeFireworkEffect;

public class SpongeFireworkEffectBuilder
implements FireworkEffect.Builder {
    private boolean trail = false;
    private boolean flicker = false;
    private List<Color> colors = Lists.newArrayList();
    private List<Color> fades = Lists.newArrayList();
    private FireworkShape shape = FireworkShapes.BALL;

    @Override
    public SpongeFireworkEffectBuilder trail(boolean trail) {
        this.trail = trail;
        return this;
    }

    @Override
    public SpongeFireworkEffectBuilder flicker(boolean flicker) {
        this.flicker = flicker;
        return this;
    }

    @Override
    public SpongeFireworkEffectBuilder color(Color color) {
        Preconditions.checkNotNull(color);
        this.colors.add(color);
        return this;
    }

    @Override
    public SpongeFireworkEffectBuilder colors(Color ... colors) {
        Preconditions.checkNotNull(colors);
        Collections.addAll(this.colors, colors);
        return this;
    }

    @Override
    public SpongeFireworkEffectBuilder colors(Iterable<Color> colors) {
        Preconditions.checkNotNull(colors);
        for (Color color : colors) {
            this.colors.add(color);
        }
        return this;
    }

    @Override
    public SpongeFireworkEffectBuilder fade(Color color) {
        Preconditions.checkNotNull(color);
        this.fades.add(color);
        return this;
    }

    @Override
    public SpongeFireworkEffectBuilder fades(Color ... colors) {
        Preconditions.checkNotNull(colors);
        Collections.addAll(this.fades, colors);
        return this;
    }

    @Override
    public SpongeFireworkEffectBuilder fades(Iterable<Color> colors) {
        Preconditions.checkNotNull(colors);
        for (Color color : colors) {
            this.fades.add(color);
        }
        return this;
    }

    @Override
    public SpongeFireworkEffectBuilder shape(FireworkShape shape) {
        this.shape = Preconditions.checkNotNull(shape);
        return this;
    }

    @Override
    public FireworkEffect build() {
        return new SpongeFireworkEffect(this.flicker, this.trail, this.colors, this.fades, this.shape);
    }

    @Override
    public FireworkEffect.Builder from(FireworkEffect value) {
        return ((SpongeFireworkEffectBuilder)((SpongeFireworkEffectBuilder)this.trail(value.hasTrail()).colors(value.getColors())).fades(value.getFadeColors())).shape(value.getShape()).flicker(value.flickers());
    }

    @Override
    public SpongeFireworkEffectBuilder reset() {
        this.trail = false;
        this.flicker = false;
        this.colors = Lists.newArrayList();
        this.fades = Lists.newArrayList();
        this.shape = FireworkShapes.BALL;
        return this;
    }
}

