/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.enchantment;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.item.enchantment.Enchantment;
import org.spongepowered.api.item.enchantment.EnchantmentType;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.item.enchantment.SpongeEnchantment;

public final class SpongeEnchantmentBuilder
extends AbstractDataBuilder<Enchantment>
implements Enchantment.Builder {
    @Nullable
    private EnchantmentType enchantmentType;
    @Nullable
    private Integer level;

    public SpongeEnchantmentBuilder() {
        super(Enchantment.class, 1);
    }

    @Override
    public Enchantment.Builder from(Enchantment value) {
        Preconditions.checkNotNull(value, "The enchantment to create a builder from cannot be null!");
        this.enchantmentType = value.getType();
        this.level = value.getLevel();
        return this;
    }

    @Override
    public Enchantment.Builder reset() {
        this.enchantmentType = null;
        this.level = null;
        return this;
    }

    @Override
    public Enchantment.Builder type(EnchantmentType enchantmentType) {
        this.enchantmentType = Preconditions.checkNotNull(enchantmentType, "Enchantment type cannot be null!");
        return this;
    }

    @Override
    public Enchantment.Builder level(int level) {
        Preconditions.checkArgument(level >= Short.MIN_VALUE, "The specified level must be greater than %s (was %s)!", Short.MIN_VALUE, level);
        Preconditions.checkArgument(level <= Short.MAX_VALUE, "The specified level must not be greater than %s (was %s)!", Short.MAX_VALUE, level);
        this.level = level;
        return this;
    }

    @Override
    public Enchantment build() {
        Preconditions.checkState(this.enchantmentType != null, "The enchantment type must be set!");
        Preconditions.checkState(this.level != null, "The level of the enchantment must be set!");
        return new SpongeEnchantment(this.enchantmentType, this.level);
    }

    @Override
    protected Optional<Enchantment> buildContent(DataView container) throws InvalidDataException {
        Preconditions.checkNotNull(container, "The data view cannot be null!");
        if (!container.contains(Queries.ENCHANTMENT_ID, Queries.LEVEL)) {
            return Optional.empty();
        }
        String id = DataUtil.getData(container, Queries.ENCHANTMENT_ID, String.class);
        int level = DataUtil.getData(container, Queries.LEVEL, Integer.class);
        Optional<EnchantmentType> enchantmentType = Sponge.getRegistry().getType(EnchantmentType.class, id);
        return enchantmentType.map(t -> Enchantment.builder().type((EnchantmentType)t).level(level).build());
    }
}

