/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.api.GameDictionary;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Property;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.merge.MergeFunction;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.common.bridge.data.CustomDataHolderBridge;
import org.spongepowered.common.data.DataProcessor;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.registry.SpongeGameDictionaryEntry;
import org.spongepowered.common.registry.type.ItemTypeRegistryModule;
import org.spongepowered.common.util.Constants;

public class SpongeItemStackSnapshot
implements ItemStackSnapshot {
    private final ItemType itemType;
    private final int quantity;
    private final int damageValue;
    private final ImmutableList<ImmutableDataManipulator<?, ?>> manipulators;
    private final transient ItemStack privateStack;
    private final ImmutableSet<Key<?>> keys;
    private final ImmutableSet<ImmutableValue<?>> values;
    @Nullable
    private final NBTTagCompound compound;
    @Nullable
    private UUID creatorUniqueId;

    public SpongeItemStackSnapshot(ItemStack itemStack) {
        Preconditions.checkNotNull(itemStack);
        if (itemStack == net.minecraft.item.ItemStack.field_190927_a) {
            this.itemType = null;
            this.quantity = 0;
            this.damageValue = 0;
            this.manipulators = ImmutableList.of();
            this.privateStack = itemStack;
            this.keys = ImmutableSet.of();
            this.values = ImmutableSet.of();
            this.compound = null;
            return;
        }
        this.itemType = itemStack.getType();
        this.quantity = itemStack.getQuantity();
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableSet.Builder keyBuilder = ImmutableSet.builder();
        ImmutableSet.Builder valueBuilder = ImmutableSet.builder();
        for (DataManipulator<?, ?> manipulator : ((CustomDataHolderBridge)((Object)itemStack)).bridge$getCustomManipulators()) {
            builder.add(manipulator.asImmutable());
            keyBuilder.addAll(manipulator.getKeys());
            valueBuilder.addAll(manipulator.getValues());
        }
        this.damageValue = ((net.minecraft.item.ItemStack)itemStack).func_77952_i();
        this.manipulators = builder.build();
        this.privateStack = itemStack.copy();
        this.keys = keyBuilder.build();
        this.values = valueBuilder.build();
        NBTTagCompound compound = ((net.minecraft.item.ItemStack)this.privateStack).func_77978_p();
        if (compound != null) {
            compound = compound.func_74737_b();
        }
        if (compound != null) {
            NBTTagCompound spongeCompound;
            if (compound.func_74764_b("SpongeData") && (spongeCompound = compound.func_74775_l("SpongeData")).func_74764_b("CustomManipulators")) {
                spongeCompound.func_82580_o("CustomManipulators");
            }
            Constants.NBT.filterSpongeCustomData(compound);
            this.compound = !compound.func_82582_d() ? compound : null;
        } else {
            this.compound = null;
        }
    }

    public SpongeItemStackSnapshot(ItemType itemType, int quantity, int damageValue, ImmutableList<ImmutableDataManipulator<?, ?>> manipulators, @Nullable NBTTagCompound compound) {
        this.itemType = Preconditions.checkNotNull(itemType);
        this.quantity = quantity;
        this.manipulators = Preconditions.checkNotNull(manipulators);
        this.damageValue = damageValue;
        this.privateStack = (ItemStack)new net.minecraft.item.ItemStack((Item)this.itemType, this.quantity, this.damageValue);
        ImmutableSet.Builder keyBuilder = ImmutableSet.builder();
        ImmutableSet.Builder valueBuilder = ImmutableSet.builder();
        for (ImmutableDataManipulator immutableDataManipulator : this.manipulators) {
            this.privateStack.offer(immutableDataManipulator.asMutable());
            keyBuilder.addAll(immutableDataManipulator.getKeys());
            valueBuilder.addAll(immutableDataManipulator.getValues());
        }
        this.keys = keyBuilder.build();
        this.values = valueBuilder.build();
        this.compound = compound == null ? null : compound.func_74737_b();
    }

    @Override
    public ItemType getType() {
        return this.itemType == null ? (ItemType)net.minecraft.item.ItemStack.field_190927_a.func_77973_b() : this.itemType;
    }

    @Override
    public int getQuantity() {
        return this.quantity;
    }

    @Override
    public boolean isEmpty() {
        return this.privateStack.isEmpty();
    }

    public boolean isNone() {
        return this == ItemTypeRegistryModule.getInstance().NONE_SNAPSHOT;
    }

    @Override
    public Translation getTranslation() {
        return this.privateStack.getTranslation();
    }

    @Override
    public ItemStack createStack() {
        net.minecraft.item.ItemStack nativeStack = ItemStackUtil.cloneDefensiveNative(ItemStackUtil.toNative(this.privateStack.copy()));
        if (this.compound != null) {
            nativeStack.func_77982_d(this.compound.func_74737_b());
        }
        for (ImmutableDataManipulator immutableDataManipulator : this.manipulators) {
            ((ItemStack)nativeStack).offer(immutableDataManipulator.asMutable());
        }
        return ItemStackUtil.fromNative(nativeStack);
    }

    @Override
    public List<ImmutableDataManipulator<?, ?>> getManipulators() {
        return this.manipulators;
    }

    @Override
    public int getContentVersion() {
        return 2;
    }

    @Override
    public DataContainer toContainer() {
        DataContainer container = DataContainer.createNew().set(Queries.CONTENT_VERSION, (Object)this.getContentVersion()).set(Constants.ItemStack.TYPE, (Object)(this.isNone() ? ItemTypes.NONE.getId() : this.itemType.getId())).set(Constants.ItemStack.COUNT, (Object)this.quantity).set(Constants.ItemStack.DAMAGE_VALUE, (Object)this.damageValue);
        if (!this.manipulators.isEmpty()) {
            container.set(Constants.Sponge.DATA_MANIPULATORS, DataUtil.getSerializedImmutableManipulatorList(this.manipulators));
        }
        if (this.compound != null) {
            container.set(Constants.Sponge.UNSAFE_NBT, (Object)NbtTranslator.getInstance().translateFrom(this.compound));
        }
        return container;
    }

    @Override
    public <T extends ImmutableDataManipulator<?, ?>> Optional<T> get(Class<T> containerClass) {
        Preconditions.checkNotNull(containerClass);
        for (ImmutableDataManipulator immutableDataManipulator : this.manipulators) {
            if (!containerClass.isInstance(immutableDataManipulator)) continue;
            return Optional.of(immutableDataManipulator);
        }
        return Optional.empty();
    }

    @Override
    public <T extends ImmutableDataManipulator<?, ?>> Optional<T> getOrCreate(Class<T> containerClass) {
        Optional manipulatorOptional;
        Optional<T> optional = this.get(containerClass);
        if (optional.isPresent()) {
            return optional;
        }
        Optional<DataProcessor> processorOptional = DataUtil.getWildImmutableProcessor(containerClass);
        if (processorOptional.isPresent() && (manipulatorOptional = processorOptional.get().createFrom(this.privateStack)).isPresent()) {
            return Optional.of(((DataManipulator)manipulatorOptional.get()).asImmutable());
        }
        return Optional.empty();
    }

    @Override
    public boolean supports(Class<? extends ImmutableDataManipulator<?, ?>> containerClass) {
        return false;
    }

    @Override
    public <E> Optional<ItemStackSnapshot> transform(Key<? extends BaseValue<E>> key, Function<E, E> function) {
        ItemStack copy = this.privateStack.copy();
        DataTransactionResult result = copy.transform(key, function);
        if (result.getType() != DataTransactionResult.Type.SUCCESS) {
            return Optional.empty();
        }
        return Optional.of(copy.createSnapshot());
    }

    @Override
    public <E> Optional<ItemStackSnapshot> with(Key<? extends BaseValue<E>> key, E value) {
        ItemStack copy = this.privateStack.copy();
        DataTransactionResult result = copy.offer(key, value);
        if (result.getType() != DataTransactionResult.Type.SUCCESS) {
            return Optional.empty();
        }
        return Optional.of(copy.createSnapshot());
    }

    @Override
    public Optional<ItemStackSnapshot> with(BaseValue<?> value) {
        return this.with(value.getKey(), value.get());
    }

    @Override
    public Optional<ItemStackSnapshot> with(ImmutableDataManipulator<?, ?> valueContainer) {
        Object manipulator = valueContainer.asMutable();
        ItemStack copyStack = this.privateStack.copy();
        DataTransactionResult result = copyStack.offer(manipulator);
        if (result.getType() != DataTransactionResult.Type.FAILURE) {
            return Optional.of(copyStack.createSnapshot());
        }
        return Optional.empty();
    }

    @Override
    public Optional<ItemStackSnapshot> with(Iterable<ImmutableDataManipulator<?, ?>> valueContainers) {
        ItemStack copy = this.privateStack.copy();
        for (ImmutableDataManipulator<?, ?> manipulator : valueContainers) {
            copy.offer(manipulator.asMutable());
        }
        return Optional.of(copy.createSnapshot());
    }

    @Override
    public Optional<ItemStackSnapshot> without(Class<? extends ImmutableDataManipulator<?, ?>> containerClass) {
        ItemStack copiedStack = this.privateStack.copy();
        Optional<DataProcessor> processorOptional = DataUtil.getWildImmutableProcessor(containerClass);
        if (processorOptional.isPresent()) {
            processorOptional.get().remove(copiedStack);
            return Optional.of(copiedStack.createSnapshot());
        }
        return Optional.empty();
    }

    @Override
    public ItemStackSnapshot merge(ItemStackSnapshot that) {
        return this.merge(that, MergeFunction.IGNORE_ALL);
    }

    @Override
    public ItemStackSnapshot merge(ItemStackSnapshot that, MergeFunction function) {
        ItemStack thisCopy = this.privateStack.copy();
        ItemStack thatCopy = that.createStack();
        for (DataManipulator<?, ?> manipulator : ((CustomDataHolderBridge)((Object)thatCopy)).bridge$getCustomManipulators()) {
            thisCopy.offer(manipulator, function);
        }
        return thisCopy.createSnapshot();
    }

    @Override
    public List<ImmutableDataManipulator<?, ?>> getContainers() {
        return this.manipulators;
    }

    @Override
    public <E> Optional<E> get(Key<? extends BaseValue<E>> key) {
        return this.privateStack.get(key);
    }

    @Override
    public <E, V extends BaseValue<E>> Optional<V> getValue(Key<V> key) {
        return this.privateStack.getValue(key);
    }

    @Override
    public boolean supports(Key<?> key) {
        return this.privateStack.supports(key);
    }

    @Override
    public ItemStackSnapshot copy() {
        return this;
    }

    @Override
    public Set<Key<?>> getKeys() {
        return this.keys;
    }

    @Override
    public Set<ImmutableValue<?>> getValues() {
        return this.values;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("itemType", this.isNone() ? ItemTypes.NONE.getId() : this.itemType.getId()).add("quantity", this.quantity).toString();
    }

    @Override
    public <T extends Property<?, ?>> Optional<T> getProperty(Class<T> propertyClass) {
        return this.privateStack.getProperty(propertyClass);
    }

    @Override
    public Collection<Property<?, ?>> getApplicableProperties() {
        return this.privateStack.getApplicableProperties();
    }

    public int getDamageValue() {
        return this.damageValue;
    }

    public Optional<NBTTagCompound> getCompound() {
        if (this.compound != null) {
            return Optional.of(this.compound.func_74737_b());
        }
        return Optional.empty();
    }

    @Override
    public GameDictionary.Entry createGameDictionaryEntry() {
        return new SpongeGameDictionaryEntry.Specific((Item)(this.isNone() ? ItemTypes.NONE : this.itemType), this.damageValue);
    }

    public Optional<UUID> getCreator() {
        return Optional.ofNullable(this.creatorUniqueId);
    }

    public void setCreator(@Nullable UUID uuid) {
        if (uuid != null) {
            this.creatorUniqueId = uuid;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeItemStackSnapshot that = (SpongeItemStackSnapshot)o;
        return this.quantity == that.quantity && this.damageValue == that.damageValue && Objects.equal(this.itemType, that.itemType) && Objects.equal(this.compound, that.compound) && Objects.equal(this.creatorUniqueId, that.creatorUniqueId);
    }

    public int hashCode() {
        return Objects.hashCode(this.itemType, this.quantity, this.damageValue, this.compound, this.creatorUniqueId);
    }
}

