/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.adapter.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.property.InventoryTitle;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TranslatableText;
import org.spongepowered.common.bridge.item.inventory.InventoryBridge;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.custom.CustomInventory;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;

public abstract class AdapterLogic {
    private AdapterLogic() {
    }

    public static Optional<ItemStack> pollSequential(InventoryAdapter adapter) {
        return AdapterLogic.pollSequential(adapter.bridge$getFabric(), adapter.bridge$getRootLens());
    }

    public static Optional<ItemStack> pollSequential(Fabric inv, Lens lens) {
        return AdapterLogic.findStack(inv, lens, true);
    }

    public static Optional<ItemStack> pollSequential(InventoryAdapter adapter, int limit) {
        return AdapterLogic.pollSequential(adapter.bridge$getFabric(), adapter.bridge$getRootLens(), limit);
    }

    public static Optional<ItemStack> pollSequential(Fabric inv, Lens lens, int limit) {
        return AdapterLogic.findStacks(inv, lens, limit, true);
    }

    public static Optional<ItemStack> peekSequential(InventoryAdapter adapter) {
        return AdapterLogic.peekSequential(adapter.bridge$getFabric(), adapter.bridge$getRootLens());
    }

    public static Optional<ItemStack> peekSequential(Fabric inv, Lens lens) {
        return AdapterLogic.findStack(inv, lens, false);
    }

    public static Optional<ItemStack> peekSequential(InventoryAdapter adapter, int limit) {
        return AdapterLogic.peekSequential(adapter.bridge$getFabric(), adapter.bridge$getRootLens(), limit);
    }

    public static Optional<ItemStack> peekSequential(Fabric inv, Lens lens, int limit) {
        return AdapterLogic.findStacks(inv, lens, limit, false);
    }

    private static Optional<ItemStack> findStack(Fabric inv, Lens lens, boolean remove) {
        if (lens == null) {
            return Optional.empty();
        }
        for (int ord = 0; ord < lens.slotCount(); ++ord) {
            net.minecraft.item.ItemStack stack = lens.getStack(inv, ord);
            if (stack.func_190926_b() || remove && !lens.setStack(inv, ord, net.minecraft.item.ItemStack.field_190927_a)) continue;
            return ItemStackUtil.cloneDefensiveOptional(stack);
        }
        return Optional.empty();
    }

    private static Optional<ItemStack> findStacks(Fabric inv, Lens lens, int limit, boolean remove) {
        if (lens == null) {
            return Optional.empty();
        }
        ItemStack result = null;
        for (int ord = 0; ord < lens.slotCount(); ++ord) {
            net.minecraft.item.ItemStack stack = lens.getStack(inv, ord);
            if (stack.func_190926_b() || stack.func_190916_E() < 1 || result != null && !result.getType().equals(stack.func_77973_b())) continue;
            if (result == null) {
                result = ItemStackUtil.cloneDefensive(stack, 0);
            }
            int pull = Math.min(stack.func_190916_E(), limit);
            result.setQuantity(result.getQuantity() + pull);
            limit -= pull;
            if (!remove) continue;
            if (pull >= stack.func_190916_E()) {
                lens.setStack(inv, ord, net.minecraft.item.ItemStack.field_190927_a);
                continue;
            }
            stack.func_190920_e(stack.func_190916_E() - pull);
        }
        if (remove && result != null && !result.isEmpty()) {
            inv.fabric$markDirty();
        }
        return Optional.ofNullable(result);
    }

    public static InventoryTransactionResult insertSequential(InventoryAdapter adapter, ItemStack stack) {
        return AdapterLogic.insertSequential(adapter.bridge$getFabric(), adapter.bridge$getRootLens(), stack);
    }

    public static InventoryTransactionResult insertSequential(Fabric inv, Lens lens, ItemStack stack) {
        if (lens == null) {
            return InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.FAILURE).reject(ItemStackUtil.cloneDefensive(stack)).build();
        }
        try {
            return AdapterLogic.insertStack(inv, lens, stack);
        }
        catch (Exception ex) {
            return InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.ERROR).reject(ItemStackUtil.cloneDefensive(stack)).build();
        }
    }

    private static InventoryTransactionResult insertStack(Fabric inv, Lens lens, ItemStack stack) {
        InventoryTransactionResult.Builder result = InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.SUCCESS);
        net.minecraft.item.ItemStack nativeStack = ItemStackUtil.toNative(stack);
        int maxStackSize = Math.min(lens.getMaxStackSize(inv), nativeStack.func_77976_d());
        int remaining = stack.getQuantity();
        for (int ord = 0; ord < lens.slotCount() && remaining > 0; ++ord) {
            net.minecraft.item.ItemStack old = lens.getStack(inv, ord);
            int push = Math.min(remaining, maxStackSize);
            if (!lens.setStack(inv, ord, ItemStackUtil.cloneDefensiveNative(nativeStack, push))) continue;
            result.replace(ItemStackUtil.fromNative(old));
            remaining -= push;
        }
        if (remaining > 0) {
            result.reject(ItemStackUtil.cloneDefensive(nativeStack, remaining));
        }
        inv.fabric$markDirty();
        return result.build();
    }

    public static InventoryTransactionResult appendSequential(InventoryAdapter adapter, ItemStack stack) {
        return AdapterLogic.appendSequential(adapter.bridge$getFabric(), adapter.bridge$getRootLens(), stack);
    }

    public static InventoryTransactionResult appendSequential(Fabric inv, Lens lens, ItemStack stack) {
        InventoryTransactionResult.Builder result = InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.SUCCESS);
        net.minecraft.item.ItemStack nativeStack = ItemStackUtil.toNative(stack);
        int maxStackSize = Math.min(lens.getMaxStackSize(inv), nativeStack.func_77976_d());
        int remaining = stack.getQuantity();
        for (int ord = 0; ord < lens.slotCount() && remaining > 0; ++ord) {
            net.minecraft.item.ItemStack old = lens.getStack(inv, ord);
            int push = Math.min(remaining, maxStackSize);
            if (old.func_190926_b() && lens.setStack(inv, ord, ItemStackUtil.cloneDefensiveNative(nativeStack, push))) {
                remaining -= push;
                continue;
            }
            if (old.func_190926_b() || !ItemStackUtil.compareIgnoreQuantity(old, stack)) continue;
            push = Math.max(Math.min(maxStackSize - old.func_190916_E(), remaining), 0);
            old.func_190920_e(old.func_190916_E() + push);
            remaining -= push;
        }
        if (remaining == stack.getQuantity()) {
            result.type(InventoryTransactionResult.Type.FAILURE).reject(ItemStackUtil.cloneDefensive(nativeStack));
        } else {
            stack.setQuantity(remaining);
            inv.fabric$markDirty();
        }
        return result.build();
    }

    public static int countStacks(InventoryAdapter adapter) {
        return AdapterLogic.countStacks(adapter.bridge$getFabric(), adapter.bridge$getRootLens());
    }

    public static int countStacks(Fabric inv, Lens lens) {
        int stacks = 0;
        for (int ord = 0; ord < lens.slotCount(); ++ord) {
            stacks += !lens.getStack(inv, ord).func_190926_b() ? 1 : 0;
        }
        return stacks;
    }

    public static int countItems(InventoryAdapter adapter) {
        return AdapterLogic.countItems(adapter.bridge$getFabric(), adapter.bridge$getRootLens());
    }

    public static int countItems(Fabric inv, Lens lens) {
        int items = 0;
        for (int ord = 0; ord < lens.slotCount(); ++ord) {
            net.minecraft.item.ItemStack stack = lens.getStack(inv, ord);
            items += stack.func_190916_E();
        }
        return items;
    }

    public static int getCapacity(InventoryAdapter adapter) {
        return AdapterLogic.getCapacity(adapter.bridge$getFabric(), adapter.bridge$getRootLens());
    }

    public static int getCapacity(Fabric inv, Lens lens) {
        return lens.getSlots().size();
    }

    public static Collection<InventoryProperty<?, ?>> getProperties(InventoryAdapter adapter, Inventory child, Class<? extends InventoryProperty<?, ?>> property) {
        return AdapterLogic.getProperties(adapter.bridge$getFabric(), adapter.bridge$getRootLens(), child, property);
    }

    public static Collection<InventoryProperty<?, ?>> getProperties(Fabric inv, Lens lens, Inventory child, Class<? extends InventoryProperty<?, ?>> property) {
        if (child instanceof InventoryAdapter) {
            Preconditions.checkNotNull(property, "property");
            int index = lens.getChildren().indexOf(((InventoryAdapter)((Object)child)).bridge$getRootLens());
            if (index > -1) {
                return lens.getProperties(index).stream().filter(prop -> property.equals(prop.getClass())).collect(Collectors.toCollection(ArrayList::new));
            }
        }
        return Collections.emptyList();
    }

    public static <T extends InventoryProperty<?, ?>> Collection<T> getRootProperties(InventoryAdapter adapter, Class<T> property) {
        if ((adapter = AdapterLogic.inventoryRoot(adapter)) instanceof CustomInventory) {
            return ((CustomInventory)((Object)adapter)).getProperties().values().stream().filter(p -> property.equals(p.getClass())).map(property::cast).collect(Collectors.toList());
        }
        return Streams.stream(AdapterLogic.findRootProperty(adapter, property)).collect(Collectors.toList());
    }

    public static <T extends InventoryProperty<?, ?>> Optional<T> getRootProperty(InventoryAdapter adapter, Class<T> property, Object key) {
        InventoryProperty<?, ?> forKey;
        if ((adapter = AdapterLogic.inventoryRoot(adapter)) instanceof CustomInventory && (forKey = ((CustomInventory)((Object)adapter)).getProperties().get(key)) != null && property.equals(forKey.getClass())) {
            return Optional.of(forKey);
        }
        return AdapterLogic.findRootProperty(adapter, property);
    }

    private static <T extends InventoryProperty<?, ?>> Optional<T> findRootProperty(InventoryAdapter adapter, Class<T> property) {
        if (property == InventoryTitle.class) {
            TranslatableText text = Text.of(adapter.bridge$getFabric().fabric$getDisplayName(), new Object[0]);
            return Optional.of(InventoryTitle.of(text));
        }
        return Optional.empty();
    }

    private static InventoryAdapter inventoryRoot(InventoryAdapter adapter) {
        InventoryBridge first;
        if ((adapter = (InventoryAdapter)((Object)((Inventory)((Object)adapter)).root())) instanceof Container && (first = adapter.bridge$getFabric().fabric$get(0)) instanceof CustomInventory) {
            adapter = (InventoryAdapter)((Object)first);
        }
        return adapter;
    }

    public static boolean contains(InventoryAdapter adapter, ItemStack stack) {
        return AdapterLogic.contains(adapter.bridge$getFabric(), adapter.bridge$getRootLens(), stack, stack.getQuantity());
    }

    public static boolean contains(InventoryAdapter adapter, ItemStack stack, int quantity) {
        return AdapterLogic.contains(adapter.bridge$getFabric(), adapter.bridge$getRootLens(), stack, quantity);
    }

    public static boolean contains(Fabric inv, Lens lens, ItemStack stack, int quantity) {
        net.minecraft.item.ItemStack nonNullStack = ItemStackUtil.toNative(stack);
        int found = 0;
        for (int ord = 0; ord < lens.slotCount(); ++ord) {
            net.minecraft.item.ItemStack slotStack = lens.getStack(inv, ord);
            if (!(slotStack.func_190926_b() ? nonNullStack.func_190926_b() && ++found >= quantity : ItemStackUtil.compareIgnoreQuantity(slotStack, stack) && (found += slotStack.func_190916_E()) >= quantity)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(InventoryAdapter adapter, ItemType type) {
        return AdapterLogic.contains(adapter.bridge$getFabric(), adapter.bridge$getRootLens(), type);
    }

    public static boolean contains(Fabric inv, Lens lens, ItemType type) {
        for (int ord = 0; ord < lens.slotCount(); ++ord) {
            net.minecraft.item.ItemStack slotStack = lens.getStack(inv, ord);
            if (!(slotStack.func_190926_b() ? type == null || type == ItemTypes.NONE : slotStack.func_77973_b() == type)) continue;
            return true;
        }
        return false;
    }

    public static boolean canFit(InventoryAdapter adapter, ItemStack stack) {
        Fabric inv = adapter.bridge$getFabric();
        Lens lens = adapter.bridge$getRootLens();
        net.minecraft.item.ItemStack nativeStack = ItemStackUtil.toNative(stack);
        int maxStackSize = Math.min(lens.getMaxStackSize(inv), nativeStack.func_77976_d());
        int remaining = stack.getQuantity();
        for (int ord = 0; ord < lens.slotCount() && remaining > 0; ++ord) {
            net.minecraft.item.ItemStack old = lens.getStack(inv, ord);
            int push = Math.min(remaining, maxStackSize);
            if (old.func_190926_b()) {
                remaining -= push;
                continue;
            }
            if (!ItemStackUtil.compareIgnoreQuantity(old, stack)) continue;
            push = Math.max(Math.min(maxStackSize - old.func_190916_E(), remaining), 0);
            remaining -= push;
        }
        return remaining == 0;
    }
}

