/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.adapter.impl;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.slots.SlotAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.slots.SlotLens;

public class SlotCollectionIterator
implements Iterable<Slot> {
    private Inventory parent;
    private final Fabric inv;
    private final List<Slot> slots;

    public SlotCollectionIterator(Inventory parent, Fabric inv, Lens lens, SlotProvider slots) {
        this.parent = parent;
        this.inv = inv;
        this.slots = this.traverseSpanningTree(inv, lens, slots, ImmutableList.builder()).build();
    }

    private ImmutableList.Builder<Slot> traverseSpanningTree(Fabric inv, Lens lens, SlotProvider slots, ImmutableList.Builder<Slot> list) {
        if (lens instanceof SlotLens) {
            list.add((Object)((SlotAdapter)lens.getAdapter(inv, this.parent)));
            return list;
        }
        for (Lens child : lens.getSpanningChildren()) {
            if (child instanceof SlotLens) {
                list.add((Object)((SlotAdapter)child.getAdapter(inv, this.parent)));
                continue;
            }
            if (child.getSpanningChildren().size() <= 0) continue;
            this.traverseSpanningTree(inv, child, slots, list);
        }
        return list;
    }

    public Fabric getFabric() {
        return this.inv;
    }

    @Override
    public Iterator<Slot> iterator() {
        return this.slots.iterator();
    }

    public static SlotCollectionIterator of(Inventory parent, InventoryAdapter adapter) {
        return new SlotCollectionIterator(parent, adapter.bridge$getFabric(), adapter.bridge$getRootLens(), adapter.bridge$getSlotProvider());
    }
}

