/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.generation;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackGenerator;

public final class SpongeItemStackGenerator
implements ItemStackGenerator {
    @Nullable
    final ItemType baseType;
    final List<BiConsumer<ItemStack.Builder, Random>> biConsumers;

    private SpongeItemStackGenerator(Builder builder) {
        this.biConsumers = ImmutableList.copyOf(builder.consumers);
        this.baseType = builder.baseItem;
    }

    @Override
    public ItemStack apply(Random random) {
        ItemStack.Builder builder = ItemStack.builder();
        if (this.baseType != null) {
            builder.itemType(this.baseType);
        }
        this.biConsumers.forEach(builderRandomBiConsumer -> builderRandomBiConsumer.accept(builder, random));
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeItemStackGenerator that = (SpongeItemStackGenerator)o;
        return Objects.equal(this.baseType, that.baseType) && Objects.equal(this.biConsumers, that.biConsumers);
    }

    public int hashCode() {
        return Objects.hashCode(this.baseType, this.biConsumers);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("baseType", this.baseType).add("biConsumers", this.biConsumers).toString();
    }

    public static final class Builder
    implements ItemStackGenerator.Builder {
        final List<BiConsumer<ItemStack.Builder, Random>> consumers = new ArrayList<BiConsumer<ItemStack.Builder, Random>>();
        @Nullable
        ItemType baseItem;

        @Override
        public Builder add(BiConsumer<ItemStack.Builder, Random> consumer) {
            this.consumers.add(Preconditions.checkNotNull(consumer, "Consumer cannot be null!"));
            return this;
        }

        @Override
        public Builder addAll(Collection<BiConsumer<ItemStack.Builder, Random>> collection) {
            this.consumers.addAll(Preconditions.checkNotNull(collection, "Collecton cannot be null!"));
            return this;
        }

        @Override
        public Builder baseItem(ItemType itemType) {
            this.baseItem = itemType;
            return this;
        }

        @Override
        public SpongeItemStackGenerator build() {
            Preconditions.checkState(this.baseItem != null || !this.consumers.isEmpty(), "Must have at least a defined amount of consumers or a base item type!");
            return new SpongeItemStackGenerator(this);
        }

        @Override
        public ItemStackGenerator.Builder from(ItemStackGenerator value) {
            this.reset();
            Preconditions.checkNotNull(value, "ItemStackGenerator cannot be null!");
            Preconditions.checkArgument(value instanceof SpongeItemStackGenerator, "Cannot use from on a non-Sponge implemented ItemStackGenerator!");
            SpongeItemStackGenerator generator = (SpongeItemStackGenerator)value;
            for (BiConsumer<ItemStack.Builder, Random> consumer : generator.biConsumers) {
                this.consumers.add(consumer);
            }
            this.baseItem = generator.baseType;
            return this;
        }

        @Override
        public Builder reset() {
            this.consumers.clear();
            this.baseItem = null;
            return this;
        }
    }
}

