/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.lens.impl;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.spongepowered.common.bridge.inventory.LensProviderBridge;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.ReusableLensInventoryAdapaterBridge;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.ReusableLensProvider;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.impl.DefaultEmptyLens;
import org.spongepowered.common.item.inventory.lens.impl.collections.SlotCollection;
import org.spongepowered.common.item.inventory.lens.impl.comp.OrderedInventoryLensImpl;

public class ReusableLens<T extends Lens> {
    private static Map<Class<? extends InventoryAdapter>, Map<Class<? extends Lens>, Int2ObjectMap<ReusableLens>>> reusableLenses = new IdentityHashMap<Class<? extends InventoryAdapter>, Map<Class<? extends Lens>, Int2ObjectMap<ReusableLens>>>();
    private final SlotProvider slots;
    private final T lens;

    private ReusableLens(SlotProvider slots, T lens) {
        this.slots = slots;
        this.lens = lens;
    }

    private ReusableLens(SlotProvider slots, Function<SlotProvider, T> lensProvider) {
        this.slots = slots;
        this.lens = (Lens)lensProvider.apply(slots);
    }

    public static <T extends Lens> ReusableLens<T> getLens(Class<T> lensType, InventoryAdapter adapter, Supplier<SlotProvider> slots, Function<SlotProvider, T> lens) {
        Map adapterLenses = reusableLenses.computeIfAbsent(adapter.getClass(), k -> new IdentityHashMap());
        Int2ObjectMap lenses = adapterLenses.computeIfAbsent(lensType, k -> new Int2ObjectOpenHashMap());
        return lenses.computeIfAbsent(adapter.bridge$getFabric().fabric$getSize(), k -> {
            SlotProvider sl = (SlotProvider)slots.get();
            return new ReusableLens(sl, lens);
        });
    }

    public static ReusableLens getLens(ReusableLensInventoryAdapaterBridge adapter) {
        if (adapter instanceof ReusableLensProvider) {
            return ((ReusableLensProvider)((Object)adapter)).bridge$generateReusableLens(adapter.bridge$getFabric(), adapter);
        }
        if (adapter instanceof LensProviderBridge) {
            SlotProvider slotProvider = ((LensProviderBridge)((Object)adapter)).bridge$slotProvider(adapter.bridge$getFabric(), adapter);
            adapter.bridge$setSlotProvider(slotProvider);
            Lens lens = ((LensProviderBridge)((Object)adapter)).bridge$rootLens(adapter.bridge$getFabric(), adapter);
            adapter.bridge$setLens(lens);
            return new ReusableLens<Lens>(slotProvider, lens);
        }
        return ReusableLens.getLens(Lens.class, adapter, () -> ReusableLens.defaultSlots(adapter), slots -> ReusableLens.defaultLens(adapter, slots));
    }

    private static SlotProvider defaultSlots(InventoryAdapter adapter) {
        return new SlotCollection.Builder().add(adapter.bridge$getFabric().fabric$getSize()).build();
    }

    private static Lens defaultLens(InventoryAdapter adapter, SlotProvider slots) {
        int slotCount = adapter.bridge$getFabric().fabric$getSize();
        if (slotCount == 0) {
            return new DefaultEmptyLens(adapter);
        }
        return new OrderedInventoryLensImpl(0, slotCount, slots);
    }

    public static ReusableLens<Lens> defaultReusableLens(InventoryAdapter adapter) {
        return ReusableLens.getLens(Lens.class, adapter, () -> ReusableLens.defaultSlots(adapter), slots -> ReusableLens.defaultLens(adapter, slots));
    }

    public SlotProvider getSlots() {
        return this.slots;
    }

    public T getLens() {
        return this.lens;
    }
}

