/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.crafting;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.crafting.CraftingGridInventory;
import org.spongepowered.api.item.recipe.crafting.CraftingRecipe;
import org.spongepowered.common.item.inventory.util.InventoryUtil;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;

public abstract class AbstractSpongeCraftingRecipe
implements CraftingRecipe,
IRecipe {
    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        return AbstractSpongeCraftingRecipe.matches(this::isValid, inv, worldIn);
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        return AbstractSpongeCraftingRecipe.getCraftingResult(this::getResult, inv);
    }

    public ItemStack func_77571_b() {
        return AbstractSpongeCraftingRecipe.getRecipeOutput(this::getExemplaryResult);
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        return AbstractSpongeCraftingRecipe.getRemainingItems(this::getRemainingItems, inv);
    }

    public static boolean matches(BiFunction<CraftingGridInventory, org.spongepowered.api.world.World, Boolean> isValid, InventoryCrafting inv, World worldIn) {
        return isValid.apply(InventoryUtil.toSpongeInventory(inv), (org.spongepowered.api.world.World)worldIn);
    }

    public static ItemStack getCraftingResult(Function<CraftingGridInventory, ItemStackSnapshot> getResult, InventoryCrafting inv) {
        ItemStackSnapshot result = getResult.apply(InventoryUtil.toSpongeInventory(inv));
        Preconditions.checkNotNull(result, "The Sponge implementation returned a `null` result.");
        return ItemStackUtil.fromSnapshotToNative(result);
    }

    public static ItemStack getRecipeOutput(Supplier<ItemStackSnapshot> getExemplaryResult) {
        return ItemStackUtil.fromSnapshotToNative(getExemplaryResult.get());
    }

    public static NonNullList<ItemStack> getRemainingItems(Function<CraftingGridInventory, List<ItemStackSnapshot>> getRemainingItems, InventoryCrafting inv) {
        List<ItemStackSnapshot> spongeResult = getRemainingItems.apply(InventoryUtil.toSpongeInventory(inv));
        if (spongeResult.size() != inv.func_70302_i_()) {
            throw new IllegalStateException("The number of ItemStackSnapshots returned by getRemainingItems must be equal to the size of the GridInventory.");
        }
        NonNullList result = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < spongeResult.size(); ++i) {
            ItemStack item = ItemStackUtil.fromSnapshotToNative(spongeResult.get(i));
            result.set(i, (Object)(item != null ? item : ItemStack.field_190927_a));
        }
        return result;
    }
}

