/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.crafting;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.recipe.crafting.ShapelessCraftingRecipe;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.item.recipe.crafting.IngredientUtil;
import org.spongepowered.common.item.recipe.crafting.SpongeShapelessRecipe;
import org.spongepowered.common.mixin.core.item.crafting.ShapelessRecipesAccessor;
import org.spongepowered.common.util.SpongeCatalogBuilder;

@NonnullByDefault
public class SpongeShapelessCraftingRecipeBuilder
extends SpongeCatalogBuilder<ShapelessCraftingRecipe, ShapelessCraftingRecipe.Builder>
implements ShapelessCraftingRecipe.Builder.EndStep,
ShapelessCraftingRecipe.Builder.ResultStep {
    private ItemStackSnapshot exemplaryResult = ItemStackSnapshot.NONE;
    private NonNullList<Ingredient> ingredients = NonNullList.func_191196_a();
    private String groupName = "";

    @Override
    public ShapelessCraftingRecipe.Builder.EndStep group(@Nullable String name) {
        this.groupName = name == null ? "" : name;
        return this;
    }

    @Override
    public ShapelessCraftingRecipe.Builder.EndStep name(Translation name) {
        return (ShapelessCraftingRecipe.Builder.EndStep)super.name(name);
    }

    @Override
    public ShapelessCraftingRecipe.Builder.EndStep name(String name) {
        return (ShapelessCraftingRecipe.Builder.EndStep)super.name(name);
    }

    @Override
    public ShapelessCraftingRecipe.Builder.EndStep id(String id) {
        return (ShapelessCraftingRecipe.Builder.EndStep)super.id(id);
    }

    @Override
    @Deprecated
    public ShapelessCraftingRecipe.Builder from(ShapelessCraftingRecipe value) {
        this.exemplaryResult = value.getExemplaryResult();
        if (this.exemplaryResult == null) {
            this.exemplaryResult = ItemStackSnapshot.NONE;
        }
        this.ingredients.clear();
        value.getIngredientPredicates().forEach(i -> this.ingredients.add((Object)IngredientUtil.toNative(i)));
        this.groupName = "";
        if (value instanceof ShapelessRecipes) {
            this.groupName = ((ShapelessRecipesAccessor)((Object)value)).accessor$getGroup();
        }
        super.reset();
        return this;
    }

    @Override
    protected ShapelessCraftingRecipe build(PluginContainer plugin, String id, Translation name) {
        Preconditions.checkState(this.exemplaryResult != null && this.exemplaryResult != ItemStackSnapshot.NONE, "The result is not set.");
        Preconditions.checkState(!this.ingredients.isEmpty(), "The ingredients are not set.");
        NonNullList ingredients = NonNullList.func_191196_a();
        ingredients.addAll(this.ingredients);
        return (ShapelessCraftingRecipe)((Object)new SpongeShapelessRecipe(plugin.getId() + ':' + id, this.groupName, ItemStackUtil.toNative(this.exemplaryResult.createStack()), (NonNullList<Ingredient>)ingredients));
    }

    @Override
    public ShapelessCraftingRecipe.Builder reset() {
        super.reset();
        this.exemplaryResult = ItemStackSnapshot.NONE;
        this.ingredients.clear();
        this.groupName = "";
        return this;
    }

    @Override
    public ShapelessCraftingRecipe.Builder.ResultStep addIngredient(org.spongepowered.api.item.recipe.crafting.Ingredient ingredient) {
        Preconditions.checkNotNull(ingredient, "ingredient");
        this.ingredients.add((Object)IngredientUtil.toNative(ingredient));
        return this;
    }

    @Override
    public ShapelessCraftingRecipe.Builder.EndStep result(ItemStackSnapshot result) {
        Preconditions.checkNotNull(result, "result");
        Preconditions.checkArgument(result != ItemStackSnapshot.NONE, "The result must not be `ItemStackSnapshot.NONE`.");
        this.exemplaryResult = result;
        return this;
    }

    @Override
    public ShapelessCraftingRecipe build(String id, Object plugin) {
        Preconditions.checkState(this.exemplaryResult != null && this.exemplaryResult != ItemStackSnapshot.NONE, "The result is not set.");
        Preconditions.checkState(!this.ingredients.isEmpty(), "The ingredients are not set.");
        Preconditions.checkNotNull(id, "id");
        Preconditions.checkNotNull(id, "plugin");
        PluginContainer container = SpongeImpl.getPluginContainer(plugin);
        if (!id.startsWith(container.getId() + ":")) {
            id = container.getId() + ":" + id;
        }
        return (ShapelessCraftingRecipe)((Object)new SpongeShapelessRecipe(id, this.groupName, ItemStackUtil.toNative(this.exemplaryResult.createStack()), this.ingredients));
    }
}

