/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.smelting;

import com.google.common.base.Preconditions;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;

public class MatchSmeltingVanillaItemStack
implements Predicate<ItemStackSnapshot> {
    private final ItemStackSnapshot itemStackSnapshot;

    public MatchSmeltingVanillaItemStack(ItemStackSnapshot itemStackSnapshot) {
        this.itemStackSnapshot = Preconditions.checkNotNull(itemStackSnapshot, "The itemStackSnapshot must not be null");
    }

    @Override
    public boolean test(ItemStackSnapshot itemStackSnapshot) {
        return MatchSmeltingVanillaItemStack.matchesVanillaItemStack(this.itemStackSnapshot, itemStackSnapshot);
    }

    public static boolean matchesVanillaItemStack(ItemStackSnapshot recipeStack, ItemStackSnapshot inventoryStack) {
        ItemStack recipe = ItemStackUtil.fromSnapshotToNative(recipeStack);
        ItemStack inventory = ItemStackUtil.fromSnapshotToNative(inventoryStack);
        return MatchSmeltingVanillaItemStack.compareItemStacks(inventory, recipe);
    }

    public static boolean compareItemStacks(@Nonnull ItemStack stack1, @Nonnull ItemStack stack2) {
        Preconditions.checkNotNull(stack1, "stack1");
        Preconditions.checkNotNull(stack2, "stack2");
        return stack2.func_77973_b() == stack1.func_77973_b() && (stack2.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == stack1.func_77960_j());
    }
}

