/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.smelting;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.recipe.smelting.SmeltingRecipe;
import org.spongepowered.api.item.recipe.smelting.SmeltingResult;
import org.spongepowered.api.text.translation.Translation;

public class SpongeSmeltingRecipe
implements SmeltingRecipe {
    private final ItemStackSnapshot exemplaryResult;
    private final ItemStackSnapshot exemplaryIngredient;
    private final Predicate<ItemStackSnapshot> ingredientPredicate;
    private final double experience;
    private final String id;
    private final Translation name;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name.get();
    }

    public SpongeSmeltingRecipe(String id, Translation name, ItemStackSnapshot exemplaryIngredient, Predicate<ItemStackSnapshot> ingredientPredicate, double experience, ItemStackSnapshot exemplaryResult) {
        Preconditions.checkNotNull(exemplaryResult, "exemplaryResult");
        Preconditions.checkArgument(exemplaryResult != ItemStackSnapshot.NONE, "The result must not be ItemStackSnapshot.NONE.");
        Preconditions.checkNotNull(exemplaryIngredient, "exemplaryIngredient");
        Preconditions.checkArgument(exemplaryIngredient != ItemStackSnapshot.NONE, "The ingredient must not be ItemStackSnapshot.NONE.");
        Preconditions.checkNotNull(ingredientPredicate, "ingredientPredicate");
        Preconditions.checkArgument(ingredientPredicate.test(exemplaryIngredient), "The ingredient predicate does not allow the specified exemplary ingredient.");
        this.id = id;
        this.name = name;
        this.exemplaryResult = exemplaryResult;
        this.exemplaryIngredient = exemplaryIngredient;
        this.ingredientPredicate = ingredientPredicate;
        this.experience = Math.max(0.0, experience);
    }

    @Override
    @Nonnull
    public ItemStackSnapshot getExemplaryResult() {
        return this.exemplaryResult;
    }

    @Override
    @Nonnull
    public ItemStackSnapshot getExemplaryIngredient() {
        return this.exemplaryIngredient;
    }

    @Override
    public boolean isValid(@Nonnull ItemStackSnapshot ingredient) {
        return this.ingredientPredicate.test(ingredient);
    }

    @Override
    @Nonnull
    public Optional<SmeltingResult> getResult(@Nonnull ItemStackSnapshot ingredient) {
        if (this.isValid(ingredient)) {
            return Optional.of(new SmeltingResult(this.exemplaryResult, this.experience));
        }
        return Optional.empty();
    }
}

