/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.smelting;

import com.google.common.base.Preconditions;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.recipe.smelting.SmeltingRecipe;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.common.item.recipe.smelting.MatchSmeltingVanillaItemStack;
import org.spongepowered.common.item.recipe.smelting.SpongeSmeltingRecipe;
import org.spongepowered.common.util.SpongeCatalogBuilder;

@NonnullByDefault
public class SpongeSmeltingRecipeBuilder
extends SpongeCatalogBuilder<SmeltingRecipe, SmeltingRecipe.Builder>
implements SmeltingRecipe.Builder.ResultStep,
SmeltingRecipe.Builder.EndStep {
    @Nullable
    private ItemStackSnapshot exemplaryResult;
    @Nullable
    private ItemStackSnapshot exemplaryIngredient;
    @Nullable
    private Predicate<ItemStackSnapshot> ingredientPredicate;
    private double experience;

    @Override
    public SmeltingRecipe.Builder from(SmeltingRecipe value) {
        Preconditions.checkNotNull(value, "value");
        this.exemplaryResult = value.getExemplaryResult();
        this.exemplaryIngredient = value.getExemplaryIngredient();
        this.experience = 0.0;
        super.reset();
        return this;
    }

    @Override
    public SmeltingRecipe.Builder reset() {
        super.reset();
        this.exemplaryResult = null;
        this.exemplaryIngredient = null;
        this.experience = 0.0;
        return this;
    }

    @Override
    public SmeltingRecipe.Builder.EndStep result(ItemStackSnapshot result) {
        Preconditions.checkNotNull(result, "result");
        Preconditions.checkArgument(result != ItemStackSnapshot.NONE, "The result must not be ItemStackSnapshot.NONE.");
        this.exemplaryResult = result;
        return this;
    }

    @Override
    public SmeltingRecipe.Builder.ResultStep ingredient(Predicate<ItemStackSnapshot> ingredientPredicate, ItemStackSnapshot exemplaryIngredient) {
        Preconditions.checkNotNull(ingredientPredicate, "ingredientPredicate");
        Preconditions.checkNotNull(exemplaryIngredient, "exemplaryIngredient");
        Preconditions.checkArgument(exemplaryIngredient != ItemStackSnapshot.NONE, "The ingredient must not be ItemStackSnapshot.NONE.");
        Preconditions.checkState(ingredientPredicate.test(exemplaryIngredient), "The ingredient predicate does not allow the specified exemplary ingredient.");
        this.ingredientPredicate = ingredientPredicate;
        this.exemplaryIngredient = exemplaryIngredient;
        return this;
    }

    @Override
    public SmeltingRecipe.Builder.ResultStep ingredient(ItemStackSnapshot ingredient) {
        Preconditions.checkNotNull(ingredient, "ingredient");
        return this.ingredient(new MatchSmeltingVanillaItemStack(ingredient), ingredient);
    }

    @Override
    public SmeltingRecipe.Builder.EndStep experience(double experience) {
        Preconditions.checkState(experience >= 0.0, "The experience must be non-negative.");
        this.experience = experience;
        return this;
    }

    @Override
    public SmeltingRecipe.Builder.EndStep name(String name) {
        return (SmeltingRecipe.Builder.EndStep)super.name(name);
    }

    @Override
    public SmeltingRecipe.Builder.EndStep name(Translation name) {
        return (SmeltingRecipe.Builder.EndStep)super.name(name);
    }

    @Override
    public SmeltingRecipe.Builder.EndStep id(String id) {
        return (SmeltingRecipe.Builder.EndStep)super.id(id);
    }

    @Override
    public SmeltingRecipe build() {
        Preconditions.checkState(this.exemplaryResult != null && this.exemplaryResult != ItemStackSnapshot.NONE, "The result must be specified.");
        Preconditions.checkState(this.exemplaryIngredient != null && this.exemplaryIngredient != ItemStackSnapshot.NONE, "The ingredient must be specified.");
        Preconditions.checkState(this.ingredientPredicate != null, "You must specify the ingredient predicate.");
        Preconditions.checkState(this.ingredientPredicate.test(this.exemplaryIngredient), "The ingredient predicate does not allow the specified exemplary ingredient.");
        Preconditions.checkState(this.experience >= 0.0, "The experience must be non-negative.");
        String id = null;
        if (this.id != null) {
            PluginContainer plugin = Sponge.getCauseStackManager().getCurrentCause().first(PluginContainer.class).orElseThrow(() -> new IllegalStateException("Couldn't find a PluginContainer in the cause stack."));
            id = plugin.getId() + ':' + this.id;
        }
        return new SpongeSmeltingRecipe(id, this.name, this.exemplaryIngredient, this.ingredientPredicate, this.experience, this.exemplaryResult);
    }

    @Override
    protected SmeltingRecipe build(PluginContainer plugin, String id, Translation name) {
        throw new IllegalStateException("Overridden");
    }
}

