/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.authlib;

import com.google.common.collect.Multimap;
import com.mojang.authlib.properties.PropertyMap;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.profile.property.ProfileProperty;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.util.Constants;

@Mixin(value={com.mojang.authlib.GameProfile.class}, remap=false)
@Implements(value={@Interface(iface=GameProfile.class, prefix="profile$")})
public abstract class GameProfileMixin_API
implements GameProfile {
    @Shadow
    public abstract UUID getId();

    @Nullable
    @Shadow
    public abstract String shadow$getName();

    @Shadow
    public abstract PropertyMap getProperties();

    @Shadow
    public abstract boolean isComplete();

    @Override
    public UUID getUniqueId() {
        return this.getId();
    }

    @Override
    public Optional<String> getName() {
        return Optional.ofNullable(this.shadow$getName());
    }

    @Override
    public Multimap<String, ProfileProperty> getPropertyMap() {
        return this.getProperties();
    }

    @Override
    public boolean isFilled() {
        return this.isComplete();
    }

    @Override
    public int getContentVersion() {
        return 0;
    }

    @Override
    public DataContainer toContainer() {
        DataContainer container = DataContainer.createNew();
        container.set(Queries.CONTENT_VERSION, (Object)this.getContentVersion());
        container.set(Constants.Entity.Player.UUID, (Object)this.getUniqueId().toString());
        this.getName().ifPresent(name -> container.set(Constants.Entity.Player.NAME, name));
        return container;
    }
}

