/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.block.state;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.trait.BlockTrait;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.Property;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.merge.MergeFunction;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.util.Cycleable;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.Location;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.VecHelper;

@Mixin(value={IBlockState.class})
public interface IBlockStateMixin_API
extends IBlockState,
BlockState {
    @Override
    default public BlockType getType() {
        return (BlockType)this.func_177230_c();
    }

    @Override
    default public BlockState withExtendedProperties(Location<org.spongepowered.api.world.World> location) {
        return (BlockState)this.func_185899_b((IBlockAccess)((World)location.getExtent()), VecHelper.toBlockPos(location));
    }

    @Override
    default public BlockState cycleValue(Key<? extends BaseValue<? extends Cycleable<?>>> key) {
        return this;
    }

    @Override
    default public <T extends Comparable<T>> Optional<T> getTraitValue(BlockTrait<T> blockTrait) {
        for (Map.Entry entry : this.func_177228_b().entrySet()) {
            if (entry.getKey() != blockTrait) continue;
            return Optional.of((Comparable)entry.getValue());
        }
        return Optional.empty();
    }

    @Override
    default public Optional<BlockTrait<?>> getTrait(String blockTrait) {
        for (IProperty property : this.func_177228_b().keySet()) {
            if (!property.func_177701_a().equalsIgnoreCase(blockTrait)) continue;
            return Optional.of((BlockTrait)property);
        }
        return Optional.empty();
    }

    @Override
    default public Optional<BlockState> withTrait(BlockTrait<?> trait, Object value) {
        if (value instanceof String) {
            Comparable foundValue = null;
            for (Comparable comparable : trait.getPossibleValues()) {
                if (!comparable.toString().equals(value)) continue;
                foundValue = comparable;
                break;
            }
            if (foundValue != null) {
                return Optional.of((BlockState)this.func_177226_a((IProperty)trait, foundValue));
            }
        }
        if (value instanceof Comparable && this.func_177228_b().containsKey((IProperty)trait) && ((IProperty)trait).func_177700_c().contains(value)) {
            return Optional.of((BlockState)this.func_177226_a((IProperty)trait, (Comparable)value));
        }
        return Optional.empty();
    }

    @Override
    default public Collection<BlockTrait<?>> getTraits() {
        return this.getTraitMap().keySet();
    }

    @Override
    default public Collection<?> getTraitValues() {
        return this.getTraitMap().values();
    }

    @Override
    default public Map<BlockTrait<?>, ?> getTraitMap() {
        return this.func_177228_b();
    }

    @Override
    default public String getId() {
        StringBuilder builder = new StringBuilder();
        builder.append(((BlockType)this.func_177230_c()).getId());
        ImmutableMap properties = this.func_177228_b();
        if (!properties.isEmpty()) {
            builder.append('[');
            Joiner joiner = Joiner.on(',');
            ArrayList<String> propertyValues = new ArrayList<String>();
            for (Map.Entry entry : properties.entrySet()) {
                propertyValues.add(((IProperty)entry.getKey()).func_177701_a() + "=" + entry.getValue());
            }
            builder.append(joiner.join(propertyValues));
            builder.append(']');
        }
        return builder.toString();
    }

    @Override
    default public String getName() {
        return this.getId();
    }

    @Override
    default public <T extends Property<?, ?>> Optional<T> getProperty(Direction direction, Class<T> clazz) {
        return Optional.empty();
    }

    @Override
    default public List<ImmutableDataManipulator<?, ?>> getManipulators() {
        return Collections.emptyList();
    }

    @Override
    default public int getContentVersion() {
        return 2;
    }

    @Override
    default public DataContainer toContainer() {
        return DataContainer.createNew().set(Queries.CONTENT_VERSION, (Object)this.getContentVersion()).set(Constants.Block.BLOCK_STATE, (Object)this.getId());
    }

    @Override
    default public <T extends ImmutableDataManipulator<?, ?>> Optional<T> get(Class<T> containerClass) {
        return Optional.empty();
    }

    @Override
    default public <T extends ImmutableDataManipulator<?, ?>> Optional<T> getOrCreate(Class<T> containerClass) {
        return Optional.empty();
    }

    @Override
    default public boolean supports(Class<? extends ImmutableDataManipulator<?, ?>> containerClass) {
        return false;
    }

    @Override
    default public <E> Optional<BlockState> transform(Key<? extends BaseValue<E>> key, Function<E, E> function) {
        return Optional.empty();
    }

    @Override
    default public <E> Optional<BlockState> with(Key<? extends BaseValue<E>> key, E value) {
        return Optional.empty();
    }

    @Override
    default public Optional<BlockState> with(BaseValue<?> value) {
        return Optional.empty();
    }

    @Override
    default public Optional<BlockState> with(ImmutableDataManipulator<?, ?> valueContainer) {
        return Optional.empty();
    }

    @Override
    default public Optional<BlockState> with(Iterable<ImmutableDataManipulator<?, ?>> valueContainers) {
        return Optional.empty();
    }

    @Override
    default public Optional<BlockState> without(Class<? extends ImmutableDataManipulator<?, ?>> containerClass) {
        return Optional.empty();
    }

    @Override
    default public BlockState merge(BlockState that) {
        return this;
    }

    @Override
    default public BlockState merge(BlockState that, MergeFunction function) {
        return this;
    }

    @Override
    default public List<ImmutableDataManipulator<?, ?>> getContainers() {
        return Collections.emptyList();
    }

    @Override
    default public <T extends Property<?, ?>> Optional<T> getProperty(Class<T> propertyClass) {
        return Optional.empty();
    }

    @Override
    default public Collection<Property<?, ?>> getApplicableProperties() {
        return Collections.emptyList();
    }

    @Override
    default public <E> Optional<E> get(Key<? extends BaseValue<E>> key) {
        return Optional.empty();
    }

    @Override
    default public <E, V extends BaseValue<E>> Optional<V> getValue(Key<V> key) {
        return Optional.empty();
    }

    @Override
    default public boolean supports(Key<?> key) {
        return false;
    }

    @Override
    default public BlockState copy() {
        return this;
    }

    @Override
    default public Set<Key<?>> getKeys() {
        return Collections.emptySet();
    }

    @Override
    default public Set<ImmutableValue<?>> getValues() {
        return Collections.emptySet();
    }
}

