/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.bridge.data.CustomDataHolderBridge;
import org.spongepowered.common.bridge.item.ItemBridge;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.item.inventory.SpongeItemStackSnapshot;
import org.spongepowered.common.text.translation.SpongeTranslation;
import org.spongepowered.common.util.Constants;

@Mixin(value={net.minecraft.item.ItemStack.class})
@Implements(value={@Interface(iface=ItemStack.class, prefix="apiStack$")})
public abstract class ItemStackMixin_API
implements DataHolder {
    @Shadow
    public abstract int func_190916_E();

    @Shadow
    public abstract void func_190920_e(int var1);

    @Shadow
    public abstract void func_77964_b(int var1);

    @Shadow
    public abstract void func_77982_d(@Nullable NBTTagCompound var1);

    @Shadow
    public abstract int func_77952_i();

    @Shadow
    public abstract int func_77976_d();

    @Shadow
    public abstract boolean func_77942_o();

    @Shadow
    public abstract boolean shadow$func_190926_b();

    @Shadow
    public abstract NBTTagCompound func_77978_p();

    @Shadow
    public abstract net.minecraft.item.ItemStack shadow$func_77946_l();

    @Shadow
    public abstract Item shadow$func_77973_b();

    public int apiStack$getQuantity() {
        return this.func_190916_E();
    }

    public ItemType apiStack$getType() {
        return (ItemType)this.shadow$func_77973_b();
    }

    public void apiStack$setQuantity(int quantity) throws IllegalArgumentException {
        this.func_190920_e(quantity);
    }

    public int apiStack$getMaxStackQuantity() {
        return this.func_77976_d();
    }

    @Override
    public boolean validateRawData(DataView container) {
        return false;
    }

    @Override
    public void setRawData(DataView container) throws InvalidDataException {
        if (this.shadow$func_190926_b()) {
            throw new IllegalArgumentException("Cannot set data on empty item stacks!");
        }
        if (!container.contains(Constants.Sponge.UNSAFE_NBT)) {
            throw new InvalidDataException("There's no NBT Data set in the provided container");
        }
        DataView nbtData = container.getView(Constants.Sponge.UNSAFE_NBT).get();
        try {
            int integer = container.getInt(Constants.ItemStack.DAMAGE_VALUE).orElse(this.func_77952_i());
            this.func_77964_b(integer);
            NBTTagCompound stackCompound = NbtTranslator.getInstance().translate(nbtData);
            this.func_77982_d(stackCompound);
        }
        catch (Exception e) {
            throw new InvalidDataException("Unable to set raw data or translate raw data for ItemStack setting", e);
        }
    }

    @Override
    public DataHolder copy() {
        return this.apiStack$copy();
    }

    public ItemStack apiStack$copy() {
        return (ItemStack)this.shadow$func_77946_l();
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        Collection<DataManipulator<?, ?>> manipulators;
        DataContainer container = DataContainer.createNew().set(Queries.CONTENT_VERSION, (Object)this.getContentVersion()).set(Constants.ItemStack.TYPE, (Object)this.apiStack$getType().getId()).set(Constants.ItemStack.COUNT, (Object)this.apiStack$getQuantity()).set(Constants.ItemStack.DAMAGE_VALUE, (Object)this.func_77952_i());
        if (this.func_77942_o()) {
            NBTTagCompound spongeCompound;
            NBTTagCompound compound = this.func_77978_p().func_74737_b();
            if (compound.func_74764_b("SpongeData") && (spongeCompound = compound.func_74775_l("SpongeData")).func_74764_b("CustomManipulators")) {
                spongeCompound.func_82580_o("CustomManipulators");
            }
            Constants.NBT.filterSpongeCustomData(compound);
            if (!compound.func_82582_d()) {
                DataContainer unsafeNbt = NbtTranslator.getInstance().translateFrom(compound);
                container.set(Constants.Sponge.UNSAFE_NBT, (Object)unsafeNbt);
            }
        }
        if (!(manipulators = ((CustomDataHolderBridge)((Object)this)).bridge$getCustomManipulators()).isEmpty()) {
            container.set(Constants.Sponge.DATA_MANIPULATORS, DataUtil.getSerializedManipulatorList(manipulators));
        }
        try {
            SpongeImplHooks.writeItemStackCapabilitiesToDataView(container, (net.minecraft.item.ItemStack)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return container;
    }

    public Translation apiStack$getTranslation() {
        return new SpongeTranslation(this.shadow$func_77973_b().func_77667_c((net.minecraft.item.ItemStack)this) + ".name");
    }

    public ItemStackSnapshot apiStack$createSnapshot() {
        return new SpongeItemStackSnapshot((ItemStack)((Object)this));
    }

    public boolean apiStack$equalTo(ItemStack that) {
        return net.minecraft.item.ItemStack.func_77989_b((net.minecraft.item.ItemStack)((net.minecraft.item.ItemStack)this), (net.minecraft.item.ItemStack)((net.minecraft.item.ItemStack)that));
    }

    @Intrinsic
    public boolean apiStack$isEmpty() {
        return this.shadow$func_190926_b();
    }

    @Override
    public Collection<DataManipulator<?, ?>> getContainers() {
        if (this.shadow$func_190926_b()) {
            return Lists.newArrayList();
        }
        ArrayList<DataManipulator<?, ?>> manipulators = Lists.newArrayList();
        Item item = this.shadow$func_77973_b();
        if (item == null) {
            PrettyPrinter printer = new PrettyPrinter(60);
            printer.add("Null Item found!").centre().hr();
            printer.add("An ItemStack has a null ItemType! This is usually not supported as it will likely have issues elsewhere.");
            printer.add("Please ask help for seeing if this is an issue with a mod and report it!");
            printer.add("Printing a Stacktrace:");
            printer.add(new Exception());
            printer.log(SpongeImpl.getLogger(), Level.WARN);
            return manipulators;
        }
        ((ItemBridge)item).bridge$gatherManipulators((net.minecraft.item.ItemStack)this, manipulators);
        if (((CustomDataHolderBridge)((Object)this)).bridge$hasManipulators()) {
            Collection<DataManipulator<?, ?>> customManipulators = ((CustomDataHolderBridge)((Object)this)).bridge$getCustomManipulators();
            manipulators.addAll(customManipulators);
        }
        return manipulators;
    }
}

