/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.server.management;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.Agent;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;
import net.minecraft.server.management.PlayerProfileCache;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.profile.GameProfileCache;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.mixin.core.server.management.PlayerProfileCache_ProfileEntryAccessor;
import org.spongepowered.common.profile.callback.MapProfileLookupCallback;
import org.spongepowered.common.profile.callback.SingleProfileLookupCallback;

@Mixin(value={PlayerProfileCache.class})
public abstract class PlayerProfileCacheMixin_API
implements GameProfileCache {
    @Shadow
    @Final
    private Map<String, PlayerProfileCache_ProfileEntryAccessor> field_152661_c;
    @Shadow
    @Final
    private Map<UUID, PlayerProfileCache_ProfileEntryAccessor> field_152662_d;
    private Queue<com.mojang.authlib.GameProfile> profiles = new ConcurrentLinkedQueue<com.mojang.authlib.GameProfile>();

    @Nullable
    @Shadow
    public abstract com.mojang.authlib.GameProfile func_152652_a(UUID var1);

    @Shadow
    public abstract void func_152658_c();

    @Shadow
    private void func_152651_a(com.mojang.authlib.GameProfile profile, @Nullable Date expiry) {
    }

    @Override
    public boolean add(GameProfile profile, boolean overwrite, @Nullable Instant expiry) {
        Preconditions.checkNotNull(profile, "profile");
        if (this.field_152662_d.containsKey(profile.getUniqueId()) && !overwrite) {
            return false;
        }
        this.func_152651_a((com.mojang.authlib.GameProfile)((Object)profile), expiry == null ? null : new Date(expiry.toEpochMilli()));
        return true;
    }

    @Override
    public boolean remove(GameProfile profile) {
        Preconditions.checkNotNull(profile, "profile");
        UUID uniqueId = profile.getUniqueId();
        if (this.field_152662_d.containsKey(uniqueId)) {
            this.field_152662_d.remove(uniqueId);
            this.profiles.remove(profile);
            if (profile.getName().isPresent()) {
                this.field_152661_c.remove(profile.getName().get().toLowerCase(Locale.ROOT));
            }
            return true;
        }
        return false;
    }

    @Override
    public Collection<GameProfile> remove(Iterable<GameProfile> profiles) {
        Preconditions.checkNotNull(profiles, "profiles");
        ArrayList<GameProfile> result = Lists.newArrayList();
        for (GameProfile profile : profiles) {
            if (!this.remove(profile)) continue;
            result.add(profile);
        }
        return result;
    }

    @Override
    public void clear() {
        this.field_152662_d.clear();
        this.profiles.clear();
        this.field_152661_c.clear();
        this.func_152658_c();
    }

    @Override
    public Optional<GameProfile> getById(UUID uniqueId) {
        return Optional.ofNullable((GameProfile)((Object)this.func_152652_a(Preconditions.checkNotNull(uniqueId, "unique id"))));
    }

    @Override
    public Map<UUID, Optional<GameProfile>> getByIds(Iterable<UUID> uniqueIds) {
        Preconditions.checkNotNull(uniqueIds, "unique ids");
        HashMap<UUID, Optional<GameProfile>> result = Maps.newHashMap();
        for (UUID uniqueId : uniqueIds) {
            result.put(uniqueId, Optional.ofNullable((GameProfile)((Object)this.func_152652_a(uniqueId))));
        }
        return result.isEmpty() ? ImmutableMap.of() : ImmutableMap.copyOf(result);
    }

    @Override
    public Optional<GameProfile> lookupById(UUID uniqueId) {
        Preconditions.checkNotNull(uniqueId, "unique id");
        com.mojang.authlib.GameProfile profile = SpongeImpl.getServer().func_147130_as().fillProfileProperties(new com.mojang.authlib.GameProfile(uniqueId, ""), true);
        if (profile != null && profile.getName() != null && !profile.getName().isEmpty()) {
            this.func_152651_a(profile, null);
            return Optional.of((GameProfile)((Object)profile));
        }
        return Optional.empty();
    }

    @Override
    public Map<UUID, Optional<GameProfile>> lookupByIds(Iterable<UUID> uniqueIds) {
        Preconditions.checkNotNull(uniqueIds, "unique ids");
        HashMap result = Maps.newHashMap();
        MinecraftSessionService service = SpongeImpl.getServer().func_147130_as();
        for (UUID uniqueId : uniqueIds) {
            com.mojang.authlib.GameProfile profile = service.fillProfileProperties(new com.mojang.authlib.GameProfile(uniqueId, ""), true);
            if (profile != null && profile.getName() != null && !profile.getName().isEmpty()) {
                this.func_152651_a(profile, null);
                result.put(uniqueId, Optional.of((GameProfile)((Object)profile)));
                continue;
            }
            this.func_152651_a(new com.mojang.authlib.GameProfile(uniqueId, "[sponge]"), null);
            result.put(uniqueId, Optional.empty());
        }
        return result.isEmpty() ? ImmutableMap.of() : ImmutableMap.copyOf(result);
    }

    @Override
    public Optional<GameProfile> getOrLookupById(UUID uniqueId) {
        Optional<GameProfile> profile = this.getById(uniqueId);
        if (profile.isPresent()) {
            return profile;
        }
        return this.lookupById(uniqueId);
    }

    @Override
    public Map<UUID, Optional<GameProfile>> getOrLookupByIds(Iterable<UUID> uniqueIds) {
        Preconditions.checkNotNull(uniqueIds, "unique ids");
        HashSet<UUID> pending = Sets.newHashSet(uniqueIds);
        HashMap<UUID, Optional<GameProfile>> result = Maps.newHashMap();
        result.putAll(this.getByIds(pending));
        result.forEach((uniqueId, profile) -> {
            if (profile.isPresent()) {
                pending.remove(uniqueId);
            }
        });
        result.putAll(this.lookupByIds(pending));
        return ImmutableMap.copyOf(result);
    }

    @Override
    public Optional<GameProfile> getByName(String name) {
        return Optional.ofNullable((GameProfile)((Object)this.getByNameNoLookup(Preconditions.checkNotNull(name, "name"))));
    }

    @Override
    public Map<String, Optional<GameProfile>> getByNames(Iterable<String> names) {
        Preconditions.checkNotNull(names, "names");
        HashMap<String, Optional<GameProfile>> result = Maps.newHashMap();
        for (String name : names) {
            result.put(name, Optional.ofNullable((GameProfile)((Object)this.getByNameNoLookup(name))));
        }
        return result.isEmpty() ? ImmutableMap.of() : ImmutableMap.copyOf(result);
    }

    @Override
    public Optional<GameProfile> lookupByName(String name) {
        SingleProfileLookupCallback callback = new SingleProfileLookupCallback();
        SpongeImpl.getServer().func_152359_aw().findProfilesByNames(new String[]{name}, Agent.MINECRAFT, callback);
        Optional<GameProfile> profile = callback.getResult();
        if (profile.isPresent()) {
            this.func_152651_a((com.mojang.authlib.GameProfile)((Object)profile.get()), null);
        }
        return profile;
    }

    @Override
    public Map<String, Optional<GameProfile>> lookupByNames(Iterable<String> names) {
        Preconditions.checkNotNull(names, "names");
        HashMap<String, Optional<GameProfile>> result = Maps.newHashMap();
        SpongeImpl.getServer().func_152359_aw().findProfilesByNames(Iterables.toArray(names, String.class), Agent.MINECRAFT, new MapProfileLookupCallback(result));
        if (!result.isEmpty()) {
            for (Optional entry : result.values()) {
                if (!entry.isPresent()) continue;
                this.func_152651_a((com.mojang.authlib.GameProfile)entry.get(), null);
            }
            return ImmutableMap.copyOf(result);
        }
        return ImmutableMap.of();
    }

    @Override
    public Optional<GameProfile> getOrLookupByName(String name) {
        Optional<GameProfile> profile = this.getByName(name);
        if (profile.isPresent()) {
            return profile;
        }
        return this.lookupByName(name);
    }

    @Override
    public Map<String, Optional<GameProfile>> getOrLookupByNames(Iterable<String> names) {
        Preconditions.checkNotNull(names, "names");
        HashSet<String> pending = Sets.newHashSet(names);
        HashMap<String, Optional> result = Maps.newHashMap();
        result.putAll(this.getByNames(pending));
        result.forEach((name, profile) -> {
            if (profile.isPresent()) {
                pending.remove(name);
            }
        });
        pending.forEach(name -> result.put((String)name, this.lookupByName((String)name)));
        return ImmutableMap.copyOf(result);
    }

    @Override
    public Optional<GameProfile> fillProfile(GameProfile profile, boolean signed) {
        Preconditions.checkNotNull(profile, "profile");
        return Optional.ofNullable((GameProfile)((Object)SpongeImpl.getServer().func_147130_as().fillProfileProperties((com.mojang.authlib.GameProfile)((Object)profile), signed)));
    }

    @Override
    public Collection<GameProfile> getProfiles() {
        return this.field_152661_c.values().stream().map(entry -> (GameProfile)((Object)entry.accessor$getGameProfile())).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public Collection<GameProfile> match(String name) {
        String search = Preconditions.checkNotNull(name, "name").toLowerCase(Locale.ROOT);
        return this.getProfiles().stream().filter(profile -> profile.getName().isPresent()).filter(profile -> profile.getName().get().toLowerCase(Locale.ROOT).startsWith(search)).collect(ImmutableSet.toImmutableSet());
    }

    @Nullable
    private com.mojang.authlib.GameProfile getByNameNoLookup(String username) {
        com.mojang.authlib.GameProfile profile;
        PlayerProfileCache_ProfileEntryAccessor entry = this.field_152661_c.get(username.toLowerCase(Locale.ROOT));
        if (entry != null && System.currentTimeMillis() >= entry.accessor$getExpirationDate().getTime()) {
            profile = entry.accessor$getGameProfile();
            this.field_152662_d.remove(profile.getId());
            this.field_152661_c.remove(profile.getName().toLowerCase(Locale.ROOT));
            this.profiles.remove(profile);
            entry = null;
        }
        if (entry != null) {
            profile = entry.accessor$getGameProfile();
            this.profiles.remove(profile);
            this.profiles.add(profile);
        }
        return entry == null ? null : entry.accessor$getGameProfile();
    }
}

