/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.world;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.gson.JsonParseException;
import java.io.IOException;
import net.minecraft.world.WorldType;
import net.minecraft.world.gen.ChunkGeneratorSettings;
import net.minecraft.world.gen.FlatGeneratorInfo;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.GeneratorType;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.gen.WorldGenerator;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.data.persistence.JsonDataFormat;
import org.spongepowered.common.mixin.core.world.gen.ChunkGeneratorSettings_FactoryAccessor;
import org.spongepowered.common.util.Constants;

@NonnullByDefault
@Mixin(value={WorldType.class})
public abstract class WorldTypeMixin_API
implements GeneratorType {
    @Shadow
    @Final
    private String field_77133_f;

    @Override
    public String getId() {
        return SpongeImplHooks.getModIdFromClass(this.getClass()) + ":" + CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, this.field_77133_f);
    }

    @Override
    public String getName() {
        return this.field_77133_f;
    }

    @Override
    public DataContainer getGeneratorSettings() {
        if ((WorldType)this == WorldType.field_77138_c) {
            String defaultSettings = FlatGeneratorInfo.func_82649_e().toString();
            return DataContainer.createNew().set(Constants.Sponge.World.WORLD_CUSTOM_SETTINGS, (Object)defaultSettings);
        }
        if ((WorldType)this == WorldType.field_180271_f) {
            try {
                return JsonDataFormat.serialize(ChunkGeneratorSettings_FactoryAccessor.accessor$getJSON_ADAPTER(), new ChunkGeneratorSettings.Factory());
            }
            catch (JsonParseException | IOException e) {
                throw new AssertionError("Failed to serialize default settings of CUSTOMIZED world type", e);
            }
        }
        return DataContainer.createNew();
    }

    @Override
    public WorldGenerator createGenerator(World world) {
        Preconditions.checkNotNull(world);
        return ((WorldServerBridge)((Object)world)).bridge$createWorldGenerator(this.getGeneratorSettings());
    }
}

