/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.world.chunk;

import com.flowpowered.math.vector.Vector2d;
import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.ScheduledBlockUpdate;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.util.AABB;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.util.PositionOutOfBoundsException;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.Chunk;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.extent.EntityUniverse;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.extent.worker.MutableBiomeVolumeWorker;
import org.spongepowered.api.world.extent.worker.MutableBlockVolumeWorker;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.server.management.PlayerChunkMapEntryBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.SpongeBlockChangeFlag;
import org.spongepowered.common.world.extent.ExtentViewDownsize;
import org.spongepowered.common.world.extent.worker.SpongeMutableBiomeVolumeWorker;
import org.spongepowered.common.world.extent.worker.SpongeMutableBlockVolumeWorker;
import org.spongepowered.common.world.storage.SpongeChunkLayout;

@Mixin(value={net.minecraft.world.chunk.Chunk.class})
public abstract class ChunkMixin_API
implements Chunk {
    @Shadow
    @Final
    private net.minecraft.world.World field_76637_e;
    @Shadow
    @Final
    public int field_76635_g;
    @Shadow
    @Final
    public int field_76647_h;
    @Shadow
    @Final
    private ClassInheritanceMultiMap<net.minecraft.entity.Entity>[] field_76645_j;
    @Shadow
    @Final
    private Map<BlockPos, TileEntity> field_150816_i;
    @Shadow
    private long field_111204_q;
    @Shadow
    private boolean field_76636_d;
    @Shadow
    public boolean field_189550_d;
    @Nullable
    private Vector3i api$chunkPos;
    @Nullable
    private Vector3i api$blockMin;
    @Nullable
    private Vector3i api$blockMax;
    @Nullable
    private Vector3i api$biomeMin;
    @Nullable
    private Vector3i api$biomeMax;
    @Nullable
    private UUID api$uuid;

    @Shadow
    @Nullable
    public abstract TileEntity func_177424_a(BlockPos var1, Chunk.EnumCreateEntityType var2);

    @Shadow
    public abstract IBlockState func_177435_g(BlockPos var1);

    @Shadow
    public abstract IBlockState func_186032_a(int var1, int var2, int var3);

    @Shadow
    public abstract Biome func_177411_a(BlockPos var1, BiomeProvider var2);

    @Shadow
    public abstract byte[] func_76605_m();

    @Shadow
    public abstract void func_76616_a(byte[] var1);

    @Shadow
    public abstract <T extends net.minecraft.entity.Entity> void func_177430_a(Class<? extends T> var1, AxisAlignedBB var2, List<T> var3, com.google.common.base.Predicate<? super T> var4);

    @Shadow
    public abstract BlockPos func_177440_h(BlockPos var1);

    @Shadow
    public abstract ChunkPos func_76632_l();

    @Override
    public UUID getUniqueId() {
        if (this.api$uuid == null) {
            UUID uuid = ((World)this.field_76637_e).getUniqueId();
            if (uuid != null) {
                this.api$uuid = new UUID(uuid.getMostSignificantBits() ^ (long)(this.field_76635_g * 2 + 1), uuid.getLeastSignificantBits() ^ (long)(this.field_76647_h * 2 + 1));
            }
            this.api$uuid = UUID.randomUUID();
        }
        return this.api$uuid;
    }

    @Override
    public Vector3i getPosition() {
        if (this.api$chunkPos == null) {
            this.api$chunkPos = new Vector3i(this.field_76635_g, 0, this.field_76647_h);
        }
        return this.api$chunkPos;
    }

    @Override
    public boolean isLoaded() {
        return this.field_76636_d;
    }

    @Override
    public boolean loadChunk(boolean generate) {
        WorldServer worldserver = (WorldServer)this.field_76637_e;
        if (!generate) {
            return worldserver.func_72863_F().func_186028_c(this.field_76635_g, this.field_76647_h) != null;
        }
        return worldserver.func_72863_F().func_186025_d(this.field_76635_g, this.field_76647_h) != null;
    }

    @Override
    public boolean unloadChunk() {
        if (((ChunkBridge)((Object)this)).bridge$isPersistedChunk()) {
            return false;
        }
        ((WorldServer)this.field_76637_e).func_72863_F().func_189549_a((net.minecraft.world.chunk.Chunk)this);
        return this.field_189550_d;
    }

    @Override
    public int getInhabittedTime() {
        return (int)this.field_111204_q;
    }

    @Override
    public int getInhabitedTime() {
        return (int)this.field_111204_q;
    }

    @Override
    public double getRegionalDifficultyFactor() {
        boolean flag = this.field_76637_e.func_175659_aa() == EnumDifficulty.HARD;
        float moon = this.field_76637_e.func_130001_d();
        float f2 = MathHelper.func_76131_a((float)(((float)this.field_76637_e.func_72820_D() - 72000.0f) / 1440000.0f), (float)0.0f, (float)1.0f) * 0.25f;
        float f3 = 0.0f;
        f3 += MathHelper.func_76131_a((float)((float)this.field_111204_q / 3600000.0f), (float)0.0f, (float)1.0f) * (flag ? 1.0f : 0.75f);
        return f3 += MathHelper.func_76131_a((float)(moon * 0.25f), (float)0.0f, (float)f2);
    }

    @Override
    public double getRegionalDifficultyPercentage() {
        double region = this.getRegionalDifficultyFactor();
        if (region < 2.0) {
            return 0.0;
        }
        if (region > 4.0) {
            return 1.0;
        }
        return (region - 2.0) / 2.0;
    }

    @Override
    public World getWorld() {
        return (World)this.field_76637_e;
    }

    @Override
    public BiomeType getBiome(int x, int y, int z) {
        this.checkBiomeBounds(x, y, z);
        return (BiomeType)this.func_177411_a(new BlockPos(x, y, z), this.field_76637_e.func_72959_q());
    }

    @Override
    public void setBiome(int x, int y, int z, BiomeType biome) {
        PlayerChunkMapEntry entry;
        this.checkBiomeBounds(x, y, z);
        byte[] biomeArray = this.func_76605_m();
        int i = x & 0xF;
        int j = z & 0xF;
        biomeArray[j << 4 | i] = (byte)(Biome.func_185362_a((Biome)((Biome)biome)) & 0xFF);
        this.func_76616_a(biomeArray);
        if (this.field_76637_e instanceof WorldServer && (entry = ((WorldServer)this.field_76637_e).func_184164_w().func_187301_b(this.field_76635_g, this.field_76647_h)) != null) {
            ((PlayerChunkMapEntryBridge)entry).bridge$markBiomesForUpdate();
        }
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        this.checkBlockBounds(x, y, z);
        return (BlockState)this.func_177435_g(new BlockPos(x, y, z));
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockState block) {
        this.checkBlockBounds(x, y, z);
        return this.field_76637_e.func_180501_a(new BlockPos(x, y, z), (IBlockState)block, 3);
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockState block, BlockChangeFlag flag) {
        this.checkBlockBounds(x, y, z);
        return this.field_76637_e.func_180501_a(new BlockPos(x, y, z), (IBlockState)block, ((SpongeBlockChangeFlag)flag).getRawFlag());
    }

    @Override
    public BlockType getBlockType(int x, int y, int z) {
        this.checkBlockBounds(x, y, z);
        return (BlockType)this.func_186032_a(x, y, z).func_177230_c();
    }

    @Override
    public BlockSnapshot createSnapshot(int x, int y, int z) {
        return ((World)this.field_76637_e).createSnapshot((this.field_76635_g << 4) + (x & 0xF), y, (this.field_76647_h << 4) + (z & 0xF));
    }

    @Override
    public boolean restoreSnapshot(BlockSnapshot snapshot, boolean force, BlockChangeFlag flag) {
        return ((World)this.field_76637_e).restoreSnapshot(snapshot, force, flag);
    }

    @Override
    public boolean restoreSnapshot(int x, int y, int z, BlockSnapshot snapshot, boolean force, BlockChangeFlag flag) {
        return ((World)this.field_76637_e).restoreSnapshot((this.field_76635_g << 4) + (x & 0xF), y, (this.field_76647_h << 4) + (z & 0xF), snapshot, force, flag);
    }

    @Override
    public int getHighestYAt(int x, int z) {
        return ((World)this.field_76637_e).getHighestYAt((this.field_76635_g << 4) + (x & 0xF), (this.field_76647_h << 4) + (z & 0xF));
    }

    @Override
    public int getPrecipitationLevelAt(int x, int z) {
        return this.func_177440_h(new BlockPos(x, 0, z)).func_177956_o();
    }

    @Override
    public Vector3i getBiomeMin() {
        if (this.api$biomeMin == null) {
            this.api$biomeMin = new Vector3i(this.getBlockMin().getX(), 0, this.getBlockMin().getZ());
        }
        return this.api$biomeMin;
    }

    @Override
    public Vector3i getBiomeMax() {
        if (this.api$biomeMax == null) {
            this.api$biomeMax = new Vector3i(this.getBlockMax().getX(), 0, this.getBlockMax().getZ());
        }
        return this.api$biomeMax;
    }

    @Override
    public Vector3i getBiomeSize() {
        return Constants.Chunk.BIOME_SIZE;
    }

    @Override
    public Vector3i getBlockMin() {
        if (this.api$blockMin == null) {
            this.api$blockMin = SpongeChunkLayout.instance.forceToWorld(this.getPosition());
        }
        return this.api$blockMin;
    }

    @Override
    public Vector3i getBlockMax() {
        if (this.api$blockMax == null) {
            this.api$blockMax = this.getBlockMin().add(SpongeChunkLayout.CHUNK_SIZE).sub(1, 1, 1);
        }
        return this.api$blockMax;
    }

    @Override
    public Vector3i getBlockSize() {
        return SpongeChunkLayout.CHUNK_SIZE;
    }

    @Override
    public boolean containsBiome(int x, int y, int z) {
        return VecHelper.inBounds(x, y, z, this.getBiomeMin(), this.getBiomeMax());
    }

    @Override
    public boolean containsBlock(int x, int y, int z) {
        return VecHelper.inBounds(x, y, z, this.getBlockMin(), this.getBlockMax());
    }

    private void checkBiomeBounds(int x, int y, int z) {
        if (!this.containsBiome(x, y, z)) {
            throw new PositionOutOfBoundsException(new Vector3i(x, y, z), this.getBiomeMin(), this.getBiomeMax());
        }
    }

    private void checkBlockBounds(int x, int y, int z) {
        if (!this.containsBlock(x, y, z)) {
            throw new PositionOutOfBoundsException(new Vector3i(x, y, z), this.getBlockMin(), this.getBlockMax());
        }
    }

    @Override
    public Extent getExtentView(Vector3i newMin, Vector3i newMax) {
        this.checkBlockBounds(newMin.getX(), newMin.getY(), newMin.getZ());
        this.checkBlockBounds(newMax.getX(), newMax.getY(), newMax.getZ());
        return new ExtentViewDownsize(this, newMin, newMax);
    }

    @Override
    public MutableBiomeVolumeWorker<Chunk> getBiomeWorker() {
        return new SpongeMutableBiomeVolumeWorker<Chunk>(this);
    }

    @Override
    public MutableBlockVolumeWorker<Chunk> getBlockWorker() {
        return new SpongeMutableBlockVolumeWorker<Chunk>(this);
    }

    @Override
    public Entity createEntity(EntityType type, Vector3d position) throws IllegalArgumentException, IllegalStateException {
        return ((World)this.field_76637_e).createEntity(type, this.getPosition().mul(16).toDouble().add(position.min(15.0f, this.getBlockMax().getY(), 15.0f)));
    }

    @Override
    public Optional<Entity> createEntity(DataContainer entityContainer) {
        return ((World)this.field_76637_e).createEntity(entityContainer);
    }

    @Override
    public Optional<Entity> createEntity(DataContainer entityContainer, Vector3d position) {
        Vector3d min = position.min(15.0f, this.getBlockMax().getY(), 15.0f);
        return ((World)this.field_76637_e).createEntity(entityContainer, this.getPosition().mul(16).toDouble().add(min));
    }

    @Override
    public boolean spawnEntity(Entity entity) {
        return ((World)this.field_76637_e).spawnEntity(entity);
    }

    @Override
    public Collection<Entity> getEntities() {
        HashSet<Entity> entities = Sets.newHashSet();
        for (ClassInheritanceMultiMap<net.minecraft.entity.Entity> entityList : this.field_76645_j) {
            entities.addAll((Collection<Entity>)entityList);
        }
        return entities;
    }

    @Override
    public Collection<Entity> getEntities(Predicate<Entity> filter) {
        HashSet<Entity> entities = Sets.newHashSet();
        for (ClassInheritanceMultiMap<net.minecraft.entity.Entity> entityClassMap : this.field_76645_j) {
            for (Object entity : entityClassMap) {
                if (!filter.test((Entity)entity)) continue;
                entities.add((Entity)entity);
            }
        }
        return entities;
    }

    @Override
    public Collection<org.spongepowered.api.block.tileentity.TileEntity> getTileEntities() {
        return Sets.newHashSet(this.field_150816_i.values());
    }

    @Override
    public Collection<org.spongepowered.api.block.tileentity.TileEntity> getTileEntities(Predicate<org.spongepowered.api.block.tileentity.TileEntity> filter) {
        HashSet<org.spongepowered.api.block.tileentity.TileEntity> tiles = Sets.newHashSet();
        for (Map.Entry<BlockPos, TileEntity> entry : this.field_150816_i.entrySet()) {
            if (!filter.test((org.spongepowered.api.block.tileentity.TileEntity)entry.getValue())) continue;
            tiles.add((org.spongepowered.api.block.tileentity.TileEntity)entry.getValue());
        }
        return tiles;
    }

    @Override
    public Optional<org.spongepowered.api.block.tileentity.TileEntity> getTileEntity(int x, int y, int z) {
        return Optional.ofNullable((org.spongepowered.api.block.tileentity.TileEntity)this.func_177424_a(new BlockPos((this.field_76635_g << 4) + (x & 0xF), y, (this.field_76647_h << 4) + (z & 0xF)), Chunk.EnumCreateEntityType.CHECK));
    }

    @Override
    public Optional<Entity> restoreSnapshot(EntitySnapshot snapshot, Vector3d position) {
        return ((World)this.field_76637_e).restoreSnapshot(snapshot, position);
    }

    @Override
    public Collection<ScheduledBlockUpdate> getScheduledUpdates(int x, int y, int z) {
        return ((World)this.field_76637_e).getScheduledUpdates((this.field_76635_g << 4) + (x & 0xF), y, (this.field_76647_h << 4) + (z & 0xF));
    }

    @Override
    public ScheduledBlockUpdate addScheduledUpdate(int x, int y, int z, int priority, int ticks) {
        return ((World)this.field_76637_e).addScheduledUpdate((this.field_76635_g << 4) + (x & 0xF), y, (this.field_76647_h << 4) + (z & 0xF), priority, ticks);
    }

    @Override
    public void removeScheduledUpdate(int x, int y, int z, ScheduledBlockUpdate update) {
        ((World)this.field_76637_e).removeScheduledUpdate((this.field_76635_g << 4) + (x & 0xF), y, (this.field_76647_h << 4) + (z & 0xF), update);
    }

    @Override
    public boolean hitBlock(int x, int y, int z, Direction side, GameProfile profile) {
        return ((World)this.field_76637_e).hitBlock((this.field_76635_g << 4) + (x & 0xF), y, (this.field_76647_h << 4) + (z & 0xF), side, profile);
    }

    @Override
    public boolean interactBlock(int x, int y, int z, Direction side, GameProfile profile) {
        return ((World)this.field_76637_e).interactBlock((this.field_76635_g << 4) + (x & 0xF), y, (this.field_76647_h << 4) + (z & 0xF), side, profile);
    }

    @Override
    public boolean placeBlock(int x, int y, int z, BlockState block, Direction side, GameProfile profile) {
        return ((World)this.field_76637_e).placeBlock((this.field_76635_g << 4) + (x & 0xF), y, (this.field_76647_h << 4) + (z & 0xF), block, side, profile);
    }

    @Override
    public boolean interactBlockWith(int x, int y, int z, ItemStack itemStack, Direction side, GameProfile profile) {
        return ((World)this.field_76637_e).interactBlockWith((this.field_76635_g << 4) + (x & 0xF), y, (this.field_76647_h << 4) + (z & 0xF), itemStack, side, profile);
    }

    @Override
    public boolean digBlock(int x, int y, int z, GameProfile profile) {
        return ((World)this.field_76637_e).digBlock((this.field_76635_g << 4) + (x & 0xF), y, (this.field_76647_h << 4) + (z & 0xF), profile);
    }

    @Override
    public boolean digBlockWith(int x, int y, int z, ItemStack itemStack, GameProfile profile) {
        return ((World)this.field_76637_e).digBlockWith((this.field_76635_g << 4) + (x & 0xF), y, (this.field_76647_h << 4) + (z & 0xF), itemStack, profile);
    }

    @Override
    public int getBlockDigTimeWith(int x, int y, int z, ItemStack itemStack, GameProfile profile) {
        return ((World)this.field_76637_e).getBlockDigTimeWith((this.field_76635_g << 4) + (x & 0xF), y, (this.field_76647_h << 4) + (z & 0xF), itemStack, profile);
    }

    @Override
    public Optional<AABB> getBlockSelectionBox(int x, int y, int z) {
        this.checkBlockBounds(x, y, z);
        return ((World)this.field_76637_e).getBlockSelectionBox((this.field_76635_g << 4) + (x & 0xF), y, (this.field_76647_h << 4) + (z & 0xF));
    }

    @Override
    public Set<Entity> getIntersectingEntities(AABB box, Predicate<Entity> filter) {
        Preconditions.checkNotNull(box, "box");
        Preconditions.checkNotNull(filter, "filter");
        ArrayList entities = new ArrayList();
        this.func_177430_a(net.minecraft.entity.Entity.class, VecHelper.toMinecraftAABB(box), entities, entity -> filter.test((Entity)entity));
        return entities.stream().map(entity -> (Entity)entity).collect(Collectors.toSet());
    }

    @Override
    public Set<AABB> getIntersectingBlockCollisionBoxes(AABB box) {
        Vector3i max = this.getBlockMax().add(Vector3i.ONE);
        return ((World)this.field_76637_e).getIntersectingBlockCollisionBoxes(box).stream().filter(aabb -> VecHelper.inBounds(aabb.getCenter(), this.getBlockMin(), max)).collect(Collectors.toSet());
    }

    @Override
    public Set<AABB> getIntersectingCollisionBoxes(Entity owner, AABB box) {
        Vector3i max = this.getBlockMax().add(Vector3i.ONE);
        return ((World)this.field_76637_e).getIntersectingCollisionBoxes(owner, box).stream().filter(aabb -> VecHelper.inBounds(aabb.getCenter(), this.getBlockMin(), max)).collect(Collectors.toSet());
    }

    @Override
    public Set<EntityUniverse.EntityHit> getIntersectingEntities(Vector3d start, Vector3d end, Predicate<EntityUniverse.EntityHit> filter) {
        Preconditions.checkNotNull(start, "start");
        Preconditions.checkNotNull(end, "end");
        Preconditions.checkNotNull(filter, "filter");
        Vector3d diff = end.sub(start);
        return this.api$getIntersectingEntities(start, end, diff.normalize(), diff.length(), filter);
    }

    @Override
    public Set<EntityUniverse.EntityHit> getIntersectingEntities(Vector3d start, Vector3d direction, double distance, Predicate<EntityUniverse.EntityHit> filter) {
        Preconditions.checkNotNull(start, "start");
        Preconditions.checkNotNull(direction, "direction");
        Preconditions.checkNotNull(filter, "filter");
        direction = direction.normalize();
        return this.api$getIntersectingEntities(start, start.add(direction.mul(distance)), direction, distance, filter);
    }

    private Set<EntityUniverse.EntityHit> api$getIntersectingEntities(Vector3d start, Vector3d end, Vector3d direction, double distance, Predicate<? super EntityUniverse.EntityHit> filter) {
        Vector2d entryAndExitY = this.getEntryAndExitY(start, end, direction, distance);
        if (entryAndExitY == null) {
            return Collections.emptySet();
        }
        HashSet<EntityUniverse.EntityHit> intersections = new HashSet<EntityUniverse.EntityHit>();
        ((ChunkBridge)((Object)this)).bridge$getIntersectingEntities(start, direction, distance, filter, entryAndExitY.getX(), entryAndExitY.getY(), intersections);
        return intersections;
    }

    @Nullable
    private Vector2d getEntryAndExitY(Vector3d start, Vector3d end, Vector3d direction, double distance) {
        double tzMax;
        double tzMin;
        double txMax;
        double txMin;
        Vector3i min = this.getBlockMin().sub(2, 2, 2);
        Vector3i max = this.getBlockMax().add(3, 3, 3);
        if (Math.copySign(1.0, direction.getX()) > 0.0) {
            txMin = ((double)min.getX() - start.getX()) / direction.getX();
            txMax = ((double)max.getX() - start.getX()) / direction.getX();
        } else {
            txMin = ((double)max.getX() - start.getX()) / direction.getX();
            txMax = ((double)min.getX() - start.getX()) / direction.getX();
        }
        if (Math.copySign(1.0, direction.getZ()) > 0.0) {
            tzMin = ((double)min.getZ() - start.getZ()) / direction.getZ();
            tzMax = ((double)max.getZ() - start.getZ()) / direction.getZ();
        } else {
            tzMin = ((double)max.getZ() - start.getZ()) / direction.getZ();
            tzMax = ((double)min.getZ() - start.getZ()) / direction.getZ();
        }
        if (txMin > tzMax || txMax < tzMin) {
            return null;
        }
        double tMin = Math.max(tzMin, txMin);
        double tMax = Math.min(tzMax, txMax);
        if (tMax < 0.0) {
            return null;
        }
        double yEntry = tMin < 0.0 ? start.getY() : direction.getY() * tMin + start.getY();
        double yExit = tMax > distance ? end.getY() : direction.getY() * tMax + start.getY();
        return new Vector2d(yEntry, yExit);
    }

    @Override
    public Optional<Chunk> getNeighbor(Direction direction, boolean shouldLoad) {
        Preconditions.checkNotNull(direction, "direction");
        Preconditions.checkArgument(!direction.isSecondaryOrdinal(), "Secondary cardinal directions can't be used here");
        if (direction.isUpright() || direction == Direction.NONE) {
            return Optional.of(this);
        }
        int index = SpongeImpl.directionToIndex(direction);
        Direction secondary = SpongeImpl.getSecondaryDirection(direction);
        Chunk neighbor = null;
        neighbor = (Chunk)((ChunkBridge)((Object)this)).bridge$getNeighborArray()[index];
        if (neighbor == null && shouldLoad) {
            Vector3i neighborPosition = this.getPosition().add(SpongeImpl.getCardinalDirection(direction).asBlockOffset());
            Optional<Chunk> cardinal = this.getWorld().loadChunk(neighborPosition, true);
            if (cardinal.isPresent()) {
                neighbor = cardinal.get();
            }
        }
        if (neighbor != null && secondary != Direction.NONE) {
            return neighbor.getNeighbor(secondary, shouldLoad);
        }
        return Optional.ofNullable(neighbor);
    }
}

