/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.world.gen.feature;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.spongepowered.api.data.manipulator.mutable.MobSpawnerData;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.util.weighted.LootTable;
import org.spongepowered.api.util.weighted.UnmodifiableWeightedTable;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.api.world.gen.PopulatorTypes;
import org.spongepowered.api.world.gen.populator.Dungeon;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.registry.type.world.gen.DungeonMobRegistryModule;

@Mixin(value={WorldGenDungeons.class})
public abstract class WorldGenDungeonsMixin_API
extends WorldGenerator
implements Dungeon {
    private final WeightedTable<EntityArchetype> api$defaultEntities = new UnmodifiableWeightedTable<EntityArchetype>(DungeonMobRegistryModule.getInstance().getRaw());
    private VariableAmount api$attempts = VariableAmount.fixed(8.0);
    @Nullable
    private MobSpawnerData api$data;
    @Nullable
    private WeightedTable<EntityArchetype> api$choices;
    private final LootTable<ItemStackSnapshot> api$loot = new LootTable();

    @Override
    public PopulatorType getType() {
        return PopulatorTypes.DUNGEON;
    }

    @Override
    public void populate(org.spongepowered.api.world.World worldIn, Extent extent, Random random) {
        Vector3i min = extent.getBlockMin();
        Vector3i size = extent.getBlockSize();
        World world = (World)worldIn;
        BlockPos chunkPos = new BlockPos(min.getX(), min.getY(), min.getZ());
        int n = this.api$attempts.getFlooredAmount(random);
        for (int i = 0; i < n; ++i) {
            int x = random.nextInt(size.getX());
            int y = random.nextInt(size.getY());
            int z = random.nextInt(size.getZ());
            this.func_180709_b(world, random, chunkPos.func_177982_a(x, y, z));
        }
    }

    @Override
    public VariableAmount getAttemptsPerChunk() {
        return this.api$attempts;
    }

    @Override
    public void setAttemptsPerChunk(VariableAmount attempts) {
        this.api$attempts = Preconditions.checkNotNull(attempts, "attempts");
    }

    @Override
    public Optional<MobSpawnerData> getMobSpawnerData() {
        return Optional.ofNullable(this.api$data);
    }

    @Override
    public void setMobSpawnerData(MobSpawnerData data) {
        this.api$data = Preconditions.checkNotNull(data, "data");
        this.api$choices = null;
    }

    @Override
    public Optional<WeightedTable<EntityArchetype>> getChoices() {
        if (this.api$choices == null && this.api$data == null) {
            return Optional.of(this.api$defaultEntities);
        }
        return Optional.ofNullable(this.api$choices);
    }

    @Override
    public void setChoices(WeightedTable<EntityArchetype> choices) {
        this.api$choices = choices;
        this.api$data = null;
    }

    @Override
    public LootTable<ItemStackSnapshot> getPossibleContents() {
        return this.api$loot;
    }
}

