/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.world.gen.feature;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.NoiseGeneratorSimplex;
import net.minecraft.world.gen.feature.WorldGenEndIsland;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.api.world.gen.PopulatorTypes;
import org.spongepowered.api.world.gen.populator.EndIsland;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={WorldGenEndIsland.class})
public abstract class WorldGenEndIslandMixin_API
extends WorldGenerator
implements EndIsland {
    @Nullable
    private NoiseGeneratorSimplex api$noise;
    private VariableAmount api$initial = VariableAmount.baseWithRandomAddition(4.0, 3.0);
    private VariableAmount api$decrement = VariableAmount.baseWithRandomAddition(0.5, 2.0);
    private BlockState api$state = BlockTypes.END_STONE.getDefaultState();
    private long api$lastSeed = -1L;
    private int api$exclusion = 1024;

    @Override
    public PopulatorType getType() {
        return PopulatorTypes.END_ISLAND;
    }

    @Override
    public VariableAmount getStartingRadius() {
        return this.api$initial;
    }

    @Override
    public void setStartingRadius(VariableAmount radius) {
        this.api$initial = Preconditions.checkNotNull(radius);
    }

    @Override
    public VariableAmount getRadiusDecrement() {
        return this.api$decrement;
    }

    @Override
    public void setRadiusDecrement(VariableAmount decrement) {
        this.api$decrement = Preconditions.checkNotNull(decrement);
    }

    @Override
    public BlockState getIslandBlock() {
        return this.api$state;
    }

    @Override
    public void setIslandBlock(BlockState state) {
        this.api$state = Preconditions.checkNotNull(state);
    }

    @Override
    public int getExclusionRadius() {
        return this.api$exclusion;
    }

    @Override
    public void setExclusionRadius(int radius) {
        Preconditions.checkArgument(radius >= 0);
        this.api$exclusion = radius;
    }

    @Override
    public void populate(org.spongepowered.api.world.World worldIn, Extent extent, Random rand) {
        float f;
        Vector3i min = extent.getBlockMin();
        Vector3i size = extent.getBlockSize();
        World world = (World)worldIn;
        if (this.api$noise == null || worldIn.getProperties().getSeed() != this.api$lastSeed) {
            this.api$lastSeed = worldIn.getProperties().getSeed();
            this.api$noise = new NoiseGeneratorSimplex(new Random(this.api$lastSeed));
        }
        BlockPos chunkPos = new BlockPos(min.getX(), min.getY(), min.getZ());
        int chunkX = min.getX() / 16;
        int chunkZ = min.getZ() / 16;
        if ((long)min.getX() * (long)min.getX() + (long)min.getZ() * (long)min.getZ() > (long)(this.api$exclusion * this.api$exclusion) && (f = this.implClone$chunkGeneratorEnd$getIslandHeightValue(chunkX, chunkZ, 1, 1)) < -20.0f && rand.nextInt(14) == 0) {
            this.func_180709_b(world, rand, chunkPos.func_177982_a(rand.nextInt(size.getX()), 55 + rand.nextInt(16), rand.nextInt(size.getZ())));
            if (rand.nextInt(4) == 0) {
                this.func_180709_b((World)worldIn, rand, chunkPos.func_177982_a(rand.nextInt(size.getX()), 55 + rand.nextInt(16), rand.nextInt(size.getZ())));
            }
        }
    }

    private float implClone$chunkGeneratorEnd$getIslandHeightValue(int p_185960_1_, int p_185960_2_, int p_185960_3_, int p_185960_4_) {
        float f = p_185960_1_ * 2 + p_185960_3_;
        float f1 = p_185960_2_ * 2 + p_185960_4_;
        float f2 = 100.0f - MathHelper.func_76129_c((float)(f * f + f1 * f1)) * 8.0f;
        if (f2 > 80.0f) {
            f2 = 80.0f;
        }
        if (f2 < -100.0f) {
            f2 = -100.0f;
        }
        for (int i = -12; i <= 12; ++i) {
            for (int j = -12; j <= 12; ++j) {
                long k = p_185960_1_ + i;
                long l = p_185960_2_ + j;
                if (k * k + l * l <= 4096L || !(this.api$noise.func_151605_a((double)k, (double)l) < (double)-0.9f)) continue;
                float f3 = (MathHelper.func_76135_e((float)k) * 3439.0f + MathHelper.func_76135_e((float)l) * 147.0f) % 13.0f + 9.0f;
                f = p_185960_3_ - i * 2;
                f1 = p_185960_4_ - j * 2;
                float f4 = 100.0f - MathHelper.func_76129_c((float)(f * f + f1 * f1)) * f3;
                if (f4 > 80.0f) {
                    f4 = 80.0f;
                }
                if (f4 < -100.0f) {
                    f4 = -100.0f;
                }
                if (!(f4 > f2)) continue;
                f2 = f4;
            }
        }
        return f2;
    }
}

