/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.advancements;

import com.google.common.base.Preconditions;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.PlayerAdvancements;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.advancement.criteria.AdvancementCriterion;
import org.spongepowered.api.advancement.criteria.AndCriterion;
import org.spongepowered.api.advancement.criteria.CriterionProgress;
import org.spongepowered.api.advancement.criteria.OperatorCriterion;
import org.spongepowered.api.advancement.criteria.OrCriterion;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.advancement.CriterionEvent;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.advancement.ImplementationBackedCriterionProgress;
import org.spongepowered.common.advancement.SpongeAndCriterion;
import org.spongepowered.common.advancement.SpongeAndCriterionProgress;
import org.spongepowered.common.advancement.SpongeEmptyCriterion;
import org.spongepowered.common.advancement.SpongeOrCriterion;
import org.spongepowered.common.advancement.SpongeOrCriterionProgress;
import org.spongepowered.common.advancement.SpongeScoreCriterion;
import org.spongepowered.common.advancement.SpongeScoreCriterionProgress;
import org.spongepowered.common.bridge.advancements.AdvancementProgressBridge;
import org.spongepowered.common.bridge.advancements.CriterionBridge;
import org.spongepowered.common.bridge.advancements.CriterionProgressBridge;
import org.spongepowered.common.bridge.advancements.PlayerAdvancementsBridge;
import org.spongepowered.common.registry.type.advancement.AdvancementRegistryModule;

@Mixin(value={AdvancementProgress.class})
public class AdvancementProgressMixin
implements AdvancementProgressBridge {
    @Shadow
    @Final
    private Map<String, net.minecraft.advancements.CriterionProgress> field_192110_a;
    @Nullable
    private Map<AdvancementCriterion, ImplementationBackedCriterionProgress> impl$progressMap;
    @Nullable
    private String impl$advancement;
    @Nullable
    private PlayerAdvancements bridge$playerAdvancements;

    @Override
    public Advancement bridge$getAdvancement() {
        Preconditions.checkState(SpongeImplHooks.isMainThread());
        Preconditions.checkState(this.impl$advancement != null, "The advancement is not yet initialized");
        return (Advancement)AdvancementRegistryModule.getInstance().getById(this.impl$advancement).orElseThrow(() -> new IllegalStateException("The advancement of this advancement progress is unloaded: " + this.impl$advancement));
    }

    @Inject(method={"update"}, at={@At(value="RETURN")})
    private void impl$updateCriterionsandMap(Map<String, Criterion> criteriaIn, String[][] requirements, CallbackInfo ci) {
        String[][] stringArray = requirements;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] reqs;
            for (String req : reqs = stringArray[i]) {
                if (criteriaIn.containsKey(req)) continue;
                String advName = this.getOptionalAdvancement().map(CatalogType::getId).orElse("unknown");
                throw new IllegalStateException("Found a requirement which does not exist in the criteria, " + req + " could not be found for the advancement: " + advName);
            }
        }
        this.bridge$updateProgressMap();
    }

    @Override
    public void bridge$updateProgressMap() {
        if (!SpongeImplHooks.isMainThread()) {
            return;
        }
        Optional<Advancement> advancement = this.getOptionalAdvancement();
        if (advancement.isPresent()) {
            this.impl$progressMap = new HashMap<AdvancementCriterion, ImplementationBackedCriterionProgress>();
            this.impl$processProgressMap(advancement.get().getCriterion(), this.impl$progressMap);
        } else {
            this.impl$progressMap = null;
        }
    }

    @Override
    public Map<AdvancementCriterion, ImplementationBackedCriterionProgress> bridge$getProgressMap() {
        return this.impl$progressMap;
    }

    private Map<AdvancementCriterion, ImplementationBackedCriterionProgress> getProgressMap() {
        Preconditions.checkState(this.impl$progressMap != null, "progressMap isn't initialized");
        return this.impl$progressMap;
    }

    private void impl$processProgressMap(AdvancementCriterion criterion, Map<AdvancementCriterion, ImplementationBackedCriterionProgress> progressMap) {
        if (criterion instanceof OperatorCriterion) {
            ((OperatorCriterion)criterion).getCriteria().forEach(child -> this.impl$processProgressMap((AdvancementCriterion)child, progressMap));
            if (criterion instanceof AndCriterion) {
                progressMap.put(criterion, new SpongeAndCriterionProgress((org.spongepowered.api.advancement.AdvancementProgress)((Object)this), (SpongeAndCriterion)criterion));
            } else if (criterion instanceof OrCriterion) {
                progressMap.put(criterion, new SpongeOrCriterionProgress((org.spongepowered.api.advancement.AdvancementProgress)((Object)this), (SpongeOrCriterion)criterion));
            }
        } else if (criterion instanceof SpongeScoreCriterion) {
            SpongeScoreCriterion scoreCriterion = (SpongeScoreCriterion)criterion;
            for (AdvancementCriterion advancementCriterion : scoreCriterion.internalCriteria) {
                CriterionProgressBridge progress = (CriterionProgressBridge)this.field_192110_a.get(advancementCriterion.getName());
                progress.bridge$setCriterion(advancementCriterion);
                progressMap.put(advancementCriterion, (ImplementationBackedCriterionProgress)((Object)progress));
            }
            progressMap.put(scoreCriterion, new SpongeScoreCriterionProgress((org.spongepowered.api.advancement.AdvancementProgress)((Object)this), scoreCriterion));
        } else if (criterion != SpongeEmptyCriterion.INSTANCE) {
            CriterionProgressBridge progress = (CriterionProgressBridge)this.field_192110_a.get(criterion.getName());
            progress.bridge$setCriterion(criterion);
            progressMap.put(criterion, (ImplementationBackedCriterionProgress)((Object)progress));
        }
    }

    @Inject(method={"isDone"}, at={@At(value="HEAD")}, cancellable=true)
    private void onIsDone(CallbackInfoReturnable<Boolean> ci) {
        if (this.impl$advancement == null || !SpongeImplHooks.isMainThread()) {
            return;
        }
        Advancement advancement = this.getOptionalAdvancement().orElse(null);
        if (advancement != null) {
            ImplementationBackedCriterionProgress bridge = this.impl$progressMap.get(advancement.getCriterion());
            ci.setReturnValue(bridge != null && ((CriterionProgress)((Object)bridge)).achieved());
        }
    }

    @Inject(method={"grantCriterion(Ljava/lang/String;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGrantCriterion(String criterionIn, CallbackInfoReturnable<Boolean> ci) {
        if (!SpongeImplHooks.isMainThread()) {
            return;
        }
        ci.setReturnValue(this.spongeGrantCriterion(criterionIn));
    }

    private boolean spongeGrantCriterion(String criterionIn) {
        CriterionEvent event;
        net.minecraft.advancements.CriterionProgress criterionProgress = this.field_192110_a.get(criterionIn);
        if (criterionProgress == null || criterionProgress.func_192151_a()) {
            return false;
        }
        if (SpongeScoreCriterion.BYPASS_EVENT) {
            criterionProgress.func_192153_b();
            return true;
        }
        Cause cause = SpongeImpl.getCauseStackManager().getCurrentCause();
        Player player = ((PlayerAdvancementsBridge)this.bridge$playerAdvancements).bridge$getPlayer();
        CriterionProgress progress = (CriterionProgress)criterionProgress;
        AdvancementCriterion criterion = progress.getCriterion();
        CriterionBridge mixinCriterion = (CriterionBridge)((Object)criterion);
        SpongeScoreCriterion scoreCriterion = mixinCriterion.bridge$getScoreCriterion();
        if (scoreCriterion != null) {
            SpongeScoreCriterionProgress scoreProgress = (SpongeScoreCriterionProgress)this.impl$progressMap.get(scoreCriterion);
            int lastScore = scoreProgress.getScore();
            int score = lastScore + 1;
            event = lastScore == scoreCriterion.getGoal() ? SpongeEventFactory.createCriterionEventScoreRevoke(cause, this.bridge$getAdvancement(), scoreCriterion, player, lastScore, score) : (score == scoreCriterion.getGoal() ? SpongeEventFactory.createCriterionEventScoreGrant(cause, this.bridge$getAdvancement(), scoreCriterion, player, Instant.now(), lastScore, score) : SpongeEventFactory.createCriterionEventScoreChange(cause, this.bridge$getAdvancement(), scoreCriterion, player, lastScore, score));
        } else {
            event = SpongeEventFactory.createCriterionEventGrant(cause, this.bridge$getAdvancement(), criterion, player, Instant.now());
        }
        if (SpongeImpl.postEvent(event)) {
            return false;
        }
        criterionProgress.func_192153_b();
        return true;
    }

    @Inject(method={"revokeCriterion(Ljava/lang/String;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void revokeCriterion(String criterionIn, CallbackInfoReturnable<Boolean> ci) {
        if (!SpongeImplHooks.isMainThread()) {
            return;
        }
        ci.setReturnValue(this.spongeRevokeCriterion(criterionIn));
    }

    private boolean spongeRevokeCriterion(String criterionIn) {
        CriterionEvent event;
        net.minecraft.advancements.CriterionProgress criterionProgress = this.field_192110_a.get(criterionIn);
        if (criterionProgress == null || !criterionProgress.func_192151_a()) {
            return false;
        }
        if (SpongeScoreCriterion.BYPASS_EVENT) {
            criterionProgress.func_192154_c();
            return true;
        }
        Cause cause = SpongeImpl.getCauseStackManager().getCurrentCause();
        Player player = ((PlayerAdvancementsBridge)this.bridge$playerAdvancements).bridge$getPlayer();
        CriterionProgress progress = (CriterionProgress)criterionProgress;
        AdvancementCriterion criterion = progress.getCriterion();
        CriterionBridge mixinCriterion = (CriterionBridge)((Object)criterion);
        SpongeScoreCriterion scoreCriterion = mixinCriterion.bridge$getScoreCriterion();
        if (scoreCriterion != null) {
            SpongeScoreCriterionProgress scoreProgress = (SpongeScoreCriterionProgress)this.impl$progressMap.get(scoreCriterion);
            int lastScore = scoreProgress.getScore();
            int score = lastScore + 1;
            event = lastScore == scoreCriterion.getGoal() ? SpongeEventFactory.createCriterionEventScoreRevoke(cause, ((org.spongepowered.api.advancement.AdvancementProgress)((Object)this)).getAdvancement(), scoreCriterion, player, lastScore, score) : (score == scoreCriterion.getGoal() ? SpongeEventFactory.createCriterionEventScoreGrant(cause, ((org.spongepowered.api.advancement.AdvancementProgress)((Object)this)).getAdvancement(), scoreCriterion, player, Instant.now(), lastScore, score) : SpongeEventFactory.createCriterionEventScoreChange(cause, ((org.spongepowered.api.advancement.AdvancementProgress)((Object)this)).getAdvancement(), scoreCriterion, player, lastScore, score));
        } else {
            event = SpongeEventFactory.createCriterionEventRevoke(cause, ((org.spongepowered.api.advancement.AdvancementProgress)((Object)this)).getAdvancement(), criterion, player);
        }
        if (SpongeImpl.postEvent(event)) {
            return false;
        }
        criterionProgress.func_192154_c();
        return true;
    }

    @Override
    public PlayerAdvancements bridge$getPlayerAdvancements() {
        Preconditions.checkState(SpongeImplHooks.isMainThread());
        Preconditions.checkState(this.bridge$playerAdvancements != null, "The playerAdvancements is not yet initialized");
        return this.bridge$playerAdvancements;
    }

    @Override
    public void bridge$setPlayerAdvancements(PlayerAdvancements playerAdvancements) {
        Preconditions.checkState(SpongeImplHooks.isMainThread());
        this.bridge$playerAdvancements = playerAdvancements;
    }

    @Override
    public void bridge$setAdvancement(String advancement) {
        Preconditions.checkState(SpongeImplHooks.isMainThread());
        this.impl$advancement = advancement;
    }

    @Override
    public void bridge$invalidateAchievedState() {
        if (!SpongeImplHooks.isMainThread()) {
            return;
        }
        for (ImplementationBackedCriterionProgress progress : this.getProgressMap().values()) {
            progress.invalidateAchievedState();
        }
    }

    private Optional<Advancement> getOptionalAdvancement() {
        Preconditions.checkState(SpongeImplHooks.isMainThread());
        Preconditions.checkState(this.impl$advancement != null, "The advancement is not yet initialized");
        return AdvancementRegistryModule.getInstance().getById(this.impl$advancement);
    }
}

