/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.authlib;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.yggdrasil.response.ProfileSearchResultsResponse;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeImpl;

@Mixin(value={ProfileSearchResultsResponse.Serializer.class}, remap=false)
public abstract class ProfileSearchResultsResponseSerializerMixin {
    private @Nullable Pattern uuidPattern;

    @Inject(method={"deserialize"}, at={@At(value="INVOKE", target="Lcom/google/gson/JsonDeserializationContext;deserialize(Lcom/google/gson/JsonElement;Ljava/lang/reflect/Type;)Ljava/lang/Object;", remap=false)}, remap=false)
    private void onDeserializeFixInvalidIds(JsonElement json, Type typeOfT, JsonDeserializationContext context, CallbackInfoReturnable<ProfileSearchResultsResponse> cir) {
        Iterator<JsonElement> iterator = json.getAsJsonArray().iterator();
        while (iterator.hasNext()) {
            JsonObject element = iterator.next().getAsJsonObject();
            String id = element.get("id").getAsString();
            if (this.uuidPattern == null) {
                this.uuidPattern = Pattern.compile("[0-9a-fA-F-]+");
            }
            if (this.uuidPattern.matcher(id).matches()) continue;
            SpongeImpl.getLogger().debug("Received invalid profile from Mojang for username " + element.get("name") + ", skipping");
            iterator.remove();
        }
    }
}

