/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.authlib;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.util.Collection;
import javax.annotation.Nullable;
import org.spongepowered.api.profile.property.ProfileProperty;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={PropertyMap.class}, remap=false)
public abstract class PropertyMapMixin
implements Multimap<String, ProfileProperty> {
    @Shadow
    protected abstract Multimap<String, ProfileProperty> delegate();

    @Override
    public boolean containsValue(@Nullable Object value) {
        this.sanityCheck(value);
        return this.delegate().containsValue(value);
    }

    @Override
    public boolean containsEntry(@Nullable Object key, @Nullable Object value) {
        this.sanityCheck(value);
        return this.delegate().containsEntry(key, value);
    }

    @Override
    public boolean put(@Nullable String key, @Nullable ProfileProperty value) {
        this.sanityCheck(value);
        return this.delegate().put(key, value);
    }

    @Override
    public boolean remove(@Nullable Object key, @Nullable Object value) {
        this.sanityCheck(value);
        return this.delegate().remove(key, value);
    }

    @Override
    public boolean putAll(@Nullable String key, Iterable<? extends ProfileProperty> values) {
        for (ProfileProperty profileProperty : values) {
            this.sanityCheck(profileProperty);
        }
        return this.delegate().putAll(key, values);
    }

    @Override
    public boolean putAll(Multimap<? extends String, ? extends ProfileProperty> multimap) {
        for (ProfileProperty profileProperty : multimap.values()) {
            this.sanityCheck(profileProperty);
        }
        return this.delegate().putAll(multimap);
    }

    @Override
    public Collection<ProfileProperty> replaceValues(@Nullable String key, Iterable<? extends ProfileProperty> values) {
        for (ProfileProperty profileProperty : values) {
            this.sanityCheck(profileProperty);
        }
        return this.delegate().replaceValues(key, values);
    }

    private void sanityCheck(@Nullable Object object) {
        if (object != null) {
            Preconditions.checkState(object instanceof Property, "Property must be of type " + ProfileProperty.class.getName());
        }
    }
}

