/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.mixin.core.block.BlockLiquidMixin;
import org.spongepowered.common.world.SpongeLocatableBlockBuilder;

@Mixin(value={BlockDynamicLiquid.class})
public abstract class BlockDynamicLiquidMixin
extends BlockLiquidMixin {
    @Override
    public BiConsumer<CauseStackManager.StackFrame, WorldServerBridge> bridge$getTickFrameModifier() {
        return (frame, world) -> frame.addContext(EventContextKeys.LIQUID_FLOW, (org.spongepowered.api.world.World)((Object)world));
    }

    @Inject(method={"canFlowInto"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$throwPreForFlowingInto(World worldIn, BlockPos pos, IBlockState state, CallbackInfoReturnable<Boolean> cir) {
        if (!((WorldBridge)worldIn).bridge$isFake() && ShouldFire.CHANGE_BLOCK_EVENT_PRE && SpongeCommonEventFactory.callChangeBlockEventPre((WorldServerBridge)worldIn, pos).isCancelled()) {
            cir.setReturnValue(false);
        }
    }

    @Inject(method={"updateTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$throwPreOnUpdate(World worldIn, BlockPos pos, IBlockState state, Random rand, CallbackInfo ci) {
        if (!((WorldBridge)worldIn).bridge$isFake() && ShouldFire.CHANGE_BLOCK_EVENT_PRE && SpongeCommonEventFactory.callChangeBlockEventPre((WorldServerBridge)worldIn, pos).isCancelled()) {
            ci.cancel();
        }
    }

    @Inject(method={"updateTick"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)Z")})
    private void impl$throwModifyForLavaToStone(World worldIn, BlockPos sourcePos, IBlockState state, Random rand, CallbackInfo ci) {
        if (!ShouldFire.CHANGE_BLOCK_EVENT_MODIFY) {
            return;
        }
        BlockPos targetPos = sourcePos.func_177977_b();
        LocatableBlock source = new SpongeLocatableBlockBuilder().world((org.spongepowered.api.world.World)worldIn).position(sourcePos.func_177958_n(), sourcePos.func_177956_o(), sourcePos.func_177952_p()).state((BlockState)state).build();
        IBlockState newState = Blocks.field_150348_b.func_176223_P();
        ChangeBlockEvent.Modify event = SpongeCommonEventFactory.callChangeBlockEventModifyLiquidMix(worldIn, targetPos, newState, source);
        Transaction<BlockSnapshot> transaction = event.getTransactions().get(0);
        if (event.isCancelled() || !transaction.isValid()) {
            ci.cancel();
            return;
        }
        if (!worldIn.func_175656_a(targetPos, (IBlockState)transaction.getFinal().getState())) {
            ci.cancel();
        }
    }

    @Inject(method={"tryFlowInto"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/block/state/IBlockState;getMaterial()Lnet/minecraft/block/material/Material;")}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/block/BlockDynamicLiquid;canFlowInto(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)Z"), to=@At(value="FIELD", target="Lnet/minecraft/block/BlockDynamicLiquid;material:Lnet/minecraft/block/material/Material;"))})
    private void impl$throwBreakForReplacingotherBlocksDuringFlow(World worldIn, BlockPos pos, IBlockState state, int level, CallbackInfo ci) {
        if (!ShouldFire.CHANGE_BLOCK_EVENT_BREAK) {
            return;
        }
        if (state.func_185904_a() != Material.field_151579_a && state.func_185904_a() != this.shadow$func_176223_P().func_185904_a()) {
            IBlockState newState = this.shadow$func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(level));
            ChangeBlockEvent.Break event = SpongeCommonEventFactory.callChangeBlockEventModifyLiquidBreak(worldIn, pos, newState);
            Transaction<BlockSnapshot> transaction = event.getTransactions().get(0);
            if (event.isCancelled() || !transaction.isValid()) {
                ci.cancel();
                return;
            }
            if (transaction.getCustom().isPresent()) {
                worldIn.func_175656_a(pos, (IBlockState)transaction.getFinal().getState());
                ci.cancel();
            }
        }
    }
}

