/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import java.util.Random;
import net.minecraft.block.BlockFire;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.mixin.core.block.BlockMixin;

@Mixin(value={BlockFire.class})
public abstract class BlockFireMixin
extends BlockMixin {
    @Redirect(method={"updateTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;I)Z", ordinal=1))
    private boolean impl$onFireSpread(World world, BlockPos pos, IBlockState state, int updateFlag) {
        if (!((WorldBridge)world).bridge$isFake() && ShouldFire.CHANGE_BLOCK_EVENT_PRE) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.FIRE_SPREAD, (org.spongepowered.api.world.World)world);
                if (SpongeCommonEventFactory.callChangeBlockEventPre((WorldServerBridge)world, pos).isCancelled()) {
                    boolean bl2 = false;
                    return bl2;
                }
            }
        }
        return world.func_180501_a(pos, state, updateFlag);
    }

    @Inject(method={"catchOnFire"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;I)Z")}, require=0, expect=0, cancellable=true)
    private void impl$onCatchFirePreCheck(World world, BlockPos pos, int chance, Random random, int age, CallbackInfo callbackInfo) {
        if (!world.field_72995_K && SpongeCommonEventFactory.callChangeBlockEventPre((WorldServerBridge)world, pos).isCancelled()) {
            callbackInfo.cancel();
        }
    }

    @Inject(method={"catchOnFire"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockToAir(Lnet/minecraft/util/math/BlockPos;)Z")}, require=0, expect=0, cancellable=true)
    private void impl$onCatchFirePreCheckOther(World world, BlockPos pos, int chance, Random random, int age, CallbackInfo callbackInfo) {
        if (!world.field_72995_K && SpongeCommonEventFactory.callChangeBlockEventPre((WorldServerBridge)world, pos).isCancelled()) {
            callbackInfo.cancel();
        }
    }
}

