/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import net.minecraft.block.BlockStem;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableDirectionalData;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableGrowthData;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.util.Direction;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.data.ImmutableDataCachingUtil;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeDirectionalData;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeGrowthData;
import org.spongepowered.common.mixin.core.block.BlockMixin;
import org.spongepowered.common.util.Constants;

@Mixin(value={BlockStem.class})
public abstract class BlockStemMixin
extends BlockMixin {
    public ImmutableList<ImmutableDataManipulator<?, ?>> bridge$getManipulators(IBlockState blockState) {
        return ImmutableList.of(this.impl$getGrowthData(blockState), this.impl$getDirectionalData(blockState));
    }

    @Override
    public boolean bridge$supports(Class<? extends ImmutableDataManipulator<?, ?>> immutable) {
        return ImmutableGrowthData.class.isAssignableFrom(immutable) || ImmutableDirectionalData.class.isAssignableFrom(immutable);
    }

    @Override
    public Optional<BlockState> bridge$getStateWithData(IBlockState blockState, ImmutableDataManipulator<?, ?> manipulator) {
        if (manipulator instanceof ImmutableGrowthData) {
            int growth = (Integer)((ImmutableGrowthData)manipulator).growthStage().get();
            if (growth > 7) {
                growth = 7;
            }
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockStem.field_176484_a, (Comparable)Integer.valueOf(growth)));
        }
        if (manipulator instanceof ImmutableDirectionalData) {
            Direction dir = Constants.DirectionFunctions.checkDirectionNotDown((Direction)((Object)((ImmutableDirectionalData)manipulator).direction().get()));
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockStem.field_176483_b, (Comparable)Constants.DirectionFunctions.getFor(dir)));
        }
        return super.bridge$getStateWithData(blockState, manipulator);
    }

    @Override
    public <E> Optional<BlockState> bridge$getStateWithValue(IBlockState blockState, Key<? extends BaseValue<E>> key, E value) {
        if (key.equals(Keys.GROWTH_STAGE)) {
            int growth = (Integer)value;
            if (growth > 7) {
                growth = 7;
            }
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockStem.field_176484_a, (Comparable)Integer.valueOf(growth)));
        }
        if (key.equals(Keys.DIRECTION)) {
            Direction dir = Constants.DirectionFunctions.checkDirectionNotDown((Direction)((Object)value));
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockStem.field_176483_b, (Comparable)Constants.DirectionFunctions.getFor(dir)));
        }
        return super.bridge$getStateWithValue(blockState, key, value);
    }

    private ImmutableGrowthData impl$getGrowthData(IBlockState blockState) {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeGrowthData.class, blockState.func_177229_b((IProperty)BlockStem.field_176484_a), 0, 7);
    }

    private ImmutableDirectionalData impl$getDirectionalData(IBlockState blockState) {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeDirectionalData.class, new Object[]{Constants.DirectionFunctions.getFor((EnumFacing)blockState.func_177229_b((IProperty)BlockStem.field_176483_b))});
    }
}

