/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import net.minecraft.block.BlockTripWire;
import net.minecraft.block.BlockWall;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableAttachedData;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableConnectedDirectionData;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableDisarmedData;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutablePoweredData;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.util.Direction;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.data.ImmutableDataCachingUtil;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeAttachedData;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeConnectedDirectionData;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeDisarmedData;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongePoweredData;
import org.spongepowered.common.mixin.core.block.BlockMixin;
import org.spongepowered.common.util.Constants;

@Mixin(value={BlockTripWire.class})
public abstract class BlockTripWireMixin
extends BlockMixin {
    public ImmutableList<ImmutableDataManipulator<?, ?>> bridge$getManipulators(IBlockState blockState) {
        return ImmutableList.of(this.impl$getIsDisarmedFor(blockState), this.impl$getIsAttachedFor(blockState), this.impl$getIsPoweredFor(blockState), this.impl$getConnectedDirectionData(blockState));
    }

    @Override
    public boolean bridge$supports(Class<? extends ImmutableDataManipulator<?, ?>> immutable) {
        return ImmutableDisarmedData.class.isAssignableFrom(immutable) || ImmutableAttachedData.class.isAssignableFrom(immutable) || ImmutablePoweredData.class.isAssignableFrom(immutable) || ImmutableConnectedDirectionData.class.isAssignableFrom(immutable);
    }

    private IBlockState impl$applyConnectedDirections(IBlockState blockState, Set<Direction> directions) {
        HashMap<PropertyBool, Boolean> facingStates = new HashMap<PropertyBool, Boolean>();
        for (PropertyBool property : Constants.DirectionFunctions.TripWire.ALL_DIRECTION_PROPERTIES) {
            facingStates.put(property, false);
        }
        for (Direction connectedDirection : directions) {
            Optional<PropertyBool> facingPropertyBox = Constants.DirectionFunctions.TripWire.getPropertyFromDirection(connectedDirection);
            facingPropertyBox.ifPresent(facingProperty -> facingStates.put((PropertyBool)facingProperty, true));
        }
        IBlockState resultBlockState = blockState;
        for (PropertyBool property : facingStates.keySet()) {
            resultBlockState = resultBlockState.func_177226_a((IProperty)property, (Comparable)facingStates.get(property));
        }
        return resultBlockState;
    }

    @Override
    public Optional<BlockState> bridge$getStateWithData(IBlockState blockState, ImmutableDataManipulator<?, ?> manipulator) {
        if (manipulator instanceof ImmutableDisarmedData) {
            boolean disarmed = (Boolean)((ImmutableDisarmedData)manipulator).disarmed().get();
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockTripWire.field_176295_N, (Comparable)Boolean.valueOf(disarmed)));
        }
        if (manipulator instanceof ImmutableAttachedData) {
            return Optional.of((BlockState)blockState);
        }
        if (manipulator instanceof ImmutablePoweredData) {
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockTripWire.field_176293_a, (Comparable)((ImmutablePoweredData)manipulator).powered().get()));
        }
        if (manipulator instanceof ImmutableConnectedDirectionData) {
            ImmutableConnectedDirectionData connectedDirectionData = (ImmutableConnectedDirectionData)manipulator;
            return Optional.of((BlockState)this.impl$applyConnectedDirections(blockState, (Set)connectedDirectionData.connectedDirections().get()));
        }
        return super.bridge$getStateWithData(blockState, manipulator);
    }

    @Override
    public <E> Optional<BlockState> bridge$getStateWithValue(IBlockState blockState, Key<? extends BaseValue<E>> key, E value) {
        if (key.equals(Keys.DISARMED)) {
            boolean disarmed = (Boolean)value;
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockTripWire.field_176295_N, (Comparable)Boolean.valueOf(disarmed)));
        }
        if (key.equals(Keys.SUSPENDED)) {
            return Optional.of((BlockState)blockState);
        }
        if (key.equals(Keys.ATTACHED)) {
            return Optional.of((BlockState)blockState);
        }
        if (key.equals(Keys.POWERED)) {
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockTripWire.field_176293_a, (Comparable)((Boolean)value)));
        }
        if (key.equals(Keys.CONNECTED_DIRECTIONS)) {
            return Optional.of((BlockState)this.impl$applyConnectedDirections(blockState, (Set)value));
        }
        if (key.equals(Keys.CONNECTED_EAST)) {
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockWall.field_176257_M, (Comparable)((Boolean)value)));
        }
        if (key.equals(Keys.CONNECTED_NORTH)) {
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockWall.field_176254_b, (Comparable)((Boolean)value)));
        }
        if (key.equals(Keys.CONNECTED_SOUTH)) {
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockWall.field_176258_N, (Comparable)((Boolean)value)));
        }
        if (key.equals(Keys.CONNECTED_WEST)) {
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockWall.field_176259_O, (Comparable)((Boolean)value)));
        }
        return super.bridge$getStateWithValue(blockState, key, value);
    }

    private ImmutableDisarmedData impl$getIsDisarmedFor(IBlockState blockState) {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeDisarmedData.class, blockState.func_177229_b((IProperty)BlockTripWire.field_176295_N));
    }

    private ImmutableAttachedData impl$getIsAttachedFor(IBlockState blockState) {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeAttachedData.class, blockState.func_177229_b((IProperty)BlockTripWire.field_176294_M));
    }

    private ImmutablePoweredData impl$getIsPoweredFor(IBlockState blockState) {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongePoweredData.class, blockState.func_177229_b((IProperty)BlockTripWire.field_176293_a));
    }

    private ImmutableConnectedDirectionData impl$getConnectedDirectionData(IBlockState blockState) {
        EnumSet<Direction> directions = EnumSet.noneOf(Direction.class);
        Boolean north = (Boolean)blockState.func_177229_b((IProperty)BlockTripWire.field_176296_O);
        Boolean east = (Boolean)blockState.func_177229_b((IProperty)BlockTripWire.field_176291_P);
        Boolean west = (Boolean)blockState.func_177229_b((IProperty)BlockTripWire.field_176292_R);
        Boolean south = (Boolean)blockState.func_177229_b((IProperty)BlockTripWire.field_176289_Q);
        if (north.booleanValue()) {
            directions.add(Direction.NORTH);
        }
        if (south.booleanValue()) {
            directions.add(Direction.SOUTH);
        }
        if (west.booleanValue()) {
            directions.add(Direction.WEST);
        }
        if (east.booleanValue()) {
            directions.add(Direction.EAST);
        }
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeConnectedDirectionData.class, directions);
    }
}

