/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.merge.MergeFunction;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.bridge.data.CustomDataHolderBridge;
import org.spongepowered.common.entity.player.SpongeUser;

@Mixin(value={TileEntity.class, Entity.class, SpongeUser.class})
public abstract class CustomDataHolderMixin
implements CustomDataHolderBridge {
    private List<DataManipulator<?, ?>> impl$manipulators = Lists.newArrayList();
    private List<DataView> impl$failedData = Lists.newArrayList();

    @Override
    public DataTransactionResult bridge$offerCustom(DataManipulator<?, ?> manipulator, MergeFunction function) {
        DataManipulator<?, ?> existingManipulator = null;
        for (DataManipulator<?, ?> existing : this.impl$manipulators) {
            if (!manipulator.getClass().isInstance(existing)) continue;
            existingManipulator = existing;
            break;
        }
        DataTransactionResult.Builder builder = DataTransactionResult.builder();
        DataManipulator newManipulator = (DataManipulator)Preconditions.checkNotNull(function.merge(existingManipulator, manipulator.copy()));
        if (existingManipulator != null) {
            builder.replace(existingManipulator.getValues());
            this.impl$manipulators.remove(existingManipulator);
        }
        this.impl$manipulators.add(newManipulator);
        return builder.success(newManipulator.getValues()).result(DataTransactionResult.Type.SUCCESS).build();
    }

    @Override
    public <T extends DataManipulator<?, ?>> Optional<T> bridge$getCustom(Class<T> customClass) {
        for (DataManipulator<?, ?> existing : this.impl$manipulators) {
            if (!customClass.isInstance(existing)) continue;
            return Optional.of(existing.copy());
        }
        return Optional.empty();
    }

    @Override
    public DataTransactionResult bridge$removeCustom(Class<? extends DataManipulator<?, ?>> customClass) {
        DataManipulator<?, ?> manipulator = null;
        for (DataManipulator<?, ?> existing : this.impl$manipulators) {
            if (!customClass.isInstance(existing)) continue;
            manipulator = existing;
        }
        if (manipulator != null) {
            this.impl$manipulators.remove(manipulator);
            this.bridge$removeCustomFromNbt(manipulator);
            return DataTransactionResult.builder().replace(manipulator.getValues()).result(DataTransactionResult.Type.SUCCESS).build();
        }
        return DataTransactionResult.failNoData();
    }

    @Override
    public boolean bridge$hasManipulators() {
        return !this.impl$manipulators.isEmpty();
    }

    @Override
    public boolean bridge$supportsCustom(Key<?> key) {
        return this.impl$manipulators.stream().anyMatch(manipulator -> manipulator.supports(key));
    }

    @Override
    public <E> Optional<E> bridge$getCustom(Key<? extends BaseValue<E>> key) {
        return this.impl$manipulators.stream().filter(manipulator -> manipulator.supports(key)).findFirst().flatMap(supported -> supported.get(key));
    }

    @Override
    public <E, V extends BaseValue<E>> Optional<V> bridge$getCustomValue(Key<V> key) {
        return this.impl$manipulators.stream().filter(manipulator -> manipulator.supports(key)).findFirst().flatMap(supported -> supported.getValue(key));
    }

    @Override
    public Collection<DataManipulator<?, ?>> bridge$getCustomManipulators() {
        return this.impl$manipulators.stream().map(DataManipulator::copy).collect(Collectors.toList());
    }

    @Override
    public <E> DataTransactionResult bridge$offerCustom(Key<? extends BaseValue<E>> key, E value) {
        for (DataManipulator<? extends BaseValue<E>, ? extends BaseValue<E>> dataManipulator : this.impl$manipulators) {
            if (!dataManipulator.supports(key)) continue;
            DataTransactionResult.Builder builder = DataTransactionResult.builder();
            builder.replace(((Value)dataManipulator.getValue(key).get()).asImmutable());
            dataManipulator.set(key, value);
            builder.success(((Value)dataManipulator.getValue(key).get()).asImmutable());
            return builder.result(DataTransactionResult.Type.SUCCESS).build();
        }
        return DataTransactionResult.failNoData();
    }

    @Override
    public DataTransactionResult bridge$removeCustom(Key<?> key) {
        Iterator<DataManipulator<?, ?>> iterator = this.impl$manipulators.iterator();
        while (iterator.hasNext()) {
            DataManipulator<?, ?> manipulator = iterator.next();
            if (manipulator.getKeys().size() != 1 || !manipulator.supports(key)) continue;
            iterator.remove();
            this.bridge$removeCustomFromNbt(manipulator);
            return DataTransactionResult.builder().replace(manipulator.getValues()).result(DataTransactionResult.Type.SUCCESS).build();
        }
        return DataTransactionResult.failNoData();
    }

    @Override
    public void bridge$addFailedData(ImmutableList<DataView> failedData) {
        this.impl$failedData.addAll(failedData);
    }

    @Override
    public List<DataView> bridge$getFailedData() {
        return this.impl$failedData;
    }
}

