/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity;

import co.aikar.timings.Timing;
import com.flowpowered.math.vector.Vector3d;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketDestroyEntities;
import net.minecraft.network.play.server.SPacketPlayerListItem;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.dismount.DismountType;
import org.spongepowered.api.event.cause.entity.dismount.DismountTypes;
import org.spongepowered.api.event.entity.IgniteEntityEvent;
import org.spongepowered.api.event.message.MessageEvent;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.bridge.TimingBridge;
import org.spongepowered.common.bridge.TrackableBridge;
import org.spongepowered.common.bridge.block.BlockBridge;
import org.spongepowered.common.bridge.data.DataCompoundHolder;
import org.spongepowered.common.bridge.data.InvulnerableTrackedBridge;
import org.spongepowered.common.bridge.data.VanishableBridge;
import org.spongepowered.common.bridge.entity.EntityBridge;
import org.spongepowered.common.bridge.entity.GrieferBridge;
import org.spongepowered.common.bridge.network.NetHandlerPlayServerBridge;
import org.spongepowered.common.bridge.util.DamageSourceBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.bridge.world.chunk.ActiveChunkReferantBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.entity.SpongeEntityType;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.damage.DamageEventHandler;
import org.spongepowered.common.event.damage.MinecraftBlockDamageSource;
import org.spongepowered.common.mixin.core.entity.EntityTrackerAccessor;
import org.spongepowered.common.mixin.core.entity.EntityTrackerEntryAccessor;
import org.spongepowered.common.registry.type.entity.EntityTypeRegistryModule;
import org.spongepowered.common.text.SpongeTexts;
import org.spongepowered.common.util.SpongeHooks;

@Mixin(value={net.minecraft.entity.Entity.class})
public abstract class EntityMixin
implements EntityBridge,
TrackableBridge,
VanishableBridge,
InvulnerableTrackedBridge,
TimingBridge {
    protected final SpongeEntityType entityType = EntityTypeRegistryModule.getInstance().getForClass(((net.minecraft.entity.Entity)this).getClass());
    private boolean isConstructing = true;
    @Nullable
    private Text displayName;
    @Nullable
    private BlockPos lastCollidedBlockPos;
    private boolean trackedInWorld = false;
    private boolean vanish$collision = false;
    private boolean vanish$untargetable = false;
    private boolean vanish$isVanished = false;
    private boolean vanish$pendingVisibilityUpdate = false;
    private int vanish$visibilityTicks = 0;
    @Nullable
    private Cause impl$destructCause;
    @Shadow
    @Nullable
    private net.minecraft.entity.Entity field_184239_as;
    @Shadow
    @Final
    private List<net.minecraft.entity.Entity> field_184244_h;
    @Shadow
    public net.minecraft.world.World field_70170_p;
    @Shadow
    public double field_70165_t;
    @Shadow
    public double field_70163_u;
    @Shadow
    public double field_70161_v;
    @Shadow
    public double field_70159_w;
    @Shadow
    public double field_70181_x;
    @Shadow
    public double field_70179_y;
    @Shadow
    public float field_70177_z;
    @Shadow
    public float field_70125_A;
    @Shadow
    public boolean field_70133_I;
    @Shadow
    public boolean field_70122_E;
    @Shadow
    public boolean field_70128_L;
    @Shadow
    public float field_70130_N;
    @Shadow
    public float field_70131_O;
    @Shadow
    public float field_70141_P;
    @Shadow
    public float field_70140_Q;
    @Shadow
    public float field_70143_R;
    @Shadow
    protected Random field_70146_Z;
    @Shadow
    public int field_70173_aa;
    @Shadow
    public int field_190534_ay;
    @Shadow
    public int field_70172_ad;
    @Shadow
    protected EntityDataManager field_70180_af;
    @Shadow
    public int field_71093_bK;
    @Shadow
    private boolean field_83001_bt;
    private boolean skipSettingCustomNameTag = false;

    @Shadow
    public abstract void func_70107_b(double var1, double var3, double var5);

    @Shadow
    public abstract void func_70106_y();

    @Shadow
    public abstract int func_70086_ai();

    @Shadow
    public abstract void func_70050_g(int var1);

    @Shadow
    public abstract float func_70047_e();

    @Shadow
    public abstract void func_96094_a(String var1);

    @Shadow
    public abstract UUID func_110124_au();

    @Shadow
    public abstract AxisAlignedBB func_174813_aQ();

    @Shadow
    public abstract void func_70015_d(int var1);

    @Shadow
    public abstract NBTTagCompound func_189511_e(NBTTagCompound var1);

    @Shadow
    public abstract boolean func_70097_a(DamageSource var1, float var2);

    @Shadow
    public abstract int func_145782_y();

    @Shadow
    public abstract boolean func_184207_aI();

    @Shadow
    public abstract SoundCategory func_184176_by();

    @Shadow
    public abstract List<net.minecraft.entity.Entity> shadow$func_184188_bt();

    @Shadow
    public abstract net.minecraft.entity.Entity func_184187_bx();

    @Shadow
    public abstract void func_184201_a(EntityEquipmentSlot var1, ItemStack var2);

    @Shadow
    public abstract void func_184185_a(SoundEvent var1, float var2, float var3);

    @Shadow
    public abstract boolean func_180431_b(DamageSource var1);

    @Shadow
    public abstract boolean func_70051_ag();

    @Shadow
    public abstract boolean shadow$func_70090_H();

    @Shadow
    public abstract boolean func_184218_aH();

    @Shadow
    public abstract boolean func_184191_r(net.minecraft.entity.Entity var1);

    @Shadow
    public abstract double func_70068_e(net.minecraft.entity.Entity var1);

    @Shadow
    public abstract void func_70012_b(double var1, double var3, double var5, float var7, float var8);

    @Shadow
    public abstract void func_70634_a(double var1, double var3, double var5);

    @Shadow
    protected abstract void func_184225_p(net.minecraft.entity.Entity var1);

    @Shadow
    protected abstract void func_70105_a(float var1, float var2);

    @Shadow
    protected abstract void func_174815_a(EntityLivingBase var1, net.minecraft.entity.Entity var2);

    @Shadow
    public abstract void func_70066_B();

    @Shadow
    protected abstract void func_70052_a(int var1, boolean var2);

    @Shadow
    @Nullable
    public net.minecraft.entity.Entity func_184204_a(int dimension) {
        return null;
    }

    @Shadow
    public abstract boolean func_82150_aj();

    @Shadow
    public abstract void func_82142_c(boolean var1);

    @Redirect(method={"<init>"}, at=@At(value="FIELD", target="Lnet/minecraft/entity/Entity;dimension:I", opcode=181))
    private void impl$UpdateDimension(net.minecraft.entity.Entity self, int dimensionId, net.minecraft.world.World worldIn) {
        self.field_71093_bK = worldIn instanceof WorldServerBridge ? ((WorldServerBridge)worldIn).bridge$getDimensionId() : dimensionId;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onSpongeConstruction(net.minecraft.world.World worldIn, CallbackInfo ci) {
        if (this.entityType.isKnown()) {
            this.bridge$refreshTrackerStates();
            if (this.entityType.getEnumCreatureType() == null) {
                for (EnumCreatureType type : EnumCreatureType.values()) {
                    if (!SpongeImplHooks.isCreatureOfType((net.minecraft.entity.Entity)this, type)) continue;
                    this.entityType.setEnumCreatureType(type);
                    break;
                }
            }
        }
    }

    @Override
    public boolean bridge$isConstructing() {
        return this.isConstructing;
    }

    @Override
    public void bridge$fireConstructors() {
        this.isConstructing = false;
    }

    @Override
    public boolean bridge$isWorldTracked() {
        return this.trackedInWorld;
    }

    @Override
    public void bridge$setWorldTracked(boolean tracked) {
        this.trackedInWorld = tracked;
        if (!tracked && this.impl$destructCause != null) {
            MessageChannel originalChannel = MessageChannel.TO_NONE;
            SpongeImpl.postEvent(SpongeEventFactory.createDestructEntityEvent(this.impl$destructCause, originalChannel, Optional.of(originalChannel), new MessageEvent.MessageFormatter(), (Entity)((Object)this), true));
            this.impl$destructCause = null;
        }
    }

    @Inject(method={"startRiding(Lnet/minecraft/entity/Entity;Z)Z"}, at={@At(value="FIELD", target="Lnet/minecraft/entity/Entity;ridingEntity:Lnet/minecraft/entity/Entity;", ordinal=0)}, cancellable=true)
    private void onStartRiding(net.minecraft.entity.Entity vehicle, boolean force, CallbackInfoReturnable<Boolean> ci) {
        if (!this.field_70170_p.field_72995_K && ShouldFire.RIDE_ENTITY_EVENT_MOUNT) {
            Sponge.getCauseStackManager().pushCause(this);
            if (SpongeImpl.postEvent(SpongeEventFactory.createRideEntityEventMount(Sponge.getCauseStackManager().getCurrentCause(), (Entity)vehicle))) {
                ci.cancel();
            }
            Sponge.getCauseStackManager().popCause();
        }
    }

    @Overwrite
    public void func_184210_p() {
        if (this.field_184239_as != null) {
            if (this.func_184187_bx().field_70128_L) {
                this.spongeImpl$dismountRidingEntity(DismountTypes.DEATH);
            } else {
                this.spongeImpl$dismountRidingEntity(DismountTypes.PLAYER);
            }
        }
    }

    private boolean spongeImpl$dismountRidingEntity(DismountType type) {
        if (!this.field_70170_p.field_72995_K && ShouldFire.RIDE_ENTITY_EVENT_DISMOUNT) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.pushCause(this);
                frame.addContext(EventContextKeys.DISMOUNT_TYPE, type);
                if (SpongeImpl.postEvent(SpongeEventFactory.createRideEntityEventDismount(frame.getCurrentCause(), type, (Entity)this.func_184187_bx()))) {
                    boolean bl2 = false;
                    return bl2;
                }
            }
        }
        if (this.field_184239_as != null) {
            EntityMixin entity = (EntityMixin)this.field_184239_as;
            this.field_184239_as = null;
            entity.func_184225_p((net.minecraft.entity.Entity)this);
        }
        return true;
    }

    @Override
    public boolean bridge$removePassengers(DismountType type) {
        boolean dismount = false;
        for (int i = this.field_184244_h.size() - 1; i >= 0; --i) {
            dismount = ((EntityMixin)this.field_184244_h.get(i)).spongeImpl$dismountRidingEntity(type) || dismount;
        }
        return dismount;
    }

    @Inject(method={"move"}, at={@At(value="HEAD")}, cancellable=true)
    private void spongeImpl$onSpongeMoveEntity(MoverType type, double x, double y, double z, CallbackInfo ci) {
        if (!this.field_70170_p.field_72995_K && !SpongeHooks.checkEntitySpeed((net.minecraft.entity.Entity)this, x, y, z)) {
            ci.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"setOnFireFromLava"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z"))
    private boolean impl$createLavaBlockDamageSource(net.minecraft.entity.Entity entity, DamageSource source, float damage) {
        if (this.field_70170_p.field_72995_K) {
            return entity.func_70097_a(source, damage);
        }
        try {
            AxisAlignedBB bb = this.func_174813_aQ().func_72314_b((double)-0.1f, (double)-0.4f, (double)-0.1f);
            Location<World> location = DamageEventHandler.findFirstMatchingBlock((net.minecraft.entity.Entity)this, bb, block -> block.func_185904_a() == Material.field_151587_i);
            MinecraftBlockDamageSource lava = new MinecraftBlockDamageSource("lava", location);
            lava.impl$setFireDamage();
            ((DamageSourceBridge)((Object)lava)).bridge$setLava();
            boolean bl2 = entity.func_70097_a(DamageSource.field_76371_c, damage);
            return bl2;
        }
        finally {
            ((DamageSourceBridge)source).bridge$setLava();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"dealFireDamage"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z"))
    private boolean onSpongeRedirectForFireDamage(net.minecraft.entity.Entity entity, DamageSource source, float damage) {
        if (this.field_70170_p.field_72995_K) {
            return entity.func_70097_a(source, damage);
        }
        try {
            AxisAlignedBB bb = this.func_174813_aQ().func_72314_b(-0.001, -0.001, -0.001);
            Location<World> location = DamageEventHandler.findFirstMatchingBlock((net.minecraft.entity.Entity)this, bb, block -> block.func_177230_c() == Blocks.field_150480_ab || block.func_177230_c() == Blocks.field_150356_k || block.func_177230_c() == Blocks.field_150353_l);
            MinecraftBlockDamageSource fire = new MinecraftBlockDamageSource("inFire", location);
            fire.impl$setFireDamage();
            ((DamageSourceBridge)((Object)fire)).bridge$setFireSource();
            boolean bl2 = entity.func_70097_a(DamageSource.field_76372_a, damage);
            return bl2;
        }
        finally {
            ((DamageSourceBridge)source).bridge$setFireSource();
        }
    }

    @Inject(method={"setPosition"}, at={@At(value="HEAD")})
    private void onSetPosition(double x, double y, double z, CallbackInfo ci) {
        if ((net.minecraft.entity.Entity)this instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)this;
            if (player.field_71135_a != null) {
                ((NetHandlerPlayServerBridge)player.field_71135_a).bridge$captureCurrentPlayerPosition();
            }
        }
    }

    public Vector3d getPosition() {
        return new Vector3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    @Override
    public void bridge$setLocationAndAngles(Transform<World> transform) {
        Vector3d position = transform.getPosition();
        EntityPlayerMP player = null;
        if ((net.minecraft.entity.Entity)this instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)this;
        }
        if (player != null && player.field_71135_a != null) {
            player.field_71135_a.func_147364_a(position.getX(), position.getY(), position.getZ(), (float)transform.getYaw(), (float)transform.getPitch());
        } else {
            this.func_70012_b(position.getX(), position.getY(), position.getZ(), (float)transform.getYaw(), (float)transform.getPitch());
        }
        if (this.field_70170_p != transform.getExtent()) {
            this.field_70170_p = (net.minecraft.world.World)transform.getExtent();
            this.field_71093_bK = ((WorldServerBridge)this.field_70170_p).bridge$getDimensionId();
        }
    }

    @Inject(method={"onUpdate"}, at={@At(value="RETURN")})
    private void impl$updateVanishState(CallbackInfo callbackInfo) {
        if (this.vanish$pendingVisibilityUpdate && !this.field_70170_p.field_72995_K) {
            EntityTracker entityTracker = ((WorldServer)this.field_70170_p).func_73039_n();
            EntityTrackerEntry lookup = (EntityTrackerEntry)((EntityTrackerAccessor)entityTracker).accessor$getTrackedEntityTable().func_76041_a(this.func_145782_y());
            if (lookup != null && this.vanish$visibilityTicks % 4 == 0) {
                if (this.vanish$isVanished) {
                    for (EntityPlayerMP entityPlayerMP : ((EntityTrackerEntryAccessor)lookup).accessor$getTrackingPlayers()) {
                        entityPlayerMP.field_71135_a.func_147359_a((Packet)new SPacketDestroyEntities(new int[]{this.func_145782_y()}));
                        if (!((net.minecraft.entity.Entity)this instanceof EntityPlayerMP)) continue;
                        entityPlayerMP.field_71135_a.func_147359_a((Packet)new SPacketPlayerListItem(SPacketPlayerListItem.Action.REMOVE_PLAYER, new EntityPlayerMP[]{(EntityPlayerMP)this}));
                    }
                } else {
                    this.vanish$visibilityTicks = 1;
                    this.vanish$pendingVisibilityUpdate = false;
                    for (EntityPlayerMP entityPlayerMP : SpongeImpl.getServer().func_184103_al().func_181057_v()) {
                        if ((net.minecraft.entity.Entity)this == entityPlayerMP) continue;
                        if ((net.minecraft.entity.Entity)this instanceof EntityPlayerMP) {
                            SPacketPlayerListItem packet = new SPacketPlayerListItem(SPacketPlayerListItem.Action.ADD_PLAYER, new EntityPlayerMP[]{(EntityPlayerMP)this});
                            entityPlayerMP.field_71135_a.func_147359_a((Packet)packet);
                        }
                        Packet<?> newPacket = ((EntityTrackerEntryAccessor)lookup).accessor$createSpawnPacket();
                        entityPlayerMP.field_71135_a.func_147359_a(newPacket);
                    }
                }
            }
            if (this.vanish$visibilityTicks > 0) {
                --this.vanish$visibilityTicks;
            } else {
                this.vanish$pendingVisibilityUpdate = false;
            }
        }
    }

    @Override
    public boolean bridge$getIsInvulnerable() {
        return this.field_83001_bt;
    }

    @Inject(method={"writeToNBT(Lnet/minecraft/nbt/NBTTagCompound;)Lnet/minecraft/nbt/NBTTagCompound;"}, at={@At(value="HEAD")})
    private void onSpongeWriteToNBT(NBTTagCompound compound, CallbackInfoReturnable<NBTTagCompound> ci) {
        this.spongeImpl$writeToSpongeCompound(((DataCompoundHolder)((Object)this)).data$getSpongeCompound());
    }

    @Inject(method={"readFromNBT(Lnet/minecraft/nbt/NBTTagCompound;)V"}, at={@At(value="RETURN")})
    private void onSpongeReadFromNBT(NBTTagCompound compound, CallbackInfo ci) {
        if (this.isConstructing) {
            this.bridge$fireConstructors();
        }
        this.spongeImpl$readFromSpongeCompound(((DataCompoundHolder)((Object)this)).data$getSpongeCompound());
    }

    protected void spongeImpl$readFromSpongeCompound(NBTTagCompound compound) {
        DataUtil.readCustomData(compound, (Entity)((Object)this));
        if (this instanceof GrieferBridge && ((GrieferBridge)((Object)this)).bridge$isGriefer() && compound.func_74764_b("CanGrief")) {
            ((GrieferBridge)((Object)this)).bridge$SetCanGrief(compound.func_74767_n("CanGrief"));
        }
        if (compound.func_150297_b("IsVanished", 1)) {
            this.bridge$setVanished(compound.func_74767_n("IsVanished"));
            this.bridge$setUncollideable(compound.func_74767_n("VanishUnCollideable"));
            this.bridge$setUntargetable(compound.func_74767_n("VanishUnTargetable"));
        }
        if (compound.func_150297_b("IsInvisible", 1)) {
            this.bridge$setInvisible(compound.func_74767_n("IsInvisible"));
        }
    }

    protected void spongeImpl$writeToSpongeCompound(NBTTagCompound compound) {
        DataUtil.writeCustomData(compound, (Entity)((Object)this));
        if (this instanceof GrieferBridge && ((GrieferBridge)((Object)this)).bridge$isGriefer() && ((GrieferBridge)((Object)this)).bridge$CanGrief()) {
            compound.func_74757_a("CanGrief", true);
        }
        if (this.bridge$isVanished()) {
            compound.func_74757_a("IsVanished", true);
            compound.func_74757_a("VanishUnCollideable", this.bridge$isUncollideable());
            compound.func_74757_a("VanishUnTargetable", this.bridge$isUntargetable());
        }
        if (this.func_82150_aj()) {
            compound.func_74757_a("IsInvisible", true);
        }
    }

    @Override
    public void bridge$setImplVelocity(Vector3d velocity) {
        this.field_70159_w = Preconditions.checkNotNull(velocity).getX();
        this.field_70181_x = velocity.getY();
        this.field_70179_y = velocity.getZ();
        this.field_70133_I = true;
    }

    @Redirect(method={"move"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/Block;onEntityWalk(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/Entity;)V"))
    private void spongeImpl$onEntityCollideWithBlockThrowEventSponge(Block block, net.minecraft.world.World world, BlockPos pos, net.minecraft.entity.Entity entity) {
        if (!((BlockBridge)block).bridge$hasCollideLogic()) {
            return;
        }
        if (world.field_72995_K) {
            block.func_176199_a(world, pos, entity);
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        if (!SpongeCommonEventFactory.handleCollideBlockEvent(block, world, pos, state, entity, Direction.NONE)) {
            block.func_176199_a(world, pos, entity);
            this.lastCollidedBlockPos = pos;
        }
    }

    @Redirect(method={"doBlockCollisions"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/Block;onEntityCollision(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/Entity;)V"))
    private void spongeImpl$onEntityCollideWithBlockState(Block block, net.minecraft.world.World world, BlockPos pos, IBlockState state, net.minecraft.entity.Entity entity) {
        if (!((BlockBridge)block).bridge$hasCollideWithStateLogic()) {
            return;
        }
        if (world.field_72995_K) {
            block.func_180634_a(world, pos, state, entity);
            return;
        }
        if (!SpongeCommonEventFactory.handleCollideBlockEvent(block, world, pos, state, entity, Direction.NONE)) {
            block.func_180634_a(world, pos, state, entity);
            this.lastCollidedBlockPos = pos;
        }
    }

    @Redirect(method={"updateFallState"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/Block;onFallenUpon(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/Entity;F)V"))
    private void spongeImpl$onBlockFallenUpon(Block block, net.minecraft.world.World world, BlockPos pos, net.minecraft.entity.Entity entity, float fallDistance) {
        if (world.field_72995_K) {
            block.func_180658_a(world, pos, entity, fallDistance);
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        if (!SpongeCommonEventFactory.handleCollideBlockEvent(block, world, pos, state, entity, Direction.UP)) {
            block.func_180658_a(world, pos, entity, fallDistance);
            this.lastCollidedBlockPos = pos;
        }
    }

    @Override
    public boolean bridge$isInvisible() {
        return this.func_82150_aj();
    }

    @Override
    public void bridge$setInvisible(boolean invisible) {
        this.func_82142_c(invisible);
        if (invisible) {
            NBTTagCompound spongeData = ((DataCompoundHolder)((Object)this)).data$getSpongeCompound();
            spongeData.func_74757_a("IsInvisible", true);
        } else if (((DataCompoundHolder)((Object)this)).data$hasSpongeCompound()) {
            ((DataCompoundHolder)((Object)this)).data$getSpongeCompound().func_82580_o("IsInvisible");
        }
    }

    @Override
    public boolean bridge$isVanished() {
        return this.vanish$isVanished;
    }

    @Override
    public void bridge$setVanished(boolean vanished) {
        this.vanish$isVanished = vanished;
        this.vanish$pendingVisibilityUpdate = true;
        this.vanish$visibilityTicks = 20;
        if (vanished) {
            NBTTagCompound spongeData = ((DataCompoundHolder)((Object)this)).data$getSpongeCompound();
            spongeData.func_74757_a("IsVanished", true);
        } else if (((DataCompoundHolder)((Object)this)).data$hasSpongeCompound()) {
            NBTTagCompound spongeData = ((DataCompoundHolder)((Object)this)).data$getSpongeCompound();
            spongeData.func_82580_o("IsVanished");
            spongeData.func_82580_o("VanishUnCollideable");
            spongeData.func_82580_o("VanishUnTargetable");
        }
    }

    @Override
    public boolean bridge$isUncollideable() {
        return this.vanish$collision;
    }

    @Override
    public void bridge$setUncollideable(boolean prevents) {
        this.vanish$collision = prevents;
    }

    @Override
    public boolean bridge$isUntargetable() {
        return this.vanish$untargetable;
    }

    @Override
    public void bridge$setUntargetable(boolean untargetable) {
        this.vanish$untargetable = untargetable;
    }

    @Redirect(method={"playSound"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;isSilent()Z"))
    private boolean spongeImpl$checkIsSilentOrInvis(net.minecraft.entity.Entity entity) {
        return entity.func_174814_R() || this.vanish$isVanished;
    }

    @Redirect(method={"applyEntityCollision"}, at=@At(value="FIELD", target="Lnet/minecraft/entity/Entity;noClip:Z", opcode=180))
    private boolean spongeApplyEntityCollisionCheckVanish(net.minecraft.entity.Entity entity) {
        return entity.field_70145_X || ((VanishableBridge)entity).bridge$isVanished();
    }

    @Redirect(method={"doWaterSplashEffect"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;spawnParticle(Lnet/minecraft/util/EnumParticleTypes;DDDDDD[I)V"))
    private void spawnParticle(net.minecraft.world.World world, EnumParticleTypes particleTypes, double xCoord, double yCoord, double zCoord, double xOffset, double yOffset, double zOffset, int ... p_175688_14_) {
        if (!this.vanish$isVanished) {
            this.field_70170_p.func_175688_a(particleTypes, xCoord, yCoord, zCoord, xOffset, yOffset, zOffset, p_175688_14_);
        }
    }

    @Redirect(method={"createRunningParticles"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;spawnParticle(Lnet/minecraft/util/EnumParticleTypes;DDDDDD[I)V"))
    private void runningSpawnParticle(net.minecraft.world.World world, EnumParticleTypes particleTypes, double xCoord, double yCoord, double zCoord, double xOffset, double yOffset, double zOffset, int ... p_175688_14_) {
        if (!this.vanish$isVanished) {
            this.field_70170_p.func_175688_a(particleTypes, xCoord, yCoord, zCoord, xOffset, yOffset, zOffset, p_175688_14_);
        }
    }

    @Override
    @Nullable
    public Text bridge$getDisplayNameText() {
        return this.displayName;
    }

    @Override
    public void bridge$setDisplayName(@Nullable Text displayName) {
        this.displayName = displayName;
        this.skipSettingCustomNameTag = true;
        if (this.displayName == null) {
            this.func_96094_a("");
        } else {
            this.func_96094_a(SpongeTexts.toLegacy(this.displayName));
        }
        this.skipSettingCustomNameTag = false;
    }

    @Inject(method={"setCustomNameTag"}, at={@At(value="RETURN")})
    private void impl$UpdatedisplayNameText(String name, CallbackInfo ci) {
        if (!this.skipSettingCustomNameTag) {
            this.displayName = SpongeTexts.fromLegacy(name);
        }
    }

    @Overwrite
    @Nullable
    public EntityItem func_70099_a(ItemStack stack, float offsetY) {
        if (this.field_70170_p.field_72995_K) {
            if (stack.func_190926_b()) {
                return null;
            }
            EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)offsetY, this.field_70161_v, stack);
            entityitem.func_174869_p();
            this.field_70170_p.func_72838_d((net.minecraft.entity.Entity)entityitem);
            return entityitem;
        }
        return EntityUtil.entityOnDropItem((net.minecraft.entity.Entity)this, stack, offsetY, ((net.minecraft.entity.Entity)this).field_70165_t, ((net.minecraft.entity.Entity)this).field_70161_v);
    }

    @Override
    @Nullable
    public BlockPos bridge$getLastCollidedBlockPos() {
        return this.lastCollidedBlockPos;
    }

    @Override
    public Timing bridge$getTimingsHandler() {
        return this.entityType.getTimingsHandler();
    }

    @Override
    public boolean bridge$shouldTick() {
        ChunkBridge chunk = ((ActiveChunkReferantBridge)((Object)this)).bridge$getActiveChunk();
        return chunk == null || chunk.bridge$isActive();
    }

    @Override
    public void bridge$setInvulnerable(boolean value) {
        this.field_83001_bt = value;
    }

    @Override
    public boolean bridge$allowsBlockBulkCapture() {
        return this.entityType.allowsBlockBulkCapture;
    }

    @Override
    public boolean bridge$allowsEntityBulkCapture() {
        return this.entityType.allowsEntityBulkCapture;
    }

    @Override
    public boolean bridge$allowsBlockEventCreation() {
        return this.entityType.allowsBlockEventCreation;
    }

    @Override
    public boolean bridge$allowsEntityEventCreation() {
        return this.entityType.allowsEntityEventCreation;
    }

    @Redirect(method={"setFire"}, at=@At(value="FIELD", target="Lnet/minecraft/entity/Entity;fire:I", opcode=181))
    private void spongeImpl$ThrowIgniteEventForFire(net.minecraft.entity.Entity entity, int ticks) {
        if (((WorldBridge)this.field_70170_p).bridge$isFake() || !ShouldFire.IGNITE_ENTITY_EVENT) {
            this.field_190534_ay = ticks;
            return;
        }
        if (this.field_190534_ay < 1 && !this.spongeImpl$isImmuneToFireForIgniteEvent()) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.pushCause(((Entity)((Object)this)).getLocation().getExtent());
                IgniteEntityEvent event = SpongeEventFactory.createIgniteEntityEvent(frame.getCurrentCause(), ticks, ticks, (Entity)((Object)this));
                if (SpongeImpl.postEvent(event)) {
                    this.field_190534_ay = 0;
                    return;
                }
                this.field_190534_ay = event.getFireTicks();
            }
        }
    }

    protected boolean spongeImpl$isImmuneToFireForIgniteEvent() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"onStruckByLightning"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z"))
    private boolean spongeImpl$ThrowDamageEventWithLightingSource(net.minecraft.entity.Entity entity, DamageSource source, float damage, EntityLightningBolt lightningBolt) {
        if (!this.field_70170_p.field_72995_K) {
            return entity.func_70097_a(source, damage);
        }
        try {
            EntityDamageSource lightning = new EntityDamageSource("lightningBolt", (net.minecraft.entity.Entity)lightningBolt);
            ((DamageSourceBridge)lightning).bridge$setLightningSource();
            boolean bl2 = entity.func_70097_a(DamageSource.field_180137_b, damage);
            return bl2;
        }
        finally {
            ((DamageSourceBridge)source).bridge$setLightningSource();
        }
    }

    @Inject(method={"setDead"}, at={@At(value="RETURN")})
    private void impl$createDestructionEventOnDeath(CallbackInfo ci) {
        if (ShouldFire.DESTRUCT_ENTITY_EVENT && !((WorldBridge)this.field_70170_p).bridge$isFake() && !((net.minecraft.entity.Entity)this instanceof EntityLiving)) {
            this.impl$destructCause = Sponge.getCauseStackManager().getCurrentCause();
        }
    }
}

