/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.ai;

import com.google.common.base.MoreObjects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.EntityAIBase;
import org.spongepowered.api.entity.ai.Goal;
import org.spongepowered.api.entity.ai.task.AITaskType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.entity.ai.EntityAIBasesBridge;
import org.spongepowered.common.registry.type.entity.AITaskTypeModule;

@Mixin(value={EntityAIBase.class})
public abstract class EntityAIBaseMixin
implements EntityAIBasesBridge {
    private AITaskType impl$type;
    private Optional<Goal<?>> impl$owner = Optional.empty();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void assignAITaskType(CallbackInfo ci) {
        Optional<AITaskType> optAiTaskType = AITaskTypeModule.getInstance().getByAIClass(this.getClass());
        if (optAiTaskType.isPresent()) {
            this.impl$type = optAiTaskType.get();
        }
    }

    @Override
    public AITaskType bridge$getType() {
        return this.impl$type;
    }

    @Override
    public void bridge$setType(AITaskType type) {
        this.impl$type = type;
    }

    @Override
    public Optional<Goal<?>> bridge$getAIGoal() {
        return this.impl$owner;
    }

    @Override
    public void bridge$setGoal(@Nullable Goal<?> owner) {
        this.impl$owner = Optional.ofNullable(owner);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).addValue(this.impl$type).addValue(this.impl$owner).toString();
    }
}

