/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.ai;

import com.google.common.base.MoreObjects;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.ai.Goal;
import org.spongepowered.api.entity.ai.GoalType;
import org.spongepowered.api.entity.ai.task.AITask;
import org.spongepowered.api.entity.living.Agent;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.ai.AITaskEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.entity.EntityBridge;
import org.spongepowered.common.bridge.entity.ai.EntityAIBasesBridge;
import org.spongepowered.common.bridge.entity.ai.EntityAITasksBridge;
import org.spongepowered.common.event.ShouldFire;

@Mixin(value={EntityAITasks.class})
public abstract class EntityAITasksMixin
implements EntityAITasksBridge {
    @Shadow
    @Final
    private Set<EntityAITasks.EntityAITaskEntry> field_75782_a;
    @Shadow
    @Final
    private Set<EntityAITasks.EntityAITaskEntry> field_75780_b;
    @Nullable
    private EntityLiving owner;
    @Nullable
    private GoalType type;
    private boolean initialized;

    @Override
    public Set<EntityAITasks.EntityAITaskEntry> bridge$getTasksUnsafe() {
        return this.field_75782_a;
    }

    @Redirect(method={"addTask"}, at=@At(value="INVOKE", target="Ljava/util/Set;add(Ljava/lang/Object;)Z", remap=false))
    private boolean onAddEntityTask(Set<EntityAITasks.EntityAITaskEntry> set, Object entry, int priority, EntityAIBase base) {
        ((EntityAIBasesBridge)base).bridge$setGoal((Goal)((Object)this));
        if (!ShouldFire.A_I_TASK_EVENT_ADD || this.owner == null || ((EntityBridge)this.owner).bridge$isConstructing()) {
            EntityAITasks entityAITasks = (EntityAITasks)this;
            entityAITasks.getClass();
            return set.add(new EntityAITasks.EntityAITaskEntry(entityAITasks, priority, base));
        }
        AITaskEvent.Add event = SpongeEventFactory.createAITaskEventAdd(Sponge.getCauseStackManager().getCurrentCause(), priority, priority, (Goal)((Object)this), (Agent)this.owner, (AITask)base);
        SpongeImpl.postEvent(event);
        if (event.isCancelled()) {
            ((EntityAIBasesBridge)base).bridge$setGoal(null);
            return false;
        }
        EntityAITasks entityAITasks = (EntityAITasks)this;
        entityAITasks.getClass();
        return set.add(new EntityAITasks.EntityAITaskEntry(entityAITasks, event.getPriority(), base));
    }

    @Override
    public EntityLiving bridge$getOwner() {
        return this.owner;
    }

    @Override
    public void bridge$setOwner(EntityLiving owner) {
        this.owner = owner;
    }

    @Override
    public GoalType bridge$getType() {
        return this.type;
    }

    @Override
    public void bridge$setType(GoalType type) {
        this.type = type;
    }

    @Overwrite
    public void func_85156_a(EntityAIBase aiBase) {
        Iterator<EntityAITasks.EntityAITaskEntry> iterator = this.field_75782_a.iterator();
        while (iterator.hasNext()) {
            EntityAITasks.EntityAITaskEntry entityaitaskentry = iterator.next();
            EntityAIBase otherAiBase = entityaitaskentry.field_75733_a;
            if (!otherAiBase.equals(aiBase)) continue;
            Cancellable event = null;
            if (ShouldFire.A_I_TASK_EVENT_REMOVE && this.owner != null && !((EntityBridge)this.owner).bridge$isConstructing()) {
                event = SpongeEventFactory.createAITaskEventRemove(Sponge.getCauseStackManager().getCurrentCause(), (Goal)((Object)this), (Agent)this.owner, (AITask)otherAiBase, entityaitaskentry.field_75731_b);
                SpongeImpl.postEvent((Event)((Object)event));
            }
            if (event != null && event.isCancelled()) continue;
            if (entityaitaskentry.field_188524_c) {
                entityaitaskentry.field_188524_c = false;
                otherAiBase.func_75251_c();
                this.field_75780_b.remove(entityaitaskentry);
            }
            iterator.remove();
            return;
        }
    }

    @Overwrite
    private boolean func_75777_a(EntityAITasks.EntityAITaskEntry taskEntry1, EntityAITasks.EntityAITaskEntry taskEntry2) {
        return ((AITask)taskEntry2.field_75733_a).canRunConcurrentWith((AITask)taskEntry1.field_75733_a);
    }

    @Override
    public boolean bridge$initialized() {
        return this.initialized;
    }

    @Override
    public void bridge$setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).addValue(this.bridge$getOwner()).addValue(this.bridge$getType()).toString();
    }
}

