/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.item;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.world.World;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.projectile.Firework;
import org.spongepowered.api.entity.projectile.source.ProjectileSource;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.explosives.ExplosiveBridge;
import org.spongepowered.common.bridge.explosives.FusedExplosiveBridge;
import org.spongepowered.common.bridge.util.DamageSourceBridge;
import org.spongepowered.common.entity.projectile.ProjectileSourceSerializer;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.mixin.core.entity.EntityMixin;

@Mixin(value={EntityFireworkRocket.class})
public abstract class EntityFireworkRocketMixin
extends EntityMixin
implements FusedExplosiveBridge,
ExplosiveBridge {
    @Shadow
    private int field_92056_a;
    @Shadow
    private int field_92055_b;
    private ProjectileSource impl$projectileSource = ProjectileSource.UNKNOWN;
    private int impl$explosionRadius = 0;

    @Shadow
    public abstract void func_70071_h_();

    @Override
    public void spongeImpl$readFromSpongeCompound(NBTTagCompound compound) {
        super.spongeImpl$readFromSpongeCompound(compound);
        ProjectileSourceSerializer.readSourceFromNbt(compound, (Firework)((Object)this));
    }

    @Override
    public void spongeImpl$writeToSpongeCompound(NBTTagCompound compound) {
        super.spongeImpl$writeToSpongeCompound(compound);
        ProjectileSourceSerializer.writeSourceToNbt(compound, this.impl$projectileSource, null);
    }

    @Override
    public int bridge$getFuseDuration() {
        return this.field_92055_b;
    }

    @Override
    public void bridge$setFuseDuration(int fuseTicks) {
        this.field_92055_b = fuseTicks;
    }

    @Override
    public int bridge$getFuseTicksRemaining() {
        return this.field_92055_b - this.field_92056_a;
    }

    @Override
    public void bridge$setFuseTicksRemaining(int fuseTicks) {
        this.field_92056_a = 0;
        this.field_92055_b = fuseTicks;
    }

    @Override
    public Optional<Integer> bridge$getExplosionRadius() {
        return Optional.of(this.impl$explosionRadius);
    }

    @Override
    public void bridge$setExplosionRadius(@Nullable Integer radius) {
        this.impl$explosionRadius = radius == null ? 0 : radius;
    }

    @Redirect(method={"onUpdate"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;setEntityState(Lnet/minecraft/entity/Entity;B)V"))
    private void onExplode(World world, Entity self, byte state) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(this);
            frame.addContext(EventContextKeys.THROWER, ((Firework)((Object)this)).getShooter());
            frame.addContext(EventContextKeys.PROJECTILE_SOURCE, ((Firework)((Object)this)).getShooter());
            SpongeCommonEventFactory.detonateExplosive(this, Explosion.builder().sourceExplosive((Firework)((Object)this)).location(((Firework)((Object)this)).getLocation()).radius(this.impl$explosionRadius)).ifPresent(explosion -> world.func_72960_a(self, state));
        }
    }

    @Inject(method={"onUpdate"}, at={@At(value="RETURN")})
    private void onUpdate(CallbackInfo ci) {
        if (this.field_92056_a == 1 && !this.field_70170_p.field_72995_K) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.pushCause(this);
                frame.addContext(EventContextKeys.THROWER, ((Firework)((Object)this)).getShooter());
                frame.addContext(EventContextKeys.PROJECTILE_SOURCE, ((Firework)((Object)this)).getShooter());
                this.bridge$postPrime();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"dealExplosionDamage"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/EntityLivingBase;attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z"))
    private boolean useEntitySource(EntityLivingBase entityLivingBase, DamageSource source, float amount) {
        try {
            DamageSource fireworks = new EntityDamageSource(DamageSource.field_191552_t.field_76373_n, (Entity)this).func_94540_d();
            ((DamageSourceBridge)fireworks).bridge$setFireworksSource();
            boolean bl2 = entityLivingBase.func_70097_a(DamageSource.field_191552_t, amount);
            return bl2;
        }
        finally {
            ((DamageSourceBridge)source).bridge$setFireworksSource();
        }
    }
}

