/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.monster;

import com.flowpowered.math.vector.Vector3d;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.spongepowered.api.entity.living.monster.Creeper;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.entity.GrieferBridge;
import org.spongepowered.common.bridge.explosives.ExplosiveBridge;
import org.spongepowered.common.bridge.explosives.FusedExplosiveBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.mixin.core.entity.monster.EntityMobMixin;

@Mixin(value={EntityCreeper.class})
public abstract class EntityCreeperMixin
extends EntityMobMixin
implements FusedExplosiveBridge,
ExplosiveBridge {
    @Shadow
    private int field_70833_d;
    @Shadow
    private int field_82225_f;
    @Shadow
    private int field_82226_g;
    private int fuseDuration = 30;
    private boolean interactPrimeCancelled;
    private boolean stateDirty;
    private boolean detonationCancelled;

    @Shadow
    public abstract void func_146079_cb();

    @Shadow
    public abstract int func_70832_p();

    @Shadow
    public abstract void func_70829_a(int var1);

    @Shadow
    private void func_146077_cc() {
    }

    @Override
    public Optional<Integer> bridge$getExplosionRadius() {
        return Optional.of(this.field_82226_g);
    }

    @Override
    public void bridge$setExplosionRadius(@Nullable Integer radius) {
        this.field_82226_g = radius == null ? 3 : radius;
    }

    @Override
    public int bridge$getFuseDuration() {
        return this.fuseDuration;
    }

    @Override
    public void bridge$setFuseDuration(int fuseTicks) {
        this.fuseDuration = fuseTicks;
    }

    @Override
    public int bridge$getFuseTicksRemaining() {
        return this.field_82225_f - this.field_70833_d;
    }

    @Override
    public void bridge$setFuseTicksRemaining(int fuseTicks) {
        this.field_70833_d = 0;
        this.field_82225_f = fuseTicks;
    }

    @Inject(method={"setCreeperState(I)V"}, at={@At(value="INVOKE")}, cancellable=true)
    private void onStateChange(int state, CallbackInfo ci) {
        this.bridge$setFuseDuration(this.fuseDuration);
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (!((Creeper)((Object)this)).isPrimed() && state == 1 && !this.bridge$shouldPrime()) {
            ci.cancel();
        } else if (((Creeper)((Object)this)).isPrimed() && state == -1 && !this.bridge$shouldDefuse()) {
            ci.cancel();
        } else if (this.func_70832_p() != state) {
            this.stateDirty = true;
        }
    }

    @Inject(method={"setCreeperState(I)V"}, at={@At(value="RETURN")})
    private void postStateChange(int state, CallbackInfo ci) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.stateDirty) {
            if (state == 1) {
                this.bridge$postPrime();
            } else if (state == -1) {
                this.bridge$postDefuse();
            }
            this.stateDirty = false;
        }
    }

    @Redirect(method={"explode"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;createExplosion(Lnet/minecraft/entity/Entity;DDDFZ)Lnet/minecraft/world/Explosion;"))
    @Nullable
    private net.minecraft.world.Explosion onExplode(World world, Entity self, double x, double y, double z, float strength, boolean smoking) {
        return SpongeCommonEventFactory.detonateExplosive(this, Explosion.builder().location(new Location<org.spongepowered.api.world.World>((org.spongepowered.api.world.World)world, new Vector3d(x, y, z))).sourceExplosive((Creeper)((Object)this)).radius(strength).shouldPlaySmoke(smoking).shouldBreakBlocks(smoking && ((GrieferBridge)((Object)this)).bridge$CanGrief())).orElseGet(() -> {
            this.detonationCancelled = true;
            return null;
        });
    }

    @Inject(method={"explode"}, at={@At(value="RETURN")})
    private void postExplode(CallbackInfo ci) {
        if (this.detonationCancelled) {
            this.field_70128_L = false;
            this.detonationCancelled = false;
        }
    }

    @Redirect(method={"processInteract"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/monster/EntityCreeper;ignite()V"))
    private void onInteractIgnite(EntityCreeper self) {
        boolean bl2 = this.interactPrimeCancelled = !this.bridge$shouldPrime();
        if (!this.interactPrimeCancelled) {
            this.func_146079_cb();
        }
    }

    @Redirect(method={"processInteract"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;damageItem(ILnet/minecraft/entity/EntityLivingBase;)V"))
    private void onDamageFlintAndSteel(ItemStack fas, int amount, EntityLivingBase player) {
        if (!this.interactPrimeCancelled) {
            fas.func_77972_a(amount, player);
        }
        this.interactPrimeCancelled = false;
    }
}

