/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.player;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketClientSettings;
import net.minecraft.network.play.server.SPacketAnimation;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.network.play.server.SPacketCombatEvent;
import net.minecraft.network.play.server.SPacketEntityProperties;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.network.play.server.SPacketSpawnPosition;
import net.minecraft.network.play.server.SPacketUpdateHealth;
import net.minecraft.scoreboard.IScoreCriteria;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.data.type.SkinPart;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.entity.DestructEntityEvent;
import org.spongepowered.api.event.entity.living.humanoid.ChangeGameModeEvent;
import org.spongepowered.api.event.entity.living.humanoid.player.KickPlayerEvent;
import org.spongepowered.api.event.entity.living.humanoid.player.PlayerChangeClientSettingsEvent;
import org.spongepowered.api.event.message.MessageEvent;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.entity.Hotbar;
import org.spongepowered.api.item.inventory.property.SlotIndex;
import org.spongepowered.api.item.inventory.query.QueryOperationTypes;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.chat.ChatVisibility;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.command.CommandSenderBridge;
import org.spongepowered.common.bridge.command.CommandSourceBridge;
import org.spongepowered.common.bridge.data.DataCompoundHolder;
import org.spongepowered.common.bridge.entity.player.EntityPlayerBridge;
import org.spongepowered.common.bridge.entity.player.EntityPlayerMPBridge;
import org.spongepowered.common.bridge.inventory.ContainerBridge;
import org.spongepowered.common.bridge.inventory.TrackedInventoryBridge;
import org.spongepowered.common.bridge.network.NetHandlerPlayServerBridge;
import org.spongepowered.common.bridge.permissions.SubjectBridge;
import org.spongepowered.common.bridge.scoreboard.ScorePlayerTeamBridge;
import org.spongepowered.common.bridge.scoreboard.ServerScoreboardBridge;
import org.spongepowered.common.data.type.SpongeSkinPart;
import org.spongepowered.common.entity.living.human.EntityHuman;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.entity.BasicEntityContext;
import org.spongepowered.common.event.tracking.phase.entity.EntityDeathContext;
import org.spongepowered.common.event.tracking.phase.entity.EntityPhase;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.entity.player.EntityPlayerMixin;
import org.spongepowered.common.mixin.core.network.play.client.CPacketClientSettingsAccessor;
import org.spongepowered.common.mixin.core.network.play.server.SPacketBlockChangeAccessor;
import org.spongepowered.common.registry.type.entity.SkinPartRegistryModule;
import org.spongepowered.common.service.user.SpongeUserStorageService;
import org.spongepowered.common.text.SpongeTexts;
import org.spongepowered.common.text.chat.ChatUtil;
import org.spongepowered.common.util.LocaleCache;
import org.spongepowered.common.util.NetworkUtil;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.border.PlayerOwnBorderListener;

@Mixin(value={EntityPlayerMP.class})
public abstract class EntityPlayerMPMixin
extends EntityPlayerMixin
implements SubjectBridge,
EntityPlayerMPBridge,
CommandSenderBridge,
CommandSourceBridge {
    @Shadow
    @Final
    public MinecraftServer field_71133_b;
    @Shadow
    @Final
    public PlayerInteractionManager field_71134_c;
    @Shadow
    public NetHandlerPlayServer field_71135_a;
    @Shadow
    private int field_71144_ck;
    @Shadow
    private float field_71149_ch;
    @Shadow
    private int field_71146_ci;
    @Shadow
    public boolean field_71137_h;
    private ItemStack impl$packetItem = ItemStack.field_190927_a;
    private final User impl$user = this.impl$getUserObjectOnConstruction();
    private ImmutableSet<SkinPart> impl$skinParts = ImmutableSet.of();
    private int impl$viewDistance;
    @Nullable
    private GameType impl$pendingGameType;
    private Scoreboard impl$spongeScoreboard = Sponge.getGame().getServer().getServerScoreboard().get();
    @Nullable
    private EntityPlayerMP impl$delegate;
    @Nullable
    private Vector3d impl$velocityOverride = null;
    private double impl$healthScale = 20.0;
    private float impl$cachedModifiedHealth = -1.0f;
    private final PlayerOwnBorderListener impl$borderListener = new PlayerOwnBorderListener((EntityPlayerMP)this);
    @Nullable
    private Boolean impl$keepInventory = null;
    @Nullable
    private Text impl$displayName = null;

    @Shadow
    public abstract WorldServer func_71121_q();

    @Override
    public void spongeImpl$writeToSpongeCompound(NBTTagCompound compound) {
        super.spongeImpl$writeToSpongeCompound(compound);
        if (this.bridge$isHealthScaled()) {
            compound.func_74780_a("HealthScale", this.impl$healthScale);
        }
    }

    @Override
    public void spongeImpl$readFromSpongeCompound(NBTTagCompound compound) {
        super.spongeImpl$readFromSpongeCompound(compound);
        if (compound.func_150297_b("HealthScale", 6)) {
            this.impl$healthScale = compound.func_74769_h("HealthScale");
        }
    }

    @Inject(method={"removeEntity"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/NetHandlerPlayServer;sendPacket(Lnet/minecraft/network/Packet;)V")})
    private void impl$removeHumanHook(Entity entityIn, CallbackInfo ci) {
        if (entityIn instanceof EntityHuman) {
            ((EntityHuman)entityIn).onRemovedFrom((EntityPlayerMP)this);
        }
    }

    @Override
    public boolean bridge$keepInventory() {
        if (this.impl$keepInventory == null) {
            return this.field_70170_p.func_82736_K().func_82766_b("keepInventory");
        }
        return this.impl$keepInventory;
    }

    @Override
    @Overwrite
    public void func_70645_a(DamageSource cause) {
        boolean isMainThread = Sponge.isServerAvailable() && Sponge.getServer().isMainThread();
        Optional<DestructEntityEvent.Death> optEvent = SpongeCommonEventFactory.callDestructEntityEventDeath((EntityLivingBase)((EntityPlayerMP)this), cause, isMainThread);
        if (optEvent.map(Cancellable::isCancelled).orElse(true).booleanValue()) {
            return;
        }
        DestructEntityEvent.Death event = optEvent.get();
        boolean tracksEntityDeaths = isMainThread && !this.field_70170_p.field_72995_K ? PhaseTracker.getInstance().getCurrentState().tracksEntityDeaths() : false;
        try (PhaseContext<?> context = this.impl$createDeathContext(cause, tracksEntityDeaths);){
            if (context != null) {
                context.buildAndSwitch();
            }
            boolean flag = this.field_70170_p.func_82736_K().func_82766_b("showDeathMessages");
            this.field_71135_a.func_147359_a((Packet)new SPacketCombatEvent(this.func_110142_aN(), SPacketCombatEvent.Event.ENTITY_DIED, flag));
            if (flag) {
                Team team = this.func_96124_cp();
                if (team != null && team.func_178771_j() != Team.EnumVisible.ALWAYS) {
                    if (team.func_178771_j() == Team.EnumVisible.HIDE_FOR_OTHER_TEAMS) {
                        this.field_71133_b.func_184103_al().func_177453_a((EntityPlayer)((EntityPlayerMP)this), this.func_110142_aN().func_151521_b());
                    } else if (team.func_178771_j() == Team.EnumVisible.HIDE_FOR_OWN_TEAM) {
                        this.field_71133_b.func_184103_al().func_177452_b((EntityPlayer)((EntityPlayerMP)this), this.func_110142_aN().func_151521_b());
                    }
                } else {
                    this.field_71133_b.func_184103_al().func_148539_a(this.func_110142_aN().func_151521_b());
                }
            }
            this.func_192030_dh();
            if (!event.getKeepInventory() && !this.func_175149_v()) {
                this.func_190776_cN();
                this.field_71071_by.func_70436_m();
            }
            for (ScoreObjective scoreobjective : this.func_96123_co().func_96520_a(IScoreCriteria.field_96642_c)) {
                Score score = this.func_96123_co().func_96529_a(this.shadow$func_70005_c_(), scoreobjective);
                score.func_96648_a();
            }
            EntityLivingBase entitylivingbase = this.func_94060_bK();
            if (entitylivingbase != null) {
                EntityList.EntityEggInfo entitylist$entityegginfo = (EntityList.EntityEggInfo)EntityList.field_75627_a.get(EntityList.func_191301_a((Entity)entitylivingbase));
                if (entitylist$entityegginfo != null) {
                    this.func_71029_a(entitylist$entityegginfo.field_151513_e);
                }
                entitylivingbase.func_191956_a((Entity)((EntityPlayerMP)this), this.field_70744_aE, cause);
            }
            this.func_71029_a(StatList.field_188069_A);
            this.func_175145_a(StatList.field_188098_h);
            this.func_70066_B();
            this.func_70052_a(0, false);
            this.func_110142_aN().func_94549_h();
            this.impl$keepInventory = event.getKeepInventory();
        }
    }

    @Nullable
    private PhaseContext<?> impl$createDeathContext(DamageSource cause, boolean tracksEntityDeaths) {
        return !tracksEntityDeaths ? (PhaseContext<?>)((EntityDeathContext)EntityPhase.State.DEATH.createPhaseContext().source(this)).setDamageSource((org.spongepowered.api.event.cause.entity.damage.source.DamageSource)cause) : null;
    }

    @Inject(method={"copyFrom"}, at={@At(value="HEAD")})
    private void impl$copySpongeDataOnRespawn(EntityPlayerMP oldPlayer, boolean respawnFromEnd, CallbackInfo ci) {
        if (!(oldPlayer instanceof DataCompoundHolder)) {
            return;
        }
        DataCompoundHolder oldEntity = (DataCompoundHolder)oldPlayer;
        if (oldEntity.data$hasSpongeCompound()) {
            ((DataCompoundHolder)((Object)this)).data$getRootCompound().func_74782_a("SpongeData", (NBTBase)oldEntity.data$getSpongeCompound());
            this.spongeImpl$readFromSpongeCompound(((DataCompoundHolder)((Object)this)).data$getSpongeCompound());
        }
    }

    @Redirect(method={"copyFrom"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/GameRules;getBoolean(Ljava/lang/String;)Z"))
    private boolean impl$useKeepFromBridge(GameRules gameRules, String key, EntityPlayerMP corpse, boolean keepEverything) {
        boolean keep = ((EntityPlayerBridge)corpse).bridge$keepInventory();
        if (!keep) {
            this.field_71071_by.func_70455_b(corpse.field_71071_by);
            corpse.field_71071_by.func_174888_l();
        }
        return keep;
    }

    @Override
    @Overwrite
    public void func_70999_a(boolean immediately, boolean updateWorldFlag, boolean setSpawn) {
        try (BasicEntityContext basicEntityContext = (BasicEntityContext)EntityPhase.State.PLAYER_WAKE_UP.createPhaseContext().source(this);){
            basicEntityContext.buildAndSwitch();
            if (this.func_70608_bn()) {
                this.func_71121_q().func_73039_n().func_151248_b((Entity)this, (Packet)new SPacketAnimation((Entity)this, 2));
            }
            super.func_70999_a(immediately, updateWorldFlag, setSpawn);
            if (this.field_71135_a != null) {
                this.field_71135_a.func_147364_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            }
        }
    }

    @Override
    public Optional<User> bridge$getBackingUser() {
        return Optional.of(this.impl$user);
    }

    @Override
    public User bridge$getUserObject() {
        UserStorageService service = SpongeImpl.getGame().getServiceManager().provideUnchecked(UserStorageService.class);
        if (this.isFake) {
            return service.getOrCreate(SpongeUserStorageService.FAKEPLAYER_PROFILE);
        }
        return service.getOrCreate((GameProfile)((Object)this.func_146103_bH()));
    }

    private User impl$getUserObjectOnConstruction() {
        UserStorageService service = SpongeImpl.getGame().getServiceManager().provideUnchecked(UserStorageService.class);
        if (this.isFake || !(service instanceof SpongeUserStorageService)) {
            return this.bridge$getUserObject();
        }
        return ((SpongeUserStorageService)service).forceRecreateUser((GameProfile)((Object)this.func_146103_bH()));
    }

    @Override
    public User bridge$getUser() {
        return this.impl$user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"handleClientSettings"}, at={@At(value="HEAD")})
    private void impl$throwClientSettingsEvent(CPacketClientSettings packet, CallbackInfo ci) {
        if (ShouldFire.PLAYER_CHANGE_CLIENT_SETTINGS_EVENT) {
            CauseStackManager csm = Sponge.getCauseStackManager();
            csm.pushCause(this);
            try {
                Cause cause = csm.getCurrentCause();
                ImmutableSet skinParts = SkinPartRegistryModule.getInstance().getAll().stream().map(part -> (SpongeSkinPart)part).filter(part -> part.test(packet.func_149521_d())).collect(ImmutableSet.toImmutableSet());
                Locale locale = LocaleCache.getLocale(packet.func_149524_c());
                ChatVisibility visibility = (ChatVisibility)packet.func_149523_e();
                PlayerChangeClientSettingsEvent event = SpongeEventFactory.createPlayerChangeClientSettingsEvent(cause, visibility, skinParts, locale, (Player)((Object)this), packet.func_149520_f(), ((CPacketClientSettingsAccessor)packet).accessor$getView());
                SpongeImpl.postEvent(event);
            }
            finally {
                csm.popCause();
            }
        }
    }

    @Inject(method={"handleClientSettings"}, at={@At(value="RETURN")})
    private void impl$updateSkinFromPacket(CPacketClientSettings packet, CallbackInfo ci) {
        this.impl$skinParts = SkinPartRegistryModule.getInstance().getAll().stream().map(part -> (SpongeSkinPart)part).filter(part -> part.test(packet.func_149521_d())).collect(ImmutableSet.toImmutableSet());
        this.impl$viewDistance = ((CPacketClientSettingsAccessor)packet).accessor$getView();
    }

    @Overwrite
    public void func_145747_a(ITextComponent component) {
        if (this.isFake) {
            return;
        }
        ChatUtil.sendMessage(component, MessageChannel.fixed((Player)((Object)this)), (CommandSource)((Object)this.field_71133_b), false);
    }

    @Overwrite
    public String func_71114_r() {
        return NetworkUtil.getHostString(this.field_71135_a.field_147371_a.func_74430_c());
    }

    @Override
    public String bridge$getSubjectCollectionIdentifier() {
        return ((SubjectBridge)((Object)this.impl$user)).bridge$getSubjectCollectionIdentifier();
    }

    @Override
    public String bridge$getIdentifier() {
        return this.impl$user.getIdentifier();
    }

    @Override
    public Tristate bridge$permDefault(String permission) {
        return ((SubjectBridge)((Object)this.impl$user)).bridge$permDefault(permission);
    }

    @Override
    public void bridge$setPacketItem(ItemStack itemstack) {
        this.impl$packetItem = itemstack;
    }

    @Override
    public void bridge$refreshExp() {
        this.field_71144_ck = -1;
    }

    @Override
    public void bridge$restorePacketItem(EnumHand hand) {
        if (this.impl$packetItem.func_190926_b()) {
            return;
        }
        this.field_71137_h = true;
        this.func_184611_a(hand, this.impl$packetItem);
        net.minecraft.inventory.Slot slot = this.field_71070_bA.func_75147_a((IInventory)this.field_71071_by, this.field_71071_by.field_70461_c);
        this.field_71070_bA.func_75142_b();
        this.field_71137_h = false;
        if (slot != null) {
            this.field_71135_a.func_147359_a((Packet)new SPacketSetSlot(this.field_71070_bA.field_75152_c, slot.field_75222_d, this.impl$packetItem));
        }
    }

    @Override
    public void bridge$initScoreboard() {
        ((ServerScoreboardBridge)this.func_96123_co()).bridge$addPlayer((EntityPlayerMP)this, true);
    }

    @Override
    public Scoreboard bridge$getScoreboard() {
        return this.impl$spongeScoreboard;
    }

    @Override
    public void bridge$replaceScoreboard(@Nullable Scoreboard scoreboard) {
        if (scoreboard == null) {
            scoreboard = Sponge.getGame().getServer().getServerScoreboard().orElseThrow(() -> new IllegalStateException("Server does not have a valid scoreboard"));
        }
        this.impl$spongeScoreboard = scoreboard;
    }

    @Override
    public void bridge$setScoreboardOnRespawn(Scoreboard scoreboard) {
        this.impl$spongeScoreboard = scoreboard;
        ((ServerScoreboardBridge)((Object)((Player)((Object)this)).getScoreboard())).bridge$addPlayer((EntityPlayerMP)this, false);
    }

    @Override
    public void bridge$removeScoreboardOnRespawn() {
        ((ServerScoreboardBridge)((Object)((Player)((Object)this)).getScoreboard())).bridge$removePlayer((EntityPlayerMP)this, false);
    }

    @Override
    public MessageChannel bridge$getDeathMessageChannel() {
        EntityPlayerMP player = (EntityPlayerMP)this;
        if (player.field_70170_p.func_82736_K().func_82766_b("showDeathMessages")) {
            Team team = player.func_96124_cp();
            if (team != null && team.func_178771_j() != Team.EnumVisible.ALWAYS) {
                if (team.func_178771_j() == Team.EnumVisible.HIDE_FOR_OTHER_TEAMS) {
                    return ((ScorePlayerTeamBridge)team).bridge$getTeamChannel(player);
                }
                if (team.func_178771_j() == Team.EnumVisible.HIDE_FOR_OWN_TEAM) {
                    return ((ScorePlayerTeamBridge)team).bridge$getNonTeamChannel();
                }
            } else {
                return ((Player)((Object)this)).getMessageChannel();
            }
        }
        return MessageChannel.TO_NONE;
    }

    @Override
    public net.minecraft.scoreboard.Scoreboard func_96123_co() {
        return (net.minecraft.scoreboard.Scoreboard)((Player)((Object)this)).getScoreboard();
    }

    @Inject(method={"markPlayerActive()V"}, at={@At(value="HEAD")})
    private void onPlayerActive(CallbackInfo ci) {
        ((NetHandlerPlayServerBridge)this.field_71135_a).bridge$resendLatestResourcePackRequest();
    }

    @Override
    public CommandSource bridge$asCommandSource() {
        return (CommandSource)((Object)this);
    }

    @Override
    public ICommandSender bridge$asICommandSender() {
        return (ICommandSender)this;
    }

    @Override
    public void bridge$setImplVelocity(Vector3d velocity) {
        super.bridge$setImplVelocity(velocity);
        this.impl$velocityOverride = null;
    }

    @Override
    public void bridge$setVelocityOverride(@Nullable Vector3d velocity) {
        this.impl$velocityOverride = velocity;
    }

    @Override
    @Nullable
    public Vector3d bridge$getVelocityOverride() {
        return this.impl$velocityOverride;
    }

    @Override
    public Set<SkinPart> bridge$getSkinParts() {
        return this.impl$skinParts;
    }

    @Override
    public boolean bridge$hasDelegate() {
        return this.impl$delegate != null;
    }

    @Override
    @Nullable
    public EntityPlayerMP bridge$getDelegate() {
        return this.impl$delegate;
    }

    @Inject(method={"setGameType(Lnet/minecraft/world/GameType;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void spongeImpl$onSetGameTypeThrowEvent(GameType gameType, CallbackInfo ci) {
        if (ShouldFire.CHANGE_GAME_MODE_EVENT_TARGET_PLAYER) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.pushCause(this);
                ChangeGameModeEvent.TargetPlayer event = SpongeEventFactory.createChangeGameModeEventTargetPlayer(frame.getCurrentCause(), (GameMode)this.field_71134_c.func_73081_b(), (GameMode)gameType, (Player)((Object)this));
                SpongeImpl.postEvent(event);
                if (event.isCancelled()) {
                    ci.cancel();
                }
                this.impl$pendingGameType = (GameType)event.getGameMode();
            }
        } else {
            this.impl$pendingGameType = gameType;
        }
    }

    @ModifyVariable(method={"setGameType(Lnet/minecraft/world/GameType;)V"}, at=@At(value="HEAD", remap=false), argsOnly=true)
    private GameType spongeImpl$assignPendingGameType(GameType gameType) {
        return this.impl$pendingGameType;
    }

    @Redirect(method={"onDeath"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/GameRules;getBoolean(Ljava/lang/String;)Z", ordinal=0))
    private boolean spongeImpl$SuppressDeathMessageDueToPriorEvent(GameRules gameRules, String gameRule) {
        return false;
    }

    @Override
    public void bridge$setTargetedLocation(@Nullable Vector3d vec) {
        super.bridge$setTargetedLocation(vec);
        this.field_71135_a.func_147359_a((Packet)new SPacketSpawnPosition(VecHelper.toBlockPos(this.bridge$getTargetedLocation())));
    }

    @Override
    @Nullable
    public Text bridge$getDisplayNameText() {
        return Text.of(this.shadow$func_70005_c_());
    }

    @Override
    public void bridge$setDisplayName(@Nullable Text displayName) {
    }

    @Override
    public void bridge$sendBlockChange(BlockPos pos, IBlockState state) {
        SPacketBlockChange packet = new SPacketBlockChange();
        ((SPacketBlockChangeAccessor)packet).accessor$setBlockPosition(pos);
        ((SPacketBlockChangeAccessor)packet).accessor$setBlockState(state);
        this.field_71135_a.func_147359_a((Packet)packet);
    }

    @Override
    @Nullable
    public EntityItem func_71040_bB(boolean dropAll) {
        ItemStack currentItem = this.field_71071_by.func_70448_g();
        if (currentItem.func_190926_b()) {
            return null;
        }
        Slot slot = (Slot)((Inventory)this.field_71069_bz).query(QueryOperationTypes.INVENTORY_TYPE.of(Hotbar.class)).query(QueryOperationTypes.INVENTORY_PROPERTY.of(SlotIndex.of(this.field_71071_by.field_70461_c)));
        ItemStackSnapshot originalItem = ItemStackUtil.snapshotOf(currentItem);
        int count = dropAll && !currentItem.func_190926_b() ? currentItem.func_190916_E() : 1;
        ItemStack itemToDrop = this.field_71071_by.func_70298_a(this.field_71071_by.field_70461_c, count);
        SlotTransaction transaction = new SlotTransaction(slot, originalItem, ItemStackUtil.snapshotOf(this.field_71071_by.func_70448_g()));
        ((TrackedInventoryBridge)this.field_71069_bz).bridge$getCapturedSlotTransactions().add(transaction);
        return this.func_146097_a(itemToDrop, false, true);
    }

    @Override
    public void func_184597_cx() {
        if (this.field_184627_bm.func_190926_b()) {
            ((EntityPlayerMP)this).func_71120_a(((EntityPlayerMP)this).field_71069_bz);
        }
        super.func_184597_cx();
    }

    @Inject(method={"closeContainer"}, at={@At(value="RETURN")})
    private void onCloseContainer(CallbackInfo ci) {
        TrackedInventoryBridge mixinContainer = (TrackedInventoryBridge)this.field_71070_bA;
        if (mixinContainer.bridge$capturingInventory()) {
            mixinContainer.bridge$setCaptureInventory(false);
            mixinContainer.bridge$getCapturedSlotTransactions().clear();
        }
    }

    @Inject(method={"displayGUIChest"}, at={@At(value="FIELD", target="Lnet/minecraft/entity/player/EntityPlayerMP;openContainer:Lnet/minecraft/inventory/Container;", opcode=181, ordinal=1, shift=At.Shift.AFTER)})
    private void onSetContainer(IInventory chestInventory, CallbackInfo ci) {
        if (!(chestInventory instanceof IInteractionObject) && this.field_71070_bA instanceof ContainerChest && this.func_175149_v()) {
            SpongeImpl.getLogger().warn("Opening fallback ContainerChest for inventory '{}'. Most API inventory methods will not be supported", (Object)chestInventory);
            ((ContainerBridge)this.field_71070_bA).bridge$setSpectatorChest(true);
        }
    }

    @Override
    public PlayerOwnBorderListener bridge$getWorldBorderListener() {
        return this.impl$borderListener;
    }

    @Inject(method={"sendSlotContents"}, at={@At(value="HEAD")})
    private void sendSlotContents(Container containerToSend, int slotInd, ItemStack stack, CallbackInfo ci) {
        if (containerToSend.func_75139_a(slotInd) instanceof SlotCrafting) {
            this.field_71135_a.func_147359_a((Packet)new SPacketSetSlot(containerToSend.field_75152_c, slotInd, stack));
        }
    }

    @Redirect(method={"onUpdateEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/EntityPlayerMP;getHealth()F"), slice=@Slice(from=@At(value="FIELD", target="Lnet/minecraft/entity/player/EntityPlayerMP;lastHealth:F"), to=@At(value="INVOKE", target="Lnet/minecraft/network/play/server/SPacketUpdateHealth;<init>(FIF)V")))
    private float spongeGetScaledHealthForPacket(EntityPlayerMP entityPlayerMP) {
        return this.bridge$getInternalScaledHealth();
    }

    @Inject(method={"onUpdateEntity"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/EntityPlayerMP;getTotalArmorValue()I", ordinal=1)})
    private void updateHealthPriorToArmor(CallbackInfo ci) {
        this.bridge$refreshScaledHealth();
    }

    @Override
    public void bridge$setHealthScale(double scale) {
        Preconditions.checkArgument(scale > 0.0, "Health scale must be greater than 0!");
        Preconditions.checkArgument(scale < 3.4028234663852886E38, "Health scale cannot exceed Float.MAX_VALUE!");
        this.impl$healthScale = scale;
        this.impl$cachedModifiedHealth = -1.0f;
        this.field_71149_ch = -1.0f;
        if (scale != 20.0) {
            NBTTagCompound spongeData = ((DataCompoundHolder)((Object)this)).data$getSpongeCompound();
            spongeData.func_74780_a("HealthScale", scale);
        } else if (((DataCompoundHolder)((Object)this)).data$hasSpongeCompound()) {
            ((DataCompoundHolder)((Object)this)).data$getSpongeCompound().func_82580_o("HealthScale");
        }
        this.bridge$refreshScaledHealth();
    }

    @Override
    public void bridge$refreshScaledHealth() {
        Set dirtyInstances = ((AttributeMap)this.func_110140_aT()).func_111161_b();
        this.bridge$injectScaledHealth(dirtyInstances);
        this.field_71135_a.func_147359_a((Packet)new SPacketUpdateHealth(this.bridge$getInternalScaledHealth(), this.func_71024_bL().func_75116_a(), this.func_71024_bL().func_75115_e()));
        this.field_71135_a.func_147359_a((Packet)new SPacketEntityProperties(this.func_145782_y(), (Collection)dirtyInstances));
        dirtyInstances.clear();
    }

    @Override
    public void bridge$injectScaledHealth(Collection<IAttributeInstance> set) {
        Collection modifiers = null;
        boolean foundMax = false;
        Iterator<IAttributeInstance> iter = set.iterator();
        while (iter.hasNext()) {
            IAttributeInstance dirtyInstance = iter.next();
            if (!"generic.maxHealth".equals(dirtyInstance.func_111123_a().func_111108_a())) continue;
            foundMax = true;
            modifiers = dirtyInstance.func_111122_c();
            iter.remove();
            break;
        }
        if (!foundMax) {
            modifiers = this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111122_c();
        }
        double defaultt = this.bridge$isHealthScaled() ? this.impl$healthScale : this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b();
        RangedAttribute maxHealth = new RangedAttribute(null, "generic.maxHealth", defaultt, 0.0, 3.4028234663852886E38);
        maxHealth.func_111117_a("Max Health");
        maxHealth.func_111112_a(true);
        ModifiableAttributeInstance attribute = new ModifiableAttributeInstance(this.func_110140_aT(), (IAttribute)maxHealth);
        if (!modifiers.isEmpty()) {
            modifiers.forEach(arg_0 -> ((ModifiableAttributeInstance)attribute).func_111121_a(arg_0));
        }
        set.add((IAttributeInstance)attribute);
    }

    @Override
    public double bridge$getHealthScale() {
        return this.impl$healthScale;
    }

    @Override
    public float bridge$getInternalScaledHealth() {
        if (!this.bridge$isHealthScaled()) {
            return this.func_110143_aJ();
        }
        if (this.impl$cachedModifiedHealth == -1.0f) {
            IAttributeInstance maxAttribute = this.func_110148_a(SharedMonsterAttributes.field_111267_a);
            double modifiedScale = this.impl$healthScale;
            for (AttributeModifier attributemodifier : maxAttribute.func_111130_a(0)) {
                modifiedScale += attributemodifier.func_111164_d();
            }
            for (AttributeModifier attributemodifier1 : maxAttribute.func_111130_a(1)) {
                modifiedScale += modifiedScale * attributemodifier1.func_111164_d();
            }
            for (AttributeModifier attributemodifier2 : maxAttribute.func_111130_a(2)) {
                modifiedScale *= 1.0 + attributemodifier2.func_111164_d();
            }
            this.impl$cachedModifiedHealth = (float)modifiedScale;
        }
        return this.func_110143_aJ() / this.func_110138_aP() * this.impl$cachedModifiedHealth;
    }

    @Override
    public boolean bridge$isHealthScaled() {
        return this.impl$healthScale != 20.0;
    }

    @Redirect(method={"readEntityFromNBT"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;getForceGamemode()Z"))
    private boolean onCheckForcedGameMode(MinecraftServer minecraftServer) {
        return minecraftServer.func_104056_am() && !this.bridge$hasForcedGamemodeOverridePermission();
    }

    @Override
    public boolean bridge$hasForcedGamemodeOverridePermission() {
        Player player = (Player)((Object)this);
        return player.hasPermission(player.getActiveContexts(), "minecraft.force-gamemode.override");
    }

    @Override
    public void bridge$setDelegateAfterRespawn(EntityPlayerMP delegate) {
        this.impl$delegate = delegate;
    }

    @Override
    public void bridge$setContainerDisplay(Text displayName) {
        this.impl$displayName = displayName;
    }

    @Redirect(method={"displayGUIChest"}, at=@At(value="INVOKE", target="Lnet/minecraft/inventory/IInventory;getDisplayName()Lnet/minecraft/util/text/ITextComponent;"))
    private ITextComponent impl$updateDisplayName(IInventory chestInventory) {
        if (this.impl$displayName == null) {
            return chestInventory.func_145748_c_();
        }
        return new TextComponentString(SpongeTexts.toLegacy(this.impl$displayName));
    }

    @Redirect(method={"displayGui"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/IInteractionObject;getDisplayName()Lnet/minecraft/util/text/ITextComponent;"))
    private ITextComponent impl$updateDisplayName(IInteractionObject guiOwner) {
        if (this.impl$displayName == null) {
            return guiOwner.func_145748_c_();
        }
        return new TextComponentString(SpongeTexts.toLegacy(this.impl$displayName));
    }

    @Redirect(method={"openGuiHorseInventory"}, at=@At(value="INVOKE", target="Lnet/minecraft/inventory/IInventory;getDisplayName()Lnet/minecraft/util/text/ITextComponent;"))
    private ITextComponent impl$updateDisplayNameForHorseInventory(IInventory inventoryIn) {
        if (this.impl$displayName == null) {
            return inventoryIn.func_145748_c_();
        }
        return new TextComponentString(SpongeTexts.toLegacy(this.impl$displayName));
    }

    @Redirect(method={"displayVillagerTradeGui"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/IMerchant;getDisplayName()Lnet/minecraft/util/text/ITextComponent;"))
    private ITextComponent impl$updateDisplayNameForVillagerTrading(IMerchant villager) {
        if (this.impl$displayName == null) {
            return villager.func_145748_c_();
        }
        return new TextComponentString(SpongeTexts.toLegacy(this.impl$displayName));
    }

    @Inject(method={"canAttackPlayer"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$useWorldBasedAttackRules(EntityPlayer other, CallbackInfoReturnable<Boolean> cir) {
        boolean worldPVP = ((WorldProperties)other.field_70170_p.func_72912_H()).isPVPEnabled();
        if (!worldPVP) {
            cir.setReturnValue(false);
            return;
        }
        boolean teamPVP = super.func_96122_a(other);
        cir.setReturnValue(teamPVP);
    }

    @Override
    public int bridge$getViewDistance() {
        return this.impl$viewDistance;
    }

    @Override
    public void bridge$kick(Text message) {
        Text messageToSend;
        if (ShouldFire.KICK_PLAYER_EVENT) {
            KickPlayerEvent kickPlayerEvent = SpongeEventFactory.createKickPlayerEvent(Sponge.getCauseStackManager().getCurrentCause(), MessageChannel.TO_NONE, Optional.empty(), new MessageEvent.MessageFormatter(message), (Player)((Object)this), false);
            Sponge.getEventManager().post(kickPlayerEvent);
            messageToSend = kickPlayerEvent.getMessage();
        } else {
            messageToSend = message;
        }
        ITextComponent component = SpongeTexts.toComponent(messageToSend);
        this.field_71135_a.func_194028_b(component);
    }
}

