/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.player;

import com.flowpowered.math.vector.Vector3d;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.player.PlayerCapabilities;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.FoodStats;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.GameState;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.ModifierFunction;
import org.spongepowered.api.event.cause.entity.damage.DamageFunction;
import org.spongepowered.api.event.cause.entity.damage.DamageModifier;
import org.spongepowered.api.event.cause.entity.damage.DamageModifierTypes;
import org.spongepowered.api.event.cause.entity.damage.DamageTypes;
import org.spongepowered.api.event.cause.entity.damage.source.EntityDamageSource;
import org.spongepowered.api.event.entity.AttackEntityEvent;
import org.spongepowered.api.event.entity.ChangeEntityExperienceEvent;
import org.spongepowered.api.event.entity.DestructEntityEvent;
import org.spongepowered.api.event.entity.living.humanoid.ChangeLevelEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.entity.PlayerInventory;
import org.spongepowered.api.item.inventory.property.SlotIndex;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.bridge.LocationTargetingBridge;
import org.spongepowered.common.bridge.entity.player.EntityPlayerBridge;
import org.spongepowered.common.bridge.inventory.TrackedInventoryBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.data.manipulator.immutable.entity.ImmutableSpongeExperienceHolderData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeExperienceHolderData;
import org.spongepowered.common.data.processor.common.ExperienceHolderUtils;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.damage.DamageEventHandler;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhase;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.entity.EntityLivingBaseMixin;
import org.spongepowered.common.registry.type.event.DamageSourceRegistryModule;
import org.spongepowered.common.text.serializer.LegacyTexts;
import org.spongepowered.common.util.VecHelper;

@Mixin(value={EntityPlayer.class})
public abstract class EntityPlayerMixin
extends EntityLivingBaseMixin
implements EntityPlayerBridge,
LocationTargetingBridge {
    @Shadow
    public Container field_71069_bz;
    @Shadow
    public Container field_71070_bA;
    @Shadow
    public int field_71068_ca;
    @Shadow
    public int field_71067_cb;
    @Shadow
    public float field_71106_cc;
    @Shadow
    public PlayerCapabilities field_71075_bZ;
    @Shadow
    public InventoryPlayer field_71071_by;
    @Shadow
    public BlockPos field_71081_bT;
    private boolean affectsSpawning = true;
    private Vector3d targetedLocation = VecHelper.toVector3d(this.field_70170_p.func_175694_M());
    private boolean dontRecalculateExperience;
    private boolean shouldRestoreInventory = false;
    protected final boolean isFake = SpongeImplHooks.isFakePlayer((net.minecraft.entity.Entity)((EntityPlayer)this));

    @Shadow
    public abstract boolean func_70608_bn();

    @Shadow
    public abstract boolean func_175149_v();

    @Shadow
    public abstract int func_71050_bK();

    @Shadow
    public abstract float func_184825_o(float var1);

    @Shadow
    public abstract float func_70689_ay();

    @Shadow
    public abstract void func_71009_b(net.minecraft.entity.Entity var1);

    @Shadow
    public abstract void func_71047_c(net.minecraft.entity.Entity var1);

    @Shadow
    public abstract void func_71020_j(float var1);

    @Shadow
    public abstract void func_71064_a(@Nullable StatBase var1, int var2);

    @Shadow
    public abstract void func_71029_a(StatBase var1);

    @Shadow
    public abstract void func_184821_cY();

    @Shadow
    public abstract void func_184810_cG();

    @Shadow
    public abstract void func_175145_a(StatBase var1);

    @Shadow
    protected abstract void func_190776_cN();

    @Shadow
    public void func_70999_a(boolean immediately, boolean updateWorldFlag, boolean setSpawn) {
    }

    @Shadow
    @Nullable
    public abstract EntityItem func_71040_bB(boolean var1);

    @Shadow
    public abstract FoodStats func_71024_bL();

    @Shadow
    public abstract GameProfile func_146103_bH();

    @Shadow
    public abstract Scoreboard func_96123_co();

    @Shadow
    public abstract String shadow$func_70005_c_();

    @Shadow
    @Nullable
    public abstract Team func_96124_cp();

    @Shadow
    public abstract void func_82242_a(int var1);

    @Shadow
    public abstract void func_85039_t(int var1);

    @Shadow
    protected abstract void func_192030_dh();

    @Shadow
    public abstract boolean func_184812_l_();

    @Shadow
    public boolean func_96122_a(EntityPlayer other) {
        return false;
    }

    @Inject(method={"getDisplayName"}, at={@At(value="RETURN")}, cancellable=true)
    private void impl$getDisplayNameWithParsing(CallbackInfoReturnable<ITextComponent> ci) {
        ci.setReturnValue((ITextComponent)LegacyTexts.parseComponent((TextComponentString)ci.getReturnValue(), '\u00a7'));
    }

    @Override
    public int bridge$getExperienceSinceLevel() {
        return this.field_71067_cb - ExperienceHolderUtils.xpAtLevel(this.field_71068_ca);
    }

    @Override
    public void bridge$setExperienceSinceLevel(int experience) {
        this.field_71067_cb = ExperienceHolderUtils.xpAtLevel(this.field_71068_ca) + experience;
        this.field_71106_cc = (float)experience / (float)this.func_71050_bK();
    }

    @Override
    public void bridge$recalculateTotalExperience() {
        if (!this.dontRecalculateExperience) {
            boolean isInaccurate;
            boolean bl2 = isInaccurate = ExperienceHolderUtils.getLevelForExp(this.field_71067_cb) != this.field_71068_ca;
            if (!isInaccurate) {
                float experienceLess = ((float)this.bridge$getExperienceSinceLevel() - 0.5f) / (float)this.func_71050_bK();
                float experienceMore = ((float)this.bridge$getExperienceSinceLevel() + 0.5f) / (float)this.func_71050_bK();
                boolean bl3 = isInaccurate = this.field_71106_cc < experienceLess || this.field_71106_cc > experienceMore;
            }
            if (isInaccurate) {
                int newExperienceInLevel = (int)(this.field_71106_cc * (float)this.func_71050_bK());
                this.field_71067_cb = ExperienceHolderUtils.xpAtLevel(this.field_71068_ca) + newExperienceInLevel;
                this.field_71106_cc = (float)newExperienceInLevel / (float)this.func_71050_bK();
            }
        }
    }

    @Inject(method={"addExperienceLevel"}, at={@At(value="HEAD")}, cancellable=true)
    private void onAddExperienceLevels(int levels, CallbackInfo ci) {
        if (((WorldBridge)this.field_70170_p).bridge$isFake()) {
            return;
        }
        if (!this.dontRecalculateExperience) {
            int newLevel = Math.max(this.field_71068_ca + levels, 0);
            this.postEventAndUpdateExperience(ExperienceHolderUtils.xpAtLevel(newLevel) + (int)(this.field_71106_cc * (float)ExperienceHolderUtils.getExpBetweenLevels(newLevel)));
            ci.cancel();
        }
    }

    @Inject(method={"onEnchant"}, at={@At(value="RETURN")})
    private void onEnchantChangeExperienceLevels(ItemStack item, int levels, CallbackInfo ci) {
        this.bridge$recalculateTotalExperience();
    }

    @Overwrite
    public void func_71023_q(int amount) {
        this.func_85039_t(amount);
        int i = Integer.MAX_VALUE - this.field_71067_cb;
        if (amount > i) {
            amount = i;
        }
        if (((WorldBridge)this.field_70170_p).bridge$isFake()) {
            this.field_71106_cc += (float)amount / (float)this.func_71050_bK();
            this.field_71067_cb += amount;
            while (this.field_71106_cc >= 1.0f) {
                this.field_71106_cc = (this.field_71106_cc - 1.0f) * (float)this.func_71050_bK();
                this.func_82242_a(1);
                this.field_71106_cc /= (float)this.func_71050_bK();
            }
        } else {
            this.postEventAndUpdateExperience(this.field_71067_cb + amount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postEventAndUpdateExperience(int finalExperience) {
        SpongeExperienceHolderData data = new SpongeExperienceHolderData();
        data.setTotalExp(finalExperience);
        ImmutableSpongeExperienceHolderData immutable = new ImmutableSpongeExperienceHolderData(this.field_71068_ca, this.field_71067_cb, this.bridge$getExperienceSinceLevel());
        ChangeEntityExperienceEvent event = SpongeEventFactory.createChangeEntityExperienceEvent(Sponge.getCauseStackManager().getCurrentCause(), immutable, data, (Entity)((Player)((Object)this)));
        SpongeImpl.postEvent(event);
        if (event.isCancelled()) {
            return;
        }
        int finalLevel = (Integer)event.getFinalData().level().get();
        if (finalLevel != this.field_71068_ca) {
            ChangeLevelEvent.TargetPlayer levelEvent = SpongeEventFactory.createChangeLevelEventTargetPlayer(Sponge.getCauseStackManager().getCurrentCause(), this.field_71068_ca, finalLevel, (Player)((Object)this));
            SpongeImpl.postEvent(levelEvent);
            if (levelEvent.isCancelled()) {
                return;
            }
            if (levelEvent.getLevel() != finalLevel) {
                finalLevel = levelEvent.getLevel();
                event.getFinalData().set(Keys.EXPERIENCE_LEVEL, finalLevel);
            }
            if (finalLevel != this.field_71068_ca) {
                this.dontRecalculateExperience = true;
                try {
                    this.func_82242_a(finalLevel - this.field_71068_ca);
                }
                finally {
                    this.dontRecalculateExperience = false;
                }
            }
        }
        this.field_71106_cc = (float)((Integer)event.getFinalData().experienceSinceLevel().get()).intValue() / (float)ExperienceHolderUtils.getExpBetweenLevels(finalLevel);
        this.field_71067_cb = (Integer)event.getFinalData().totalExperience().get();
        this.field_71068_ca = finalLevel;
    }

    @Inject(method={"readEntityFromNBT"}, at={@At(value="RETURN")})
    private void impl$fixEntityProperties(NBTTagCompound compound, CallbackInfo ci) {
        this.bridge$recalculateTotalExperience();
        if (this.func_110143_aJ() <= 0.0f) {
            this.field_70128_L = true;
        }
    }

    @Override
    @Overwrite
    public void func_70645_a(DamageSource cause) {
        boolean isMainThread = Sponge.isServerAvailable() && Sponge.getServer().isMainThread();
        Optional<DestructEntityEvent.Death> event = SpongeCommonEventFactory.callDestructEntityEventDeath((EntityLivingBase)((EntityPlayer)this), cause, isMainThread);
        if (event.map(Cancellable::isCancelled).orElse(true).booleanValue()) {
            return;
        }
        super.func_70645_a(cause);
        this.func_70105_a(0.2f, 0.2f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70181_x = 0.1f;
        if (this.shadow$func_70005_c_().equals("Notch")) {
            this.func_146097_a(new ItemStack(Items.field_151034_e, 1), true, false);
        }
        if (!this.field_70170_p.func_82736_K().func_82766_b("keepInventory") && !this.func_175149_v()) {
            this.func_190776_cN();
            this.field_71071_by.func_70436_m();
        }
        if (cause != null) {
            this.field_70159_w = -MathHelper.func_76134_b((float)((this.field_70739_aP + this.field_70177_z) * ((float)Math.PI / 180))) * 0.1f;
            this.field_70179_y = -MathHelper.func_76126_a((float)((this.field_70739_aP + this.field_70177_z) * ((float)Math.PI / 180))) * 0.1f;
        } else {
            this.field_70179_y = 0.0;
            this.field_70159_w = 0.0;
        }
        this.func_71029_a(StatList.field_188069_A);
        this.func_175145_a(StatList.field_188098_h);
        this.func_70066_B();
        this.func_70052_a(0, false);
    }

    @Redirect(method={"onLivingUpdate"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getEntitiesWithinAABBExcludingEntity(Lnet/minecraft/entity/Entity;Lnet/minecraft/util/math/AxisAlignedBB;)Ljava/util/List;"))
    private List<net.minecraft.entity.Entity> onSpongeGetEntitiesWithinAABBExcludingEntity(net.minecraft.world.World world, net.minecraft.entity.Entity entityIn, AxisAlignedBB bb) {
        if (this.bridge$isVanished() && this.bridge$isUncollideable()) {
            return Collections.emptyList();
        }
        return world.func_72839_b(entityIn, bb);
    }

    @Redirect(method={"onUpdate"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/EntityPlayer;isPlayerSleeping()Z"))
    private boolean onSpongeIsPlayerSleeping(EntityPlayer self) {
        if (self.func_70608_bn()) {
            if (!((WorldBridge)this.field_70170_p).bridge$isFake()) {
                CauseStackManager csm = Sponge.getCauseStackManager();
                csm.pushCause(this);
                BlockPos bedLocation = this.field_71081_bT;
                BlockSnapshot snapshot = ((World)this.field_70170_p).createSnapshot(bedLocation.func_177958_n(), bedLocation.func_177956_o(), bedLocation.func_177952_p());
                SpongeImpl.postEvent(SpongeEventFactory.createSleepingEventTick(csm.getCurrentCause(), snapshot, (Entity)((Object)this)));
                csm.popCause();
            }
            return true;
        }
        return false;
    }

    @Redirect(method={"playSound"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;playSound(Lnet/minecraft/entity/player/EntityPlayer;DDDLnet/minecraft/util/SoundEvent;Lnet/minecraft/util/SoundCategory;FF)V"))
    private void spongePlaySound(net.minecraft.world.World world, EntityPlayer player, double d1, double d2, double d3, SoundEvent sound, SoundCategory category, float volume, float pitch) {
        if (!this.bridge$isVanished()) {
            this.field_70170_p.func_184148_a(player, d1, d2, d3, sound, category, volume, pitch);
        }
    }

    @Override
    public boolean bridge$affectsSpawning() {
        return this.affectsSpawning && !this.func_175149_v() && !this.bridge$isUntargetable();
    }

    @Override
    public void bridge$setAffectsSpawning(boolean affectsSpawning) {
        this.affectsSpawning = affectsSpawning;
    }

    @Override
    public Vector3d bridge$getTargetedLocation() {
        return this.targetedLocation;
    }

    @Override
    public void bridge$setTargetedLocation(@Nullable Vector3d vec) {
        Vector3d vector3d = this.targetedLocation = vec != null ? vec : VecHelper.toVector3d(this.field_70170_p.func_175694_M());
        if (!((EntityPlayer)this instanceof EntityPlayerMP)) {
            this.field_70170_p.func_175652_B(VecHelper.toBlockPos(this.targetedLocation));
        }
    }

    @Redirect(method={"canPlayerEdit"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;canPlaceOn(Lnet/minecraft/block/Block;)Z"))
    private boolean canEditSpongeThrowChangePreEvent(ItemStack stack, Block block, BlockPos pos, EnumFacing facing, ItemStack sameStack) {
        if (!stack.func_179547_d(block)) {
            return false;
        }
        if (this.field_70170_p instanceof WorldBridge && !((WorldBridge)this.field_70170_p).bridge$isFake() && ShouldFire.CHANGE_BLOCK_EVENT_PRE) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(stack));
                boolean bl2 = !SpongeCommonEventFactory.callChangeBlockEventPre((WorldServerBridge)this.field_70170_p, pos, (Object)this).isCancelled();
                return bl2;
            }
        }
        return true;
    }

    @Overwrite
    @Nullable
    public EntityItem func_71019_a(ItemStack itemStackIn, boolean unused) {
        return this.func_146097_a(itemStackIn, false, false);
    }

    @Nullable
    @Overwrite
    public EntityItem func_146097_a(ItemStack droppedItem, boolean dropAround, boolean traceItem) {
        if (droppedItem.func_190926_b()) {
            return null;
        }
        if (!((WorldBridge)this.field_70170_p).bridge$isFake()) {
            this.bridge$shouldRestoreInventory(false);
            EntityPlayer player = (EntityPlayer)this;
            double posX1 = player.field_70165_t;
            double posY1 = player.field_70163_u - 0.3 + (double)player.func_70047_e();
            double posZ1 = player.field_70161_v;
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(droppedItem);
            ArrayList<ItemStackSnapshot> original = new ArrayList<ItemStackSnapshot>();
            original.add(snapshot);
            PhaseContext<?> phaseContext = PhaseTracker.getInstance().getCurrentContext();
            IPhaseState currentState = phaseContext.state;
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                ItemStack item = SpongeCommonEventFactory.throwDropItemAndConstructEvent((net.minecraft.entity.Entity)((EntityPlayer)this), posX1, posY1, posZ1, snapshot, original, frame);
                if (item == null || item.func_190926_b()) {
                    EntityItem entityItem = null;
                    return entityItem;
                }
                EntityItem entityitem = new EntityItem(player.field_70170_p, posX1, posY1, posZ1, droppedItem);
                entityitem.func_174867_a(40);
                if (traceItem) {
                    entityitem.func_145799_b(player.func_70005_c_());
                }
                Random random = player.func_70681_au();
                if (dropAround) {
                    float f = random.nextFloat() * 0.5f;
                    float f1 = random.nextFloat() * ((float)Math.PI * 2);
                    entityitem.field_70159_w = -MathHelper.func_76126_a((float)f1) * f;
                    entityitem.field_70179_y = MathHelper.func_76134_b((float)f1) * f;
                    entityitem.field_70181_x = 0.2f;
                } else {
                    float f2 = 0.3f;
                    entityitem.field_70159_w = -MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(player.field_70125_A * ((float)Math.PI / 180))) * f2;
                    entityitem.field_70179_y = MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(player.field_70125_A * ((float)Math.PI / 180))) * f2;
                    entityitem.field_70181_x = -MathHelper.func_76126_a((float)(player.field_70125_A * ((float)Math.PI / 180))) * f2 + 0.1f;
                    float f3 = random.nextFloat() * ((float)Math.PI * 2);
                    f2 = 0.02f * random.nextFloat();
                    entityitem.field_70159_w += Math.cos(f3) * (double)f2;
                    entityitem.field_70181_x += (double)((random.nextFloat() - random.nextFloat()) * 0.1f);
                    entityitem.field_70179_y += Math.sin(f3) * (double)f2;
                }
                if (currentState.spawnItemOrCapture(phaseContext, (net.minecraft.entity.Entity)((EntityPlayer)this), entityitem)) {
                    EntityItem f2 = entityitem;
                    return f2;
                }
                ItemStack stack = entityitem.func_92059_d();
                player.field_70170_p.func_72838_d((net.minecraft.entity.Entity)entityitem);
                if (traceItem) {
                    if (!stack.func_190926_b()) {
                        player.func_71064_a(StatList.func_188058_e((Item)stack.func_77973_b()), droppedItem.func_190916_E());
                    }
                    player.func_71029_a(StatList.field_75952_v);
                }
                EntityItem entityItem = entityitem;
                return entityItem;
            }
        }
        double d0 = this.field_70163_u - (double)0.3f + (double)this.func_70047_e();
        EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, d0, this.field_70161_v, droppedItem);
        entityitem.func_174867_a(40);
        if (traceItem) {
            entityitem.func_145799_b(this.shadow$func_70005_c_());
        }
        if (dropAround) {
            float f = this.field_70146_Z.nextFloat() * 0.5f;
            float f1 = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
            entityitem.field_70159_w = -MathHelper.func_76126_a((float)f1) * f;
            entityitem.field_70179_y = MathHelper.func_76134_b((float)f1) * f;
            entityitem.field_70181_x = 0.2f;
        } else {
            float f2 = 0.3f;
            entityitem.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(this.field_70125_A * ((float)Math.PI / 180))) * f2;
            entityitem.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(this.field_70125_A * ((float)Math.PI / 180))) * f2;
            entityitem.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A * ((float)Math.PI / 180))) * f2 + 0.1f;
            float f3 = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
            f2 = 0.02f * this.field_70146_Z.nextFloat();
            entityitem.field_70159_w += Math.cos(f3) * (double)f2;
            entityitem.field_70181_x += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f);
            entityitem.field_70179_y += Math.sin(f3) * (double)f2;
        }
        ItemStack itemstack = this.func_184816_a(entityitem);
        if (traceItem) {
            if (itemstack != null && !itemstack.func_190926_b()) {
                this.func_71064_a(StatList.func_188058_e((Item)itemstack.func_77973_b()), droppedItem.func_190916_E());
            }
            this.func_71029_a(StatList.field_75952_v);
        }
        return entityitem;
    }

    @Overwrite
    @Nullable
    public ItemStack func_184816_a(EntityItem entity) {
        this.field_70170_p.func_72838_d((net.minecraft.entity.Entity)entity);
        return entity.func_92059_d();
    }

    @Redirect(method={"collideWithPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;onCollideWithPlayer(Lnet/minecraft/entity/player/EntityPlayer;)V"))
    private void onPlayerCollideEntity(net.minecraft.entity.Entity entity, EntityPlayer player) {
        entity.func_70100_b_(player);
    }

    @Inject(method={"attackEntityFrom"}, cancellable=true, at={@At(value="HEAD")})
    private void onAttackEntityFrom(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (source == DamageSourceRegistryModule.IGNORED_DAMAGE_SOURCE) {
            if (this.func_70608_bn() && !this.field_70170_p.field_72995_K) {
                this.func_70999_a(true, true, false);
            }
            cir.setReturnValue(super.func_70097_a(source, amount));
        }
    }

    @Overwrite
    public void func_71059_n(net.minecraft.entity.Entity targetEntity) {
        if (!SpongeImplHooks.checkAttackEntity((EntityPlayer)this, targetEntity)) {
            return;
        }
        if (targetEntity.func_70075_an() && !targetEntity.func_85031_j((net.minecraft.entity.Entity)((EntityPlayer)this))) {
            double originalBaseDamage = this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            float damage = (float)originalBaseDamage;
            float enchantmentDamage = 0.0f;
            float attackStrength = this.func_184825_o(0.5f);
            ArrayList<DamageFunction> originalFunctions = new ArrayList<DamageFunction>();
            EnumCreatureAttribute creatureAttribute = targetEntity instanceof EntityLivingBase ? ((EntityLivingBase)targetEntity).func_70668_bt() : EnumCreatureAttribute.UNDEFINED;
            List<DamageFunction> enchantmentModifierFunctions = DamageEventHandler.createAttackEnchantmentFunction(this.func_184614_ca(), creatureAttribute, attackStrength);
            List enchantmentModifiers = enchantmentModifierFunctions.stream().map(ModifierFunction::getModifier).collect(Collectors.toList());
            enchantmentDamage = (float)enchantmentModifierFunctions.stream().map(ModifierFunction::getFunction).mapToDouble(function -> function.applyAsDouble(originalBaseDamage)).sum();
            originalFunctions.addAll(enchantmentModifierFunctions);
            originalFunctions.add(DamageEventHandler.provideCooldownAttackStrengthFunction((EntityPlayer)this, attackStrength));
            enchantmentDamage *= attackStrength;
            this.func_184821_cY();
            if ((damage *= 0.2f + attackStrength * attackStrength * 0.8f) > 0.0f || enchantmentDamage > 0.0f) {
                boolean isMainthread;
                ItemStack itemstack;
                boolean isStrongAttack = attackStrength > 0.9f;
                boolean isSprintingAttack = false;
                boolean isCriticalAttack = false;
                boolean isSweapingAttack = false;
                int knockbackModifier = 0;
                knockbackModifier += EnchantmentHelper.func_77501_a((EntityLivingBase)((EntityPlayer)this));
                if (this.func_70051_ag() && isStrongAttack) {
                    ++knockbackModifier;
                    isSprintingAttack = true;
                }
                isCriticalAttack = isStrongAttack && this.field_70143_R > 0.0f && !this.field_70122_E && !this.func_70617_f_() && !this.shadow$func_70090_H() && !this.func_70644_a(MobEffects.field_76440_q) && !this.func_184218_aH() && targetEntity instanceof EntityLivingBase;
                boolean bl2 = isCriticalAttack = isCriticalAttack && !this.func_70051_ag();
                if (isCriticalAttack) {
                    originalFunctions.add(DamageEventHandler.provideCriticalAttackTuple((EntityPlayer)this));
                }
                double distanceWalkedDelta = this.field_70140_Q - this.field_70141_P;
                ItemStack heldItem = this.func_184586_b(EnumHand.MAIN_HAND);
                if (isStrongAttack && !isCriticalAttack && !isSprintingAttack && this.field_70122_E && distanceWalkedDelta < (double)this.func_70689_ay() && (itemstack = heldItem).func_77973_b() instanceof ItemSword) {
                    isSweapingAttack = true;
                }
                DamageSource damageSource = DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)this));
                boolean bl3 = isMainthread = !this.field_70170_p.field_72995_K;
                if (isMainthread) {
                    Sponge.getCauseStackManager().pushCause(damageSource);
                }
                Cause attackCause = isMainthread ? Sponge.getCauseStackManager().getCurrentCause() : Cause.of(EventContext.empty(), damageSource);
                AttackEntityEvent event = SpongeEventFactory.createAttackEntityEvent(attackCause, originalFunctions, (Entity)targetEntity, knockbackModifier, originalBaseDamage);
                SpongeImpl.postEvent(event);
                if (isMainthread) {
                    Sponge.getCauseStackManager().popCause();
                }
                if (event.isCancelled()) {
                    return;
                }
                damage = (float)event.getFinalOutputDamage();
                double attackDamage = damage;
                knockbackModifier = event.getKnockbackModifier();
                enchantmentDamage = (float)enchantmentModifiers.stream().mapToDouble(event::getOutputDamage).sum();
                float targetOriginalHealth = 0.0f;
                boolean litEntityOnFire = false;
                int fireAspectModifier = EnchantmentHelper.func_90036_a((EntityLivingBase)((EntityPlayer)this));
                if (targetEntity instanceof EntityLivingBase) {
                    targetOriginalHealth = ((EntityLivingBase)targetEntity).func_110143_aJ();
                    if (fireAspectModifier > 0 && !targetEntity.func_70027_ad()) {
                        litEntityOnFire = true;
                        targetEntity.func_70015_d(1);
                    }
                }
                double targetMotionX = targetEntity.field_70159_w;
                double targetMotionY = targetEntity.field_70181_x;
                double targetMotionZ = targetEntity.field_70179_y;
                boolean attackSucceeded = targetEntity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)this)), damage);
                if (attackSucceeded) {
                    IEntityMultiPart ientitymultipart;
                    if (knockbackModifier > 0) {
                        if (targetEntity instanceof EntityLivingBase) {
                            ((EntityLivingBase)targetEntity).func_70653_a((net.minecraft.entity.Entity)((EntityPlayer)this), (float)knockbackModifier * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                        } else {
                            targetEntity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * (float)knockbackModifier * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * (float)knockbackModifier * 0.5f));
                        }
                        this.field_70159_w *= 0.6;
                        this.field_70179_y *= 0.6;
                        this.func_70031_b(false);
                    }
                    if (isSweapingAttack) {
                        for (EntityLivingBase entitylivingbase : this.field_70170_p.func_72872_a(EntityLivingBase.class, targetEntity.func_174813_aQ().func_72314_b(1.0, 0.25, 1.0))) {
                            if (entitylivingbase == (EntityPlayer)this || entitylivingbase == targetEntity || this.func_184191_r((net.minecraft.entity.Entity)entitylivingbase) || !(this.func_70068_e((net.minecraft.entity.Entity)entitylivingbase) < 9.0)) continue;
                            EntityDamageSource sweepingAttackSource = (EntityDamageSource)((EntityDamageSource.Builder)((EntityDamageSource.Builder)EntityDamageSource.builder().entity((Player)((Object)this))).type(DamageTypes.SWEEPING_ATTACK)).build();
                            CauseStackManager.StackFrame frame = isMainthread ? Sponge.getCauseStackManager().pushCauseFrame() : null;
                            Throwable throwable = null;
                            try {
                                if (isMainthread) {
                                    frame.pushCause(sweepingAttackSource);
                                }
                                ItemStackSnapshot heldSnapshot = ItemStackUtil.snapshotOf(heldItem);
                                if (isMainthread) {
                                    frame.addContext(EventContextKeys.WEAPON, heldSnapshot);
                                }
                                DamageFunction sweapingFunction = DamageFunction.of(DamageModifier.builder().cause(Cause.of(EventContext.empty(), heldSnapshot)).item(heldSnapshot).type(DamageModifierTypes.SWEEPING).build(), incoming -> (double)EnchantmentHelper.func_191527_a((EntityLivingBase)((EntityPlayer)this)) * attackDamage);
                                ArrayList<DamageFunction> sweapingFunctions = new ArrayList<DamageFunction>();
                                sweapingFunctions.add(sweapingFunction);
                                Cause sweepingCause = isMainthread ? Sponge.getCauseStackManager().getCurrentCause() : Cause.of(EventContext.empty(), sweepingAttackSource);
                                AttackEntityEvent sweepingAttackEvent = SpongeEventFactory.createAttackEntityEvent(sweepingCause, sweapingFunctions, (Entity)entitylivingbase, 1, 1.0);
                                SpongeImpl.postEvent(sweepingAttackEvent);
                                if (sweepingAttackEvent.isCancelled()) continue;
                                entitylivingbase.func_70653_a((net.minecraft.entity.Entity)((EntityPlayer)this), (float)sweepingAttackEvent.getKnockbackModifier() * 0.4f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                                entitylivingbase.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)this)), (float)sweepingAttackEvent.getFinalOutputDamage());
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (frame == null) continue;
                                if (throwable != null) {
                                    try {
                                        frame.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                frame.close();
                            }
                        }
                        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187730_dW, this.func_184176_by(), 1.0f, 1.0f);
                        this.func_184810_cG();
                    }
                    if (targetEntity instanceof EntityPlayerMP && targetEntity.field_70133_I) {
                        ((EntityPlayerMP)targetEntity).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(targetEntity));
                        targetEntity.field_70133_I = false;
                        targetEntity.field_70159_w = targetMotionX;
                        targetEntity.field_70181_x = targetMotionY;
                        targetEntity.field_70179_y = targetMotionZ;
                    }
                    if (isCriticalAttack) {
                        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187718_dS, this.func_184176_by(), 1.0f, 1.0f);
                        this.func_71009_b(targetEntity);
                    }
                    if (!isCriticalAttack && !isSweapingAttack) {
                        if (isStrongAttack) {
                            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187727_dV, this.func_184176_by(), 1.0f, 1.0f);
                        } else {
                            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187733_dX, this.func_184176_by(), 1.0f, 1.0f);
                        }
                    }
                    if (enchantmentDamage > 0.0f) {
                        this.func_71047_c(targetEntity);
                    }
                    this.func_130011_c(targetEntity);
                    if (targetEntity instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)targetEntity), (net.minecraft.entity.Entity)((EntityPlayer)this));
                    }
                    EnchantmentHelper.func_151385_b((EntityLivingBase)((EntityPlayer)this), (net.minecraft.entity.Entity)targetEntity);
                    ItemStack itemstack1 = this.func_184614_ca();
                    net.minecraft.entity.Entity entity = targetEntity;
                    if (targetEntity instanceof MultiPartEntityPart && (ientitymultipart = ((MultiPartEntityPart)targetEntity).field_70259_a) instanceof EntityLivingBase) {
                        entity = (EntityLivingBase)ientitymultipart;
                    }
                    if (!itemstack1.func_190926_b() && entity instanceof EntityLivingBase) {
                        itemstack1.func_77961_a((EntityLivingBase)entity, (EntityPlayer)this);
                        if (itemstack1.func_190926_b()) {
                            this.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                        }
                    }
                    if (targetEntity instanceof EntityLivingBase) {
                        float f5 = targetOriginalHealth - ((EntityLivingBase)targetEntity).func_110143_aJ();
                        this.func_71064_a(StatList.field_188111_y, Math.round(f5 * 10.0f));
                        if (fireAspectModifier > 0) {
                            targetEntity.func_70015_d(fireAspectModifier * 4);
                        }
                        if (this.field_70170_p instanceof WorldServer && f5 > 2.0f) {
                            int k = (int)((double)f5 * 0.5);
                            ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.DAMAGE_INDICATOR, targetEntity.field_70165_t, targetEntity.field_70163_u + (double)(targetEntity.field_70131_O * 0.5f), targetEntity.field_70161_v, k, 0.1, 0.0, 0.1, 0.2, new int[0]);
                        }
                    }
                    this.func_71020_j(0.3f);
                } else {
                    this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187724_dU, this.func_184176_by(), 1.0f, 1.0f);
                    if (litEntityOnFire) {
                        targetEntity.func_70066_B();
                    }
                }
            }
        }
    }

    @Inject(method={"setItemStackToSlot"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/NonNullList;set(ILjava/lang/Object;)Ljava/lang/Object;")})
    private void onSetItemStackToSlot(EntityEquipmentSlot slotIn, ItemStack stack, CallbackInfo ci) {
        if (((TrackedInventoryBridge)this.field_71071_by).bridge$capturingInventory()) {
            if (slotIn == EntityEquipmentSlot.MAINHAND) {
                ItemStack orig = (ItemStack)this.field_71071_by.field_70462_a.get(this.field_71071_by.field_70461_c);
                Slot slot = ((PlayerInventory)this.field_71071_by).getMain().getHotbar().getSlot(SlotIndex.of(this.field_71071_by.field_70461_c)).get();
                ((TrackedInventoryBridge)this.field_71071_by).bridge$getCapturedSlotTransactions().add(new SlotTransaction(slot, ItemStackUtil.snapshotOf(orig), ItemStackUtil.snapshotOf(stack)));
            } else if (slotIn == EntityEquipmentSlot.OFFHAND) {
                ItemStack orig = (ItemStack)this.field_71071_by.field_184439_c.get(0);
                Slot slot = ((PlayerInventory)this.field_71071_by).getOffhand();
                ((TrackedInventoryBridge)this.field_71071_by).bridge$getCapturedSlotTransactions().add(new SlotTransaction(slot, ItemStackUtil.snapshotOf(orig), ItemStackUtil.snapshotOf(stack)));
            } else if (slotIn.func_188453_a() == EntityEquipmentSlot.Type.ARMOR) {
                ItemStack orig = (ItemStack)this.field_71071_by.field_70460_b.get(slotIn.func_188454_b());
                Slot slot = ((PlayerInventory)this.field_71071_by).getEquipment().getSlot(SlotIndex.of(slotIn.func_188454_b())).get();
                ((TrackedInventoryBridge)this.field_71071_by).bridge$getCapturedSlotTransactions().add(new SlotTransaction(slot, ItemStackUtil.snapshotOf(orig), ItemStackUtil.snapshotOf(stack)));
            }
        }
    }

    @Redirect(method={"setDead"}, at=@At(value="INVOKE", ordinal=1, target="Lnet/minecraft/inventory/Container;onContainerClosed(Lnet/minecraft/entity/player/EntityPlayer;)V"))
    private void onOnContainerClosed(Container container, EntityPlayer player) {
        if (Sponge.isServerAvailable() && SpongeImplHooks.isClientAvailable() && Sponge.getGame().getState() == GameState.SERVER_STOPPING) {
            container.func_75134_a(player);
            return;
        }
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP serverPlayer = (EntityPlayerMP)player;
            try (BasicPacketContext ctx = ((BasicPacketContext)((BasicPacketContext)PacketPhase.General.CLOSE_WINDOW.createPhaseContext().source(serverPlayer)).packetPlayer(serverPlayer)).openContainer(container);){
                ctx.buildAndSwitch();
                ItemStackSnapshot cursor = ItemStackUtil.snapshotOf(this.field_71071_by.func_70445_o());
                container.func_75134_a(player);
                SpongeCommonEventFactory.callInteractInventoryCloseEvent(this.field_71070_bA, serverPlayer, cursor, ItemStackSnapshot.NONE, false);
            }
        } else {
            container.func_75134_a(player);
        }
    }

    @Override
    public void bridge$shouldRestoreInventory(boolean restore) {
        this.shouldRestoreInventory = restore;
    }

    @Override
    public boolean bridge$shouldRestoreInventory() {
        return this.shouldRestoreInventory;
    }

    @Override
    public boolean spongeImpl$isImmuneToFireForIgniteEvent() {
        return this.func_175149_v() || this.func_184812_l_();
    }
}

