/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.item.crafting;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.recipe.smelting.SmeltingRecipe;
import org.spongepowered.api.item.recipe.smelting.SmeltingResult;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.translation.FixedTranslation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.item.recipe.smelting.MatchSmeltingVanillaItemStack;
import org.spongepowered.common.item.recipe.smelting.SpongeSmeltingRecipe;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;

@Mixin(value={FurnaceRecipes.class})
public abstract class FurnaceRecipesMixin
implements SpongeAdditionalCatalogRegistryModule<SmeltingRecipe> {
    @Shadow
    @Final
    private Map<ItemStack, ItemStack> field_77604_b;
    @Shadow
    @Final
    private Map<ItemStack, Float> field_77605_c;
    private final Map<String, SmeltingRecipe> recipesById = new HashMap<String, SmeltingRecipe>();
    private final List<SmeltingRecipe> customRecipes = new ArrayList<SmeltingRecipe>();
    private final List<SmeltingRecipe> notCustomRecipes = new ArrayList<SmeltingRecipe>();
    private final Map<ItemStack, SmeltingRecipe> nativeIngredientToCustomRecipe = new IdentityHashMap<ItemStack, SmeltingRecipe>();

    @Shadow
    private boolean func_151397_a(ItemStack stack1, ItemStack stack2) {
        throw new IllegalStateException("unreachable");
    }

    @Inject(method={"getSmeltingResult"}, at={@At(value="RETURN")}, cancellable=true)
    private void spongeImpl$onGetSmeltingResult(ItemStack stack, CallbackInfoReturnable<ItemStack> cir) {
        ItemStackSnapshot ingredient = ItemStackUtil.snapshotOf(stack);
        Optional<SmeltingResult> result = this.getCustomResult(ingredient);
        if (result.isPresent()) {
            ItemStack nativeResult = ItemStackUtil.fromSnapshotToNative(result.get().getResult());
            cir.setReturnValue(nativeResult);
        } else {
            for (ItemStack nativeIngredient : this.nativeIngredientToCustomRecipe.keySet()) {
                if (!this.func_151397_a(nativeIngredient, stack)) continue;
                cir.setReturnValue(ItemStack.field_190927_a);
                return;
            }
        }
    }

    @Inject(method={"getSmeltingExperience"}, at={@At(value="RETURN")}, cancellable=true)
    private void spongeImpl$onGetSmeltingExperience(ItemStack stack, CallbackInfoReturnable<Float> cir) {
        ItemStackSnapshot ingredient = ItemStackUtil.snapshotOf(stack);
        Optional<SmeltingResult> result = this.getCustomResult(ingredient);
        if (result.isPresent()) {
            float nativeResult = (float)result.get().getExperience();
            cir.setReturnValue(Float.valueOf(nativeResult));
        }
    }

    private Optional<SmeltingResult> getCustomResult(ItemStackSnapshot ingredient) {
        Preconditions.checkNotNull(ingredient, "ingredient");
        for (SmeltingRecipe recipe : this.customRecipes) {
            Optional<SmeltingResult> result = recipe.getResult(ingredient);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    @Inject(method={"addSmeltingRecipe(Lnet/minecraft/item/ItemStack;Lnet/minecraft/item/ItemStack;F)V"}, at={@At(value="RETURN")})
    private void spongeImpl$onAddSmeltingRecipe(ItemStack input, ItemStack stack, float experience, CallbackInfo ci) {
        String namespace;
        ItemStackSnapshot result = ItemStackUtil.snapshotOf(stack);
        ItemStackSnapshot ingredient = ItemStackUtil.snapshotOf(input);
        PluginContainer activeModContainer = SpongeImplHooks.getActiveModContainer();
        String string = namespace = activeModContainer == null ? "minecraft" : activeModContainer.getId();
        if (result.isEmpty() || ingredient.isEmpty()) {
            SpongeImpl.getLogger().error("Invalid smelting recipe registration!\nThe mod \"" + namespace + "\" is registering a smelting recipe wrongly which causes the resulting recipe to be invalid.\nA common cause which makes smelting recipes invalid occurs when registering those recipes before the used blocks are\nregistered, it's recommend to register them when the items are finished registering.\n", (Throwable)new IllegalStateException("Invalid smelting recipe registered by the mod \"" + namespace + "\"!"));
            return;
        }
        MatchSmeltingVanillaItemStack ingredientPredicate = new MatchSmeltingVanillaItemStack(ingredient);
        String resultId = result.getType().getId();
        int index = resultId.indexOf(58);
        resultId = index == -1 ? resultId : resultId.substring(index + 1);
        String ingredientId = ingredient.getType().getId();
        index = ingredientId.indexOf(58);
        ingredientId = index == -1 ? ingredientId : ingredientId.substring(index + 1);
        String name = resultId + "_to_" + ingredientId;
        String id = namespace + ':' + name;
        SpongeSmeltingRecipe recipe = new SpongeSmeltingRecipe(id, new FixedTranslation(name), ingredient, ingredientPredicate, experience, result);
        this.recipesById.put(id, recipe);
        this.notCustomRecipes.add(recipe);
    }

    @Override
    public void registerAdditionalCatalog(SmeltingRecipe recipe) {
        Preconditions.checkNotNull(recipe, "recipe");
        Preconditions.checkArgument(!this.recipesById.containsKey(recipe.getId()), "Duplicate id: %s", (Object)recipe.getId());
        ItemStackSnapshot exemplaryIngredient = recipe.getExemplaryIngredient();
        ItemStack nativeExemplaryIngredient = ItemStackUtil.fromSnapshotToNative(exemplaryIngredient);
        ItemStack nativeExemplaryResult = ItemStackUtil.fromSnapshotToNative(recipe.getExemplaryResult());
        float nativeExemplaryExperience = (float)recipe.getResult(exemplaryIngredient).orElseThrow(() -> new IllegalStateException("Could not get the result for the exemplary ingredient.")).getExperience();
        this.field_77604_b.put(nativeExemplaryIngredient, nativeExemplaryResult);
        this.field_77605_c.put(nativeExemplaryResult, Float.valueOf(nativeExemplaryExperience));
        this.nativeIngredientToCustomRecipe.put(nativeExemplaryIngredient, recipe);
        this.customRecipes.add(recipe);
        this.recipesById.put(recipe.getId(), recipe);
    }

    @Override
    public boolean allowsApiRegistration() {
        return true;
    }
}

