/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.item.inventory;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.text.translation.FixedTranslation;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.item.inventory.InventoryBridge;
import org.spongepowered.common.item.inventory.lens.Fabric;

@Mixin(value={Container.class})
public abstract class ContainerFabricMixin
implements Fabric,
InventoryBridge {
    @Shadow
    public List<Slot> field_75151_b;
    @Nullable
    private Translation displayName;
    @Nullable
    private Set<InventoryBridge> all;

    @Shadow
    public abstract Slot func_75139_a(int var1);

    @Shadow
    public abstract void func_75142_b();

    @Override
    public Collection<InventoryBridge> fabric$allInventories() {
        if (this.all == null) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (Slot slot : this.field_75151_b) {
                if (slot.field_75224_c == null) continue;
                builder.add((InventoryBridge)slot.field_75224_c);
            }
            this.all = builder.build();
        }
        return this.all;
    }

    @Override
    public InventoryBridge fabric$get(int index) {
        if (this.field_75151_b.isEmpty()) {
            return null;
        }
        return (InventoryBridge)this.func_75139_a((int)index).field_75224_c;
    }

    @Override
    public ItemStack fabric$getStack(int index) {
        return this.func_75139_a(index).func_75211_c();
    }

    @Override
    public void fabric$setStack(int index, ItemStack stack) {
        this.func_75139_a(index).func_75215_d(stack);
    }

    @Override
    public int fabric$getMaxStackSize() {
        return this.fabric$allInventories().stream().map(b2 -> b2.bridge$getAdapter().bridge$getFabric()).mapToInt(Fabric::fabric$getMaxStackSize).max().orElse(0);
    }

    @Override
    public Translation fabric$getDisplayName() {
        if (this.displayName == null) {
            this.displayName = this.getFirstDisplayName();
        }
        return this.displayName;
    }

    @Override
    public int fabric$getSize() {
        return this.field_75151_b.size();
    }

    @Override
    public void fabric$clear() {
        for (Slot slot : this.field_75151_b) {
            slot.func_75215_d(ItemStack.field_190927_a);
        }
    }

    @Override
    public void fabric$markDirty() {
        this.func_75142_b();
    }

    private Translation getFirstDisplayName() {
        if (this.field_75151_b.size() == 0) {
            return new FixedTranslation("Container");
        }
        try {
            Slot slot = this.func_75139_a(0);
            return slot.field_75224_c != null && slot.field_75224_c.func_145748_c_() != null ? new FixedTranslation(slot.field_75224_c.func_145748_c_().func_150260_c()) : new FixedTranslation("UNKNOWN: " + this.getClass().getName());
        }
        catch (AbstractMethodError e) {
            SpongeImpl.getLogger().warn("AbstractMethodError! Could not find displayName for " + this.func_75139_a((int)0).field_75224_c.getClass().getName(), (Throwable)e);
            return new FixedTranslation("UNKNOWN: " + this.getClass().getName());
        }
    }
}

