/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.profiler.Profiler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.GameType;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.command.TabCompleteEvent;
import org.spongepowered.api.resourcepack.ResourcePack;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.world.DimensionType;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.SerializationBehaviors;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.bridge.command.CommandSenderBridge;
import org.spongepowered.common.bridge.command.CommandSourceBridge;
import org.spongepowered.common.bridge.permissions.SubjectBridge;
import org.spongepowered.common.bridge.server.MinecraftServerBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.WorldInfoBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkProviderServerBridge;
import org.spongepowered.common.command.SpongeCommandManager;
import org.spongepowered.common.config.SpongeConfig;
import org.spongepowered.common.config.type.WorldConfig;
import org.spongepowered.common.event.tracking.CauseTrackerCrashHandler;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;
import org.spongepowered.common.event.tracking.phase.general.MapConversionContext;
import org.spongepowered.common.event.tracking.phase.generation.GenerationPhase;
import org.spongepowered.common.event.tracking.phase.generation.GenericGenerationContext;
import org.spongepowered.common.event.tracking.phase.plugin.BasicPluginContext;
import org.spongepowered.common.event.tracking.phase.plugin.PluginPhase;
import org.spongepowered.common.relocate.co.aikar.timings.TimingsManager;
import org.spongepowered.common.resourcepack.SpongeResourcePack;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.WorldManager;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin
implements SubjectBridge,
CommandSourceBridge,
CommandSenderBridge,
MinecraftServerBridge {
    @Shadow
    @Final
    private static Logger field_147145_h;
    @Shadow
    @Final
    public Profiler field_71304_b;
    @Shadow
    private boolean field_71316_v;
    @Shadow
    private int field_71315_w;
    @Shadow
    public WorldServer[] field_71305_c;
    @Nullable
    private List<String> impl$currentTabCompletionOptions;
    @Nullable
    private ResourcePack impl$resourcePack;
    private boolean impl$enableSaving = true;
    @Nullable
    private Integer dimensionId;

    @Shadow
    public abstract void func_145747_a(ITextComponent var1);

    @Shadow
    public abstract boolean func_71278_l();

    @Shadow
    public abstract PlayerList func_184103_al();

    @Shadow
    public abstract EnumDifficulty func_147135_j();

    @Shadow
    public abstract GameType func_71265_f();

    @Shadow
    protected abstract void func_71192_d(String var1);

    @Shadow
    protected abstract void func_71216_a_(String var1, int var2);

    @Shadow
    protected abstract void func_71243_i();

    @Shadow
    protected abstract void func_71237_c(String var1);

    @Shadow
    public abstract boolean func_71262_S();

    @Shadow
    public abstract String shadow$func_70005_c_();

    @Shadow
    public abstract PlayerProfileCache func_152358_ax();

    @Override
    public String bridge$getIdentifier() {
        return this.shadow$func_70005_c_();
    }

    @Override
    public String bridge$getSubjectCollectionIdentifier() {
        return "system";
    }

    @Override
    public Tristate bridge$permDefault(String permission) {
        return Tristate.TRUE;
    }

    @Override
    public ICommandSender bridge$asICommandSender() {
        return (MinecraftServer)((Object)this);
    }

    @Override
    public CommandSource bridge$asCommandSource() {
        return (CommandSource)((Object)this);
    }

    @Overwrite
    public void func_71247_a(String overworldFolder, String worldName, long seed, WorldType type, String generatorOptions) {
        try (MapConversionContext context = ((MapConversionContext)GeneralPhase.State.MAP_CONVERSION.createPhaseContext().source(this)).world(overworldFolder);){
            context.buildAndSwitch();
            this.func_71237_c(overworldFolder);
        }
        this.func_71192_d("menu.loadingLevel");
        WorldManager.loadAllWorlds(seed, type, generatorOptions);
        this.func_184103_al().func_72364_a(this.field_71305_c);
        this.func_147139_a(this.func_147135_j());
    }

    @Overwrite
    public void func_71222_d() {
        for (WorldServer worldServer : this.field_71305_c) {
            this.bridge$prepareSpawnArea(worldServer);
        }
        this.func_71243_i();
    }

    @Override
    public void bridge$prepareSpawnArea(WorldServer worldServer) {
        WorldProperties worldProperties = (WorldProperties)worldServer.func_72912_H();
        if (!((WorldInfoBridge)((Object)worldProperties)).bridge$isValid() || !worldProperties.doesGenerateSpawnOnLoad()) {
            return;
        }
        ChunkProviderServerBridge chunkProviderServer = (ChunkProviderServerBridge)worldServer.func_72863_F();
        chunkProviderServer.bridge$setForceChunkRequests(true);
        try (Object context = ((GenericGenerationContext)GenerationPhase.State.TERRAIN_GENERATION.createPhaseContext().source(worldServer)).world((net.minecraft.world.World)worldServer);){
            ((PhaseContext)context).buildAndSwitch();
            int i = 0;
            this.func_71192_d("menu.generatingTerrain");
            field_147145_h.info("Preparing start region for world {} ({}/{})", (Object)worldServer.func_72912_H().func_76065_j(), (Object)((DimensionType)worldServer.field_73011_w.func_186058_p()).getId(), (Object)((WorldServerBridge)worldServer).bridge$getDimensionId());
            BlockPos blockpos = worldServer.func_175694_M();
            long j = MinecraftServer.func_130071_aq();
            for (int k = -192; k <= 192 && this.func_71278_l(); k += 16) {
                for (int l = -192; l <= 192 && this.func_71278_l(); l += 16) {
                    long i1 = MinecraftServer.func_130071_aq();
                    if (i1 - j > 1000L) {
                        this.func_71216_a_("Preparing spawn area", i * 100 / 625);
                        j = i1;
                    }
                    ++i;
                    worldServer.func_72863_F().func_186025_d(blockpos.func_177958_n() + k >> 4, blockpos.func_177952_p() + l >> 4);
                }
            }
            this.func_71243_i();
        }
        chunkProviderServer.bridge$setForceChunkRequests(false);
    }

    @Inject(method={"setResourcePack(Ljava/lang/String;Ljava/lang/String;)V"}, at={@At(value="HEAD")})
    private void impl$updateResourcePack(String url, String hash, CallbackInfo ci) {
        if (url.length() == 0) {
            this.impl$resourcePack = null;
        } else {
            try {
                this.impl$resourcePack = SpongeResourcePack.create(url, hash);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    @Nullable
    public ResourcePack bridge$getResourcePack() {
        return this.impl$resourcePack;
    }

    @Override
    public void bridge$setSaveEnabled(boolean enabled) {
        this.impl$enableSaving = enabled;
    }

    @Redirect(method={"getTabCompletions"}, at=@At(value="INVOKE", target="Lcom/google/common/collect/Lists;newArrayList()Ljava/util/ArrayList;", remap=false))
    private ArrayList<String> impl$useSpongeTabCompletionList() {
        ArrayList<String> list = new ArrayList<String>();
        this.impl$currentTabCompletionOptions = list;
        return list;
    }

    @Inject(method={"getTabCompletions"}, at={@At(value="RETURN", ordinal=0)})
    private void impl$throwEventForTabCompletion(ICommandSender sender, String input, BlockPos pos, boolean usingBlock, CallbackInfoReturnable<List<String>> cir) {
        List<String> completions = Preconditions.checkNotNull(this.impl$currentTabCompletionOptions, "currentTabCompletionOptions");
        this.impl$currentTabCompletionOptions = null;
        Sponge.getCauseStackManager().pushCause(sender);
        TabCompleteEvent.Chat event = SpongeEventFactory.createTabCompleteEventChat(Sponge.getCauseStackManager().getCurrentCause(), ImmutableList.copyOf(completions), completions, input, Optional.ofNullable(MinecraftServerMixin.getTarget(sender, pos)), usingBlock);
        Sponge.getEventManager().post(event);
        Sponge.getCauseStackManager().popCause();
        if (event.isCancelled()) {
            completions.clear();
        }
    }

    @Redirect(method={"getTabCompletions"}, at=@At(value="INVOKE", target="Lnet/minecraft/command/ICommandManager;getTabCompletions(Lnet/minecraft/command/ICommandSender;Ljava/lang/String;Lnet/minecraft/util/math/BlockPos;)Ljava/util/List;"))
    private List<String> impl$useSpongeCommandManagerForSuggestions(ICommandManager manager, ICommandSender sender, String input, @Nullable BlockPos pos, ICommandSender sender_, String input_, BlockPos pos_, boolean hasTargetBlock) {
        return ((SpongeCommandManager)SpongeImpl.getGame().getCommandManager()).getSuggestions((CommandSource)sender, input, MinecraftServerMixin.getTarget(sender, pos), hasTargetBlock);
    }

    @Nullable
    private static Location<World> getTarget(ICommandSender sender, @Nullable BlockPos pos) {
        Location<World> targetPos = null;
        if (pos != null) {
            targetPos = new Location<World>((World)sender.func_130014_f_(), VecHelper.toVector3i(pos));
        }
        return targetPos;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onServerTickStart(CallbackInfo ci) {
        TimingsManager.FULL_SERVER_TICK.startTiming();
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void impl$completePhaseTracker(CallbackInfo ci) {
        PhaseTracker.getInstance().ensureEmpty();
        TimingsManager.FULL_SERVER_TICK.stopTiming();
    }

    @Redirect(method={"addServerStatsToSnooper"}, at=@At(value="FIELD", target="Lnet/minecraft/world/WorldServer;provider:Lnet/minecraft/world/WorldProvider;", opcode=180))
    private WorldProvider impl$getWorldProviderAndMaybeSetDimensionId(WorldServer world) {
        if (((WorldBridge)world).bridge$isFake() || world.func_72912_H() == null) {
            return ((net.minecraft.world.World)Sponge.getServer().getWorlds().iterator().next()).field_73011_w;
        }
        this.dimensionId = ((WorldServerBridge)world).bridge$getDimensionId();
        return world.field_73011_w;
    }

    @Redirect(method={"addServerStatsToSnooper"}, at=@At(value="INVOKE", target="Ljava/lang/Integer;valueOf(I)Ljava/lang/Integer;", ordinal=5))
    @Nullable
    private Integer onValueOfInteger(int original) {
        return this.dimensionId;
    }

    @ModifyConstant(method={"tick"}, constant={@Constant(intValue=900)})
    private int getSaveTickInterval(int tickInterval) {
        if (!this.func_71262_S()) {
            return tickInterval;
        }
        if (!this.func_71278_l()) {
            return this.field_71315_w + 1;
        }
        int autoPlayerSaveInterval = SpongeImpl.getGlobalConfigAdapter().getConfig().getWorld().getAutoPlayerSaveInterval();
        if (autoPlayerSaveInterval > 0 && this.field_71315_w % autoPlayerSaveInterval == 0) {
            this.func_184103_al().func_72389_g();
        }
        this.func_71267_a(true);
        return this.field_71315_w + 1;
    }

    @Overwrite
    public void func_71267_a(boolean dontLog) {
        if (!this.impl$enableSaving) {
            return;
        }
        for (WorldServer world : this.field_71305_c) {
            boolean log;
            boolean save = world.func_72863_F().func_73157_c();
            boolean bl2 = log = !dontLog;
            if (!save) continue;
            if (this.func_71262_S() && this.func_71278_l()) {
                SpongeConfig<WorldConfig> configAdapter = ((WorldInfoBridge)world.func_72912_H()).bridge$getConfigAdapter();
                int autoSaveInterval = configAdapter.getConfig().getWorld().getAutoSaveInterval();
                if (log) {
                    log = configAdapter.getConfig().getLogging().logWorldAutomaticSaving();
                }
                if (autoSaveInterval <= 0 || ((WorldProperties)world.func_72912_H()).getSerializationBehavior() != SerializationBehaviors.AUTOMATIC) {
                    if (!log) continue;
                    field_147145_h.warn("Auto-saving has been disabled for level '" + world.func_72912_H().func_76065_j() + "'/" + world.field_73011_w.func_186058_p().func_186065_b() + ". No chunk data will be auto-saved - to re-enable auto-saving set 'auto-save-interval' to a value greater than zero in the corresponding world config.");
                    continue;
                }
                if (this.field_71315_w % autoSaveInterval != 0) continue;
                if (log) {
                    field_147145_h.info("Auto-saving chunks for level '" + world.func_72912_H().func_76065_j() + "'/" + ((WorldServerBridge)world).bridge$getDimensionId());
                }
            } else if (log) {
                field_147145_h.info("Saving chunks for level '" + world.func_72912_H().func_76065_j() + "'/" + ((WorldServerBridge)world).bridge$getDimensionId());
            }
            try {
                WorldManager.saveWorld(world, false);
            }
            catch (MinecraftException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Inject(method={"stopServer"}, at={@At(value="HEAD")}, cancellable=true)
    private void onStopServer(CallbackInfo ci) {
        if (Sponge.isServerAvailable() && !((MinecraftServer)((Object)Sponge.getServer())).func_71278_l() && !Sponge.getServer().isMainThread()) {
            ci.cancel();
        }
    }

    @Overwrite
    public WorldServer func_71218_a(int dimensionId) {
        return WorldManager.getWorldByDimensionId(dimensionId).orElse(WorldManager.getWorldByDimensionId(0).orElseThrow(() -> new RuntimeException("Attempt made to get world before overworld is loaded!")));
    }

    @Redirect(method={"callFromMainThread"}, at=@At(value="INVOKE", target="Ljava/util/concurrent/Callable;call()Ljava/lang/Object;", remap=false))
    private Object impl$callOnMainThreadWithPhaseState(Callable<?> callable) throws Exception {
        Object value;
        if (this.field_71316_v && !SpongeImplHooks.isMainThread()) {
            return callable.call();
        }
        try (BasicPluginContext context = (BasicPluginContext)PluginPhase.State.SCHEDULED_TASK.createPhaseContext().source(callable);){
            context.buildAndSwitch();
            value = callable.call();
        }
        return value;
    }

    @Nullable
    @Redirect(method={"updateTimeLightAndEntities"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/Util;runTask(Ljava/util/concurrent/FutureTask;Lorg/apache/logging/log4j/Logger;)Ljava/lang/Object;"))
    private Object onRun(FutureTask<?> task, Logger logger) {
        return SpongeImplHooks.onUtilRunTask(task, logger);
    }

    @Inject(method={"addServerInfoToCrashReport"}, at={@At(value="RETURN")}, cancellable=true)
    private void onCrashReport(CrashReport report, CallbackInfoReturnable<CrashReport> cir) {
        report.func_85058_a("Sponge PhaseTracker").func_189529_a("Phase Stack", (ICrashReportDetail)CauseTrackerCrashHandler.INSTANCE);
        cir.setReturnValue(report);
    }

    @Overwrite
    public void func_147139_a(EnumDifficulty difficulty) {
        WorldManager.updateServerDifficulty();
    }
}

