/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.tileentity;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.data.meta.PatternLayer;
import org.spongepowered.api.data.type.BannerPatternShape;
import org.spongepowered.api.data.type.DyeColor;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.tileentity.TileEntityBannerBridge;
import org.spongepowered.common.data.meta.SpongePatternLayer;
import org.spongepowered.common.mixin.core.tileentity.TileEntityMixin;
import org.spongepowered.common.registry.SpongeGameRegistry;
import org.spongepowered.common.util.NonNullArrayList;

@NonnullByDefault
@Mixin(value={TileEntityBanner.class})
public abstract class TileEntityBannerMixin
extends TileEntityMixin
implements TileEntityBannerBridge {
    @Shadow
    private EnumDyeColor field_175120_a;
    @Shadow
    private NBTTagList field_175118_f;
    private List<PatternLayer> impl$patternLayers = Lists.newArrayList();

    @Inject(method={"setItemValues"}, at={@At(value="RETURN")})
    private void onSetItemValues(CallbackInfo ci) {
        this.impl$updatePatterns();
    }

    @Override
    public void bridge$readFromSpongeCompound(NBTTagCompound compound) {
        super.bridge$readFromSpongeCompound(compound);
        this.impl$updatePatterns();
    }

    private void impl$markDirtyAndUpdate() {
        this.shadow$func_70296_d();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            ((WorldServer)this.field_145850_b).func_184164_w().func_180244_a(this.func_174877_v());
        }
    }

    private void impl$updatePatterns() {
        this.impl$patternLayers.clear();
        if (this.field_175118_f != null) {
            SpongeGameRegistry registry = SpongeImpl.getRegistry();
            for (int i = 0; i < this.field_175118_f.func_74745_c(); ++i) {
                NBTTagCompound tagCompound = this.field_175118_f.func_150305_b(i);
                String patternId = tagCompound.func_74779_i("Pattern");
                int patternColor = tagCompound.func_74762_e("Color");
                this.impl$patternLayers.add(new SpongePatternLayer(registry.getType(BannerPatternShape.class, patternId).get(), registry.getType(DyeColor.class, EnumDyeColor.func_176766_a((int)patternColor).func_176610_l()).get()));
            }
        }
        this.impl$markDirtyAndUpdate();
    }

    @Override
    public List<PatternLayer> bridge$getLayers() {
        return new ArrayList<PatternLayer>(this.impl$patternLayers);
    }

    @Override
    public void bridge$setLayers(List<PatternLayer> layers) {
        this.impl$patternLayers = new NonNullArrayList<PatternLayer>();
        this.impl$patternLayers.addAll(layers);
        this.field_175118_f = new NBTTagList();
        for (PatternLayer layer : this.impl$patternLayers) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("Pattern", layer.getShape().getName());
            compound.func_74768_a("Color", ((EnumDyeColor)layer.getColor()).func_176767_b());
            this.field_175118_f.func_74742_a((NBTBase)compound);
        }
        this.impl$markDirtyAndUpdate();
    }

    @Override
    public DyeColor bridge$getBaseColor() {
        return (DyeColor)this.field_175120_a;
    }

    @Override
    public void bridge$setBaseColor(DyeColor baseColor) {
        Preconditions.checkNotNull(baseColor, "Null DyeColor!");
        try {
            EnumDyeColor color;
            this.field_175120_a = color = (EnumDyeColor)baseColor;
        }
        catch (Exception e) {
            this.field_175120_a = EnumDyeColor.BLACK;
        }
        this.impl$markDirtyAndUpdate();
    }
}

