/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.util.text.event;

import com.google.common.base.Preconditions;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.event.HoverEvent;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.util.text.ITextComponentBridge;
import org.spongepowered.common.bridge.util.text.event.HoverEventBridge;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;

@Mixin(value={HoverEvent.class})
public abstract class HoverEventMixin
implements HoverEventBridge {
    @Shadow
    @Final
    private HoverEvent.Action field_150704_a;
    @Shadow
    @Final
    private ITextComponent field_150703_b;
    private HoverAction<?> handle;
    private boolean initialized;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HoverAction<?> bridge$getHandle() {
        if (this.initialized) return this.handle;
        try {
            switch (this.field_150704_a) {
                case SHOW_TEXT: {
                    this.bridge$setHandle(TextActions.showText(((ITextComponentBridge)this.field_150703_b).bridge$toText()));
                    return this.handle;
                }
                case SHOW_ITEM: {
                    this.bridge$setHandle(TextActions.showItem(ItemStackUtil.snapshotOf(new ItemStack(this.loadNbt()))));
                    return this.handle;
                }
                case SHOW_ENTITY: {
                    NBTTagCompound nbt = this.loadNbt();
                    String name = nbt.func_74779_i("name");
                    EntityType type = null;
                    if (nbt.func_150297_b("type", 8)) {
                        type = SpongeImpl.getGame().getRegistry().getType(EntityType.class, name).orElse(null);
                    }
                    UUID uniqueId = UUID.fromString(nbt.func_74779_i("id"));
                    this.bridge$setHandle(TextActions.showEntity(uniqueId, name, type));
                    return this.handle;
                }
            }
            return this.handle;
        }
        finally {
            this.initialized = true;
        }
    }

    private NBTTagCompound loadNbt() {
        try {
            return Preconditions.checkNotNull(JsonToNBT.func_180713_a((String)this.field_150703_b.func_150260_c()), "NBT");
        }
        catch (NBTException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void bridge$setHandle(HoverAction<?> handle) {
        if (this.initialized) {
            return;
        }
        this.handle = Preconditions.checkNotNull(handle, "handle");
        this.initialized = true;
    }
}

