/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world;

import com.google.common.base.MoreObjects;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.Optional;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.PortalAgent;
import org.spongepowered.api.world.PortalAgentType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.world.TeleporterBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.registry.type.world.PortalAgentRegistryModule;
import org.spongepowered.common.util.VecHelper;

@Mixin(value={Teleporter.class})
public abstract class TeleporterMixin
implements TeleporterBridge {
    private boolean impl$createNetherPortal = true;
    private PortalAgentType impl$portalAgentType = PortalAgentRegistryModule.getInstance().validatePortalAgent(this);
    @Shadow
    @Final
    private WorldServer field_85192_a;
    @Shadow
    @Final
    private Long2ObjectMap<Teleporter.PortalPosition> field_85191_c;

    @Overwrite
    public void func_180266_a(Entity entityIn, float rotationYaw) {
        Location<org.spongepowered.api.world.World> targetLocation = ((org.spongepowered.api.entity.Entity)entityIn).getLocation();
        if (this.impl$createNetherPortal) {
            if (!this.func_180620_b(entityIn, rotationYaw)) {
                this.func_85188_a(entityIn);
                this.func_180620_b(entityIn, rotationYaw);
            }
        } else {
            this.createEndPortal(targetLocation);
            entityIn.func_70012_b(targetLocation.getX(), targetLocation.getY() - 1.0, targetLocation.getZ(), entityIn.field_70177_z, 0.0f);
            entityIn.field_70179_y = 0.0;
            entityIn.field_70181_x = 0.0;
            entityIn.field_70159_w = 0.0;
        }
    }

    @Override
    public void bridge$placeEntity(World world, Entity entity, float yaw) {
        boolean didPort;
        if (entity instanceof EntityPlayerMP) {
            this.func_180266_a(entity, yaw);
            didPort = true;
        } else {
            didPort = ((WorldServerBridge)this.field_85192_a).bridge$getDimensionId() == 1 ? true : this.func_180620_b(entity, yaw);
        }
        if (didPort) {
            PhaseTracker.getInstance().getCurrentState().markTeleported(PhaseTracker.getInstance().getCurrentContext());
        }
    }

    private void createEndPortal(Location<org.spongepowered.api.world.World> targetLocation) {
        int xTarget = targetLocation.getBlockX();
        int yTarget = targetLocation.getBlockY() - 1;
        int zTarget = targetLocation.getBlockZ();
        int l = 1;
        int i1 = 0;
        for (int j1 = -2; j1 <= 2; ++j1) {
            for (int k1 = -2; k1 <= 2; ++k1) {
                for (int l1 = -1; l1 < 3; ++l1) {
                    int x = xTarget + k1 * l + j1 * i1;
                    int y = yTarget + l1;
                    int z = zTarget + k1 * i1 - j1 * l;
                    boolean flag = l1 < 0;
                    this.field_85192_a.func_175656_a(new BlockPos(x, y, z), flag ? Blocks.field_150343_Z.func_176223_P() : Blocks.field_150350_a.func_176223_P());
                }
            }
        }
    }

    @Overwrite
    public boolean func_180620_b(Entity entityIn, float rotationYaw) {
        org.spongepowered.api.entity.Entity spongeEntity = (org.spongepowered.api.entity.Entity)entityIn;
        Optional<Location<org.spongepowered.api.world.World>> location = ((PortalAgent)((Object)this)).findPortal(spongeEntity.getLocation());
        if (location.isPresent()) {
            this.impl$handleEntityPortalExit(entityIn, location.get(), rotationYaw);
            return true;
        }
        return false;
    }

    private void impl$handleEntityPortalExit(Entity entityIn, Location<org.spongepowered.api.world.World> portalLocation, float rotationYaw) {
        BlockPos blockPos = VecHelper.toBlockPos(portalLocation);
        double xTarget = portalLocation.getX() + 0.5;
        double zTarget = portalLocation.getZ() + 0.5;
        BlockPattern.PatternHelper blockpattern$patternhelper = Blocks.field_150427_aO.func_181089_f((World)this.field_85192_a, blockPos);
        boolean flag1 = blockpattern$patternhelper.func_177669_b().func_176746_e().func_176743_c() == EnumFacing.AxisDirection.NEGATIVE;
        double d2 = blockpattern$patternhelper.func_177669_b().func_176740_k() == EnumFacing.Axis.X ? (double)blockpattern$patternhelper.func_181117_a().func_177952_p() : (double)blockpattern$patternhelper.func_181117_a().func_177958_n();
        double yTarget = (double)(blockpattern$patternhelper.func_181117_a().func_177956_o() + 1) - entityIn.func_181014_aG().field_72448_b * (double)blockpattern$patternhelper.func_181119_e();
        if (flag1) {
            d2 += 1.0;
        }
        if (blockpattern$patternhelper.func_177669_b().func_176740_k() == EnumFacing.Axis.X) {
            zTarget = d2 + (1.0 - entityIn.func_181014_aG().field_72450_a) * (double)blockpattern$patternhelper.func_181118_d() * (double)blockpattern$patternhelper.func_177669_b().func_176746_e().func_176743_c().func_179524_a();
        } else {
            xTarget = d2 + (1.0 - entityIn.func_181014_aG().field_72450_a) * (double)blockpattern$patternhelper.func_181118_d() * (double)blockpattern$patternhelper.func_177669_b().func_176746_e().func_176743_c().func_179524_a();
        }
        float f = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (blockpattern$patternhelper.func_177669_b().func_176734_d() == entityIn.func_181012_aH()) {
            f = 1.0f;
            f1 = 1.0f;
        } else if (blockpattern$patternhelper.func_177669_b().func_176734_d() == entityIn.func_181012_aH().func_176734_d()) {
            f = -1.0f;
            f1 = -1.0f;
        } else if (blockpattern$patternhelper.func_177669_b().func_176734_d() == entityIn.func_181012_aH().func_176746_e()) {
            f2 = 1.0f;
            f3 = -1.0f;
        } else {
            f2 = -1.0f;
            f3 = 1.0f;
        }
        double d3 = entityIn.field_70159_w;
        double d4 = entityIn.field_70179_y;
        entityIn.field_70159_w = d3 * (double)f + d4 * (double)f3;
        entityIn.field_70179_y = d3 * (double)f2 + d4 * (double)f1;
        entityIn.field_70177_z = rotationYaw - (float)(entityIn.func_181012_aH().func_176734_d().func_176736_b() * 90) + (float)(blockpattern$patternhelper.func_177669_b().func_176736_b() * 90);
        entityIn.func_70012_b(xTarget, yTarget, zTarget, entityIn.field_70177_z, entityIn.field_70125_A);
    }

    @Overwrite
    public boolean func_85188_a(Entity entityIn) {
        return ((PortalAgent)((Object)this)).createPortal(((org.spongepowered.api.entity.Entity)entityIn).getLocation()).isPresent();
    }

    @Override
    public void bridge$removePortalPositionFromCache(Long portalPosition) {
        this.field_85191_c.remove(portalPosition);
    }

    @Override
    public void bridge$setPortalAgentType(PortalAgentType type) {
        this.impl$portalAgentType = type;
    }

    @Override
    public void bridge$setNetherPortalType(boolean isNetherPortal) {
        this.impl$createNetherPortal = isNetherPortal;
    }

    @Override
    public PortalAgentType bridge$getPortalAgentType() {
        return this.impl$portalAgentType;
    }

    public String toString() {
        return MoreObjects.toStringHelper("PortalAgent").add("type", this.impl$portalAgentType).add("searchRadius", ((PortalAgent)((Object)this)).getSearchRadius()).add("creationRadius", ((PortalAgent)((Object)this)).getCreationRadius()).add("world", this.field_85192_a.func_72912_H().func_76065_j()).add("dimensionId", ((WorldServerBridge)this.field_85192_a).bridge$getDimensionId()).toString();
    }
}

