/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world;

import com.google.common.base.Predicate;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockJukebox;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.profiler.Profiler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.storage.WorldInfo;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.property.item.RecordProperty;
import org.spongepowered.api.effect.sound.record.RecordType;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.entity.CollideEntityEvent;
import org.spongepowered.api.event.sound.PlaySoundEvent;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.Surrogate;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.bridge.data.VanishableBridge;
import org.spongepowered.common.bridge.entity.EntityBridge;
import org.spongepowered.common.bridge.entity.player.EntityPlayerBridge;
import org.spongepowered.common.bridge.tileentity.TileEntityBridge;
import org.spongepowered.common.bridge.util.math.BlockPosBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.WorldProviderBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.bridge.world.chunk.ActiveChunkReferantBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkProviderBridge;
import org.spongepowered.common.data.type.SpongeTileEntityType;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.relocate.co.aikar.timings.TimingHistory;
import org.spongepowered.common.util.SpongeHooks;
import org.spongepowered.common.world.SpongeEmptyChunk;

@Mixin(value={World.class})
public abstract class WorldMixin
implements WorldBridge {
    private boolean impl$isDefinitelyFake = false;
    private boolean impl$hasChecked = false;
    @Nullable
    private SpongeEmptyChunk impl$emptyChunk;
    @Shadow
    @Final
    public boolean field_72995_K;
    @Shadow
    @Final
    public WorldProvider field_73011_w;
    @Shadow
    @Final
    public Random field_73012_v;
    @Shadow
    @Final
    public Profiler field_72984_F;
    @Shadow
    @Final
    public List<EntityPlayer> field_73010_i;
    @Shadow
    @Final
    public List<Entity> field_72996_f;
    @Shadow
    @Final
    public List<Entity> field_73007_j;
    @Shadow
    @Final
    protected List<Entity> field_72997_g;
    @Shadow
    @Final
    public List<TileEntity> field_147482_g;
    @Shadow
    @Final
    public List<TileEntity> field_175730_i;
    @Shadow
    @Final
    private List<TileEntity> field_147483_b;
    @Shadow
    @Final
    private List<TileEntity> field_147484_a;
    @Shadow
    protected int[] field_72994_J;
    @Shadow
    private boolean field_147481_N;
    @Shadow
    protected boolean field_72999_e;
    @Shadow
    protected WorldInfo field_72986_A;
    @Shadow
    protected IChunkProvider field_73020_y;
    @Shadow
    @Final
    private WorldBorder field_175728_M;
    @Shadow
    protected int field_73005_l;

    @Shadow
    protected abstract void func_184147_l();

    @Shadow
    public World func_175643_b() {
        throw new RuntimeException("Bad things have happened");
    }

    @Shadow
    public abstract int func_175699_k(BlockPos var1);

    @Shadow
    public abstract int func_175721_c(BlockPos var1, boolean var2);

    @Shadow
    protected abstract int func_175638_a(BlockPos var1, EnumSkyBlock var2);

    @Shadow
    public abstract int func_175657_ab();

    @Shadow
    @Nullable
    public abstract Chunk func_175726_f(BlockPos var1);

    @Shadow
    public abstract WorldInfo func_72912_H();

    @Shadow
    public abstract boolean func_180500_c(EnumSkyBlock var1, BlockPos var2);

    @Shadow
    public abstract boolean func_175700_a(TileEntity var1);

    @Shadow
    protected abstract void func_72923_a(Entity var1);

    @Shadow
    public abstract boolean func_175648_a(BlockPos var1, int var2, boolean var3);

    @Shadow
    protected abstract void func_72847_b(Entity var1);

    @Shadow
    public abstract void func_72870_g(Entity var1);

    @Shadow
    public abstract boolean func_175667_e(BlockPos var1);

    @Shadow
    public void func_175646_b(BlockPos pos, TileEntity unusedTileEntity) {
    }

    @Shadow
    public abstract boolean func_72942_c(Entity var1);

    @Shadow
    public abstract Biome func_180494_b(BlockPos var1);

    @Shadow
    public abstract Chunk func_72964_e(int var1, int var2);

    @Shadow
    public abstract List<Entity> func_175644_a(Class<Entity> var1, Predicate<Entity> var2);

    @Shadow
    public abstract <T extends Entity> List<T> func_175647_a(Class<? extends T> var1, AxisAlignedBB var2, Predicate<? super T> var3);

    @Shadow
    public abstract MinecraftServer func_73046_m();

    @Shadow
    public abstract boolean func_72838_d(Entity var1);

    @Shadow
    public abstract void func_72854_c();

    @Shadow
    public abstract boolean func_175656_a(BlockPos var1, IBlockState var2);

    @Shadow
    public abstract boolean func_180501_a(BlockPos var1, IBlockState var2, int var3);

    @Shadow
    public abstract void func_175666_e(BlockPos var1, Block var2);

    @Shadow
    public abstract void func_190524_a(BlockPos var1, Block var2, BlockPos var3);

    @Shadow
    public void func_190529_b(BlockPos pos, Block changedBlock, BlockPos changedBlockPos) {
    }

    @Shadow
    public abstract void func_175695_a(BlockPos var1, Block var2, EnumFacing var3);

    @Shadow
    public abstract void func_190522_c(BlockPos var1, Block var2);

    @Shadow
    public abstract void func_175722_b(BlockPos var1, Block var2, boolean var3);

    @Shadow
    public abstract void func_175685_c(BlockPos var1, Block var2, boolean var3);

    @Shadow
    public abstract void func_184138_a(BlockPos var1, IBlockState var2, IBlockState var3, int var4);

    @Shadow
    public abstract void func_175654_a(BlockPos var1, Block var2, int var3, int var4);

    @Shadow
    public abstract void func_184148_a(EntityPlayer var1, double var2, double var4, double var6, SoundEvent var8, SoundCategory var9, float var10, float var11);

    @Shadow
    protected abstract void func_147456_g();

    @Shadow
    public abstract GameRules shadow$func_82736_K();

    @Shadow
    public abstract boolean func_72896_J();

    @Shadow
    public abstract boolean func_72911_I();

    @Shadow
    public abstract boolean func_175727_C(BlockPos var1);

    @Shadow
    public abstract DifficultyInstance func_175649_E(BlockPos var1);

    @Shadow
    public abstract BlockPos func_175725_q(BlockPos var1);

    @Shadow
    public abstract boolean func_175662_w(BlockPos var1);

    @Shadow
    public abstract boolean func_175708_f(BlockPos var1, boolean var2);

    @Shadow
    public abstract void func_175679_n(BlockPos var1);

    @Shadow
    @Nullable
    private TileEntity func_189508_F(BlockPos p_189508_1_) {
        return null;
    }

    @Shadow
    public abstract int func_189649_b(int var1, int var2);

    @Shadow
    public boolean func_175655_b(BlockPos pos, boolean dropBlock) {
        return false;
    }

    @Shadow
    public abstract void func_175718_b(int var1, BlockPos var2, int var3);

    @Shadow
    public abstract WorldBorder func_175723_af();

    @Shadow
    public boolean func_175678_i(BlockPos pos) {
        return false;
    }

    @Shadow
    public abstract long func_82737_E();

    @Shadow
    private boolean func_175663_a(int xStart, int yStart, int zStart, int xEnd, int yEnd, int zEnd, boolean allowEmpty) {
        return false;
    }

    @Shadow
    public void func_72939_s() {
    }

    @Shadow
    @Nullable
    public abstract TileEntity func_175625_s(BlockPos var1);

    @Shadow
    protected abstract boolean func_191504_a(@Nullable Entity var1, AxisAlignedBB var2, boolean var3, @Nullable List<AxisAlignedBB> var4);

    @Shadow
    public abstract List<Entity> func_72839_b(@Nullable Entity var1, AxisAlignedBB var2);

    @Shadow
    public abstract IChunkProvider shadow$func_72863_F();

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/WorldProvider;createWorldBorder()Lnet/minecraft/world/border/WorldBorder;"))
    private WorldBorder onCreateWorldBorder(WorldProvider provider) {
        if (this.bridge$isFake()) {
            return provider.func_177501_r();
        }
        return ((WorldProviderBridge)provider).bridge$createServerWorldBorder();
    }

    @Inject(method={"getCollisionBoxes(Lnet/minecraft/entity/Entity;Lnet/minecraft/util/math/AxisAlignedBB;)Ljava/util/List;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetCollisionBoxes(Entity entity, AxisAlignedBB axis, CallbackInfoReturnable<List<AxisAlignedBB>> cir) {
        if (this.bridge$isFake() || entity == null) {
            return;
        }
        if (entity.field_70170_p != null && !((WorldBridge)entity.field_70170_p).bridge$isFake() && SpongeHooks.checkBoundingBoxSize(entity, axis)) {
            cir.setReturnValue(new ArrayList());
        }
    }

    @Overwrite
    public List<AxisAlignedBB> func_184144_a(@Nullable Entity entityIn, AxisAlignedBB aabb) {
        ArrayList<AxisAlignedBB> list = Lists.newArrayList();
        this.func_191504_a(entityIn, aabb, false, list);
        if (entityIn != null) {
            ArrayList<Entity> collidedEntities;
            CollideEntityEvent event;
            List<Entity> entities = this.func_72839_b(entityIn, aabb.func_186662_g(0.25));
            LinkedHashMultimap<Entity, AxisAlignedBB> entityCollisions = LinkedHashMultimap.create();
            for (int i = 0; i < entities.size(); ++i) {
                Entity entity = entities.get(i);
                if (entityIn.func_184223_x(entity)) continue;
                AxisAlignedBB axisalignedbb = entity.func_70046_E();
                if (axisalignedbb != null && axisalignedbb.func_72326_a(aabb)) {
                    entityCollisions.put(entity, axisalignedbb);
                }
                if ((axisalignedbb = entityIn.func_70114_g(entity)) == null || !axisalignedbb.func_72326_a(aabb)) continue;
                entityCollisions.put(entity, axisalignedbb);
            }
            if (!entityCollisions.isEmpty() && (event = SpongeCommonEventFactory.callCollideEntityEvent((World)this, entityIn, collidedEntities = new ArrayList<Entity>(entityCollisions.keySet()))) != null && !event.isCancelled()) {
                entityCollisions.keySet().retainAll(collidedEntities);
                list.addAll(entityCollisions.values());
            }
        }
        SpongeImplHooks.onForgeCollision((World)this, entityIn, aabb, list);
        return list;
    }

    @Inject(method={"onEntityAdded"}, at={@At(value="TAIL")})
    private void onEntityAddedToWorldMarkAsTracked(Entity entityIn, CallbackInfo ci) {
        if (!this.bridge$isFake()) {
            ((EntityBridge)entityIn).bridge$setWorldTracked(true);
        }
    }

    @Inject(method={"onEntityRemoved"}, at={@At(value="TAIL")})
    private void onEntityRemovedFromWorldMarkAsUntracked(Entity entityIn, CallbackInfo ci) {
        if (!this.bridge$isFake() || ((EntityBridge)entityIn).bridge$isWorldTracked()) {
            ((EntityBridge)entityIn).bridge$setWorldTracked(false);
        }
    }

    @Nullable
    @Redirect(method={"removeTileEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getTileEntity(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/tileentity/TileEntity;"))
    protected TileEntity getTileEntityForRemoval(World world, BlockPos pos) {
        return world.func_175625_s(pos);
    }

    @Inject(method={"removeTileEntity"}, at={@At(value="JUMP", opcode=198)}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/World;getTileEntity(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/tileentity/TileEntity;"), to=@At(value="FIELD", target="Lnet/minecraft/world/World;processingLoadedTiles:Z", opcode=180))}, locals=LocalCapture.CAPTURE_FAILEXCEPTION, cancellable=true)
    protected void onCheckTileEntityForRemoval(BlockPos pos, CallbackInfo ci, TileEntity found, World thisWorld, BlockPos samePos) {
    }

    @Redirect(method={"setTileEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/tileentity/TileEntity;isInvalid()Z"))
    protected boolean onSetTileEntityForCapture(TileEntity tileEntity, BlockPos pos, TileEntity sameEntity) {
        return tileEntity.func_145837_r();
    }

    @Override
    public boolean bridge$isFake() {
        if (this.impl$hasChecked) {
            return this.impl$isDefinitelyFake;
        }
        this.impl$isDefinitelyFake = this.field_72995_K || this.field_72986_A == null || this.field_72986_A.func_76065_j() == null || !(this instanceof WorldServerBridge);
        this.impl$hasChecked = true;
        return this.impl$isDefinitelyFake;
    }

    @Override
    public void bridge$clearFakeCheck() {
        this.impl$hasChecked = false;
    }

    @Redirect(method={"isAnyPlayerWithinRangeAt"}, at=@At(value="INVOKE", target="Lcom/google/common/base/Predicate;apply(Ljava/lang/Object;)Z", remap=false))
    private boolean onIsAnyPlayerWithinRangePredicate(Predicate<EntityPlayer> predicate, Object object) {
        EntityPlayer player = (EntityPlayer)object;
        return !player.field_70128_L && ((EntityPlayerBridge)player).bridge$affectsSpawning() && predicate.apply(player);
    }

    @Redirect(method={"checkNoEntityCollision(Lnet/minecraft/util/math/AxisAlignedBB;Lnet/minecraft/entity/Entity;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getEntitiesWithinAABBExcludingEntity(Lnet/minecraft/entity/Entity;Lnet/minecraft/util/math/AxisAlignedBB;)Ljava/util/List;"))
    private List<Entity> impl$filterInvisibile(World world, Entity entityIn, AxisAlignedBB axisAlignedBB) {
        List entities = world.func_72839_b(entityIn, axisAlignedBB);
        entities.removeIf(entity -> ((VanishableBridge)entity).bridge$isVanished() && ((VanishableBridge)entity).bridge$isUncollideable());
        return entities;
    }

    @Redirect(method={"getClosestPlayer(DDDDLcom/google/common/base/Predicate;)Lnet/minecraft/entity/player/EntityPlayer;"}, at=@At(value="INVOKE", target="Lcom/google/common/base/Predicate;apply(Ljava/lang/Object;)Z", remap=false))
    private boolean impl$checkIfPlayerIsVanished(Predicate<Entity> predicate, Object entityPlayer) {
        return predicate.apply((Entity)((EntityPlayer)entityPlayer)) && !((VanishableBridge)entityPlayer).bridge$isVanished();
    }

    @Inject(method={"playSound(Lnet/minecraft/entity/player/EntityPlayer;DDDLnet/minecraft/util/SoundEvent;Lnet/minecraft/util/SoundCategory;FF)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$spongePlaySoundAtEntity(@Nullable EntityPlayer entity, double x, double y, double z, SoundEvent name, SoundCategory category, float volume, float pitch, CallbackInfo callbackInfo) {
        if (entity instanceof EntityBridge && ((VanishableBridge)entity).bridge$isVanished()) {
            callbackInfo.cancel();
            return;
        }
        if (this.bridge$isFake()) {
            return;
        }
        if (ShouldFire.PLAY_SOUND_EVENT_AT_ENTITY) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                PlaySoundEvent.AtEntity event = SpongeCommonEventFactory.callPlaySoundAtEntityEvent(frame.getCurrentCause(), entity, this, x, y, z, category, name, pitch, volume);
                if (event.isCancelled()) {
                    callbackInfo.cancel();
                }
            }
        }
    }

    @Inject(method={"playBroadcastSound(ILnet/minecraft/util/math/BlockPos;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$throwBroadcastSoundEvent(int effectID, BlockPos pos, int soundData, CallbackInfo callbackInfo) {
        if (!this.bridge$isFake() && ShouldFire.PLAY_SOUND_EVENT_BROADCAST) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                PlaySoundEvent.Broadcast event = SpongeCommonEventFactory.callPlaySoundBroadcastEvent(frame, this, pos, effectID);
                if (event != null && event.isCancelled()) {
                    callbackInfo.cancel();
                }
            }
        }
    }

    @Inject(method={"playEvent(Lnet/minecraft/entity/player/EntityPlayer;ILnet/minecraft/util/math/BlockPos;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$throwRecordPlayEvent(EntityPlayer player, int type, BlockPos pos, int data, CallbackInfo callbackInfo) {
        if (this.bridge$isFake()) {
            return;
        }
        if (type == 1010 && ShouldFire.PLAY_SOUND_EVENT_RECORD) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                TileEntity tileEntity = this.func_175625_s(pos);
                if (tileEntity instanceof BlockJukebox.TileEntityJukebox) {
                    BlockJukebox.TileEntityJukebox jukebox = (BlockJukebox.TileEntityJukebox)tileEntity;
                    net.minecraft.item.ItemStack record = jukebox.func_145856_a();
                    frame.pushCause(jukebox);
                    frame.addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(record));
                    if (!record.func_190926_b()) {
                        Optional<RecordProperty> recordProperty = ((ItemStack)record).getProperty(RecordProperty.class);
                        if (!recordProperty.isPresent()) {
                            return;
                        }
                        RecordType recordType = (RecordType)recordProperty.get().getValue();
                        PlaySoundEvent.Record event = SpongeCommonEventFactory.callPlaySoundRecordEvent(frame.getCurrentCause(), jukebox, recordType, data);
                        if (event.isCancelled()) {
                            callbackInfo.cancel();
                        }
                    }
                }
            }
        }
    }

    @Inject(method={"destroyBlock"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;playEvent(ILnet/minecraft/util/math/BlockPos;I)V")}, cancellable=true)
    public void onDestroyBlock(BlockPos pos, boolean dropBlock, CallbackInfoReturnable<Boolean> cir) {
    }

    @Redirect(method={"updateEntities"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;onUpdate()V"))
    protected void onUpdateWeatherEffect(Entity entityIn) {
        entityIn.func_70071_h_();
    }

    @Redirect(method={"updateEntities"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/ITickable;update()V"))
    protected void onUpdateTileEntities(ITickable tile) {
        tile.func_73660_a();
    }

    @Redirect(method={"updateEntityWithOptionalForce"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;onUpdate()V"))
    protected void onCallEntityUpdate(Entity entity) {
        entity.func_70071_h_();
    }

    @Redirect(method={"updateEntityWithOptionalForce"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;updateRidden()V"))
    protected void onCallEntityRidingUpdate(Entity entity) {
        entity.func_70098_U();
    }

    @Redirect(method={"updateEntityWithOptionalForce"}, at=@At(value="FIELD", target="Lnet/minecraft/entity/Entity;addedToChunk:Z", opcode=180), slice=@Slice(from=@At(value="FIELD", target="Lnet/minecraft/entity/Entity;chunkCoordX:I", opcode=180, ordinal=0), to=@At(value="FIELD", target="Lnet/minecraft/entity/Entity;chunkCoordX:I", opcode=180, ordinal=1)))
    private boolean impl$returnTrueToAddedToChunkForMovingEntities(Entity entity) {
        Chunk activeChunk = (Chunk)((ActiveChunkReferantBridge)entity).bridge$getActiveChunk();
        if (activeChunk != null) {
            activeChunk.func_76608_a(entity, entity.field_70162_ai);
        }
        int l = MathHelper.func_76128_c((double)(entity.field_70165_t / 16.0));
        int j1 = MathHelper.func_76128_c((double)(entity.field_70161_v / 16.0));
        ChunkBridge newChunk = (ChunkBridge)((ChunkProviderBridge)this.shadow$func_72863_F()).bridge$getLoadedChunkWithoutMarkingActive(l, j1);
        boolean isPositionDirty = entity.func_184189_br();
        if (newChunk == null || !isPositionDirty && newChunk.bridge$isQueuedForUnload() && !newChunk.bridge$isPersistedChunk()) {
            entity.field_70175_ag = false;
        } else {
            ((Chunk)newChunk).func_76612_a(entity);
        }
        return false;
    }

    @Redirect(method={"updateEntityWithOptionalForce"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;isChunkLoaded(IIZ)Z"), slice=@Slice(from=@At(value="CONSTANT", args={"doubleValue=16.0D"}), to=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/Chunk;removeEntityAtIndex(Lnet/minecraft/entity/Entity;I)V")))
    private boolean impl$returnFalseForChunkLoadedToAvoidIf(World world, int x, int z, boolean allowEmpty) {
        return false;
    }

    @Redirect(method={"updateEntityWithOptionalForce"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;isChunkLoaded(IIZ)Z"), slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;setPositionNonDirty()Z"), to=@At(value="FIELD", target="Lnet/minecraft/entity/Entity;addedToChunk:Z", opcode=181)))
    private boolean impl$returnChunkLoadedAlways(World world, int x, int z, boolean allowEmpty) {
        return true;
    }

    @Redirect(method={"updateEntityWithOptionalForce"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getChunk(II)Lnet/minecraft/world/chunk/Chunk;"), slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;setPositionNonDirty()Z"), to=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/Chunk;addEntity(Lnet/minecraft/entity/Entity;)V")))
    private Chunk impl$returnEmptyChunk(World world, int chunkX, int chunkZ) {
        return this.bridge$getEmptyChunk();
    }

    @Override
    public SpongeEmptyChunk bridge$getEmptyChunk() {
        if (this.impl$emptyChunk == null) {
            this.impl$emptyChunk = new SpongeEmptyChunk((World)this, 0, 0);
        }
        return this.impl$emptyChunk;
    }

    @Inject(method={"updateEntityWithOptionalForce"}, at={@At(value="FIELD", target="Lnet/minecraft/entity/Entity;ticksExisted:I", opcode=181, shift=At.Shift.AFTER)})
    private void impl$increaseActivatedEntityTicks(Entity entityIn, boolean forceUpdate, CallbackInfo ci) {
        ++TimingHistory.activatedEntityTicks;
    }

    @Redirect(method={"addTileEntity"}, at=@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", remap=false), slice=@Slice(from=@At(value="FIELD", target="Lnet/minecraft/world/World;tickableTileEntities:Ljava/util/List;"), to=@At(value="FIELD", target="Lnet/minecraft/world/World;isRemote:Z")))
    private boolean onAddTileEntity(List<? super TileEntity> list, Object tile) {
        if (!this.bridge$isFake() && !this.canTileUpdate((TileEntity)tile)) {
            return false;
        }
        return list.add((TileEntity)((TileEntity)tile));
    }

    private boolean canTileUpdate(TileEntity tile) {
        org.spongepowered.api.block.tileentity.TileEntity spongeTile = (org.spongepowered.api.block.tileentity.TileEntity)tile;
        return spongeTile.getType() == null || ((SpongeTileEntityType)spongeTile.getType()).canTick();
    }

    @Inject(method={"getPlayerEntityByUUID"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetPlayerEntityByUUID(@Nullable UUID uuid, CallbackInfoReturnable<UUID> cir) {
        if (uuid == null) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"getRawLight"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;getBlockState(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/state/IBlockState;")}, cancellable=true)
    protected void impl$getRawLightWithoutMarkingChunkActive(BlockPos pos, EnumSkyBlock enumSkyBlock, CallbackInfoReturnable<Integer> cir) {
        Chunk chunk = this.func_175726_f(pos);
        if (chunk == null || chunk.field_189550_d) {
            cir.setReturnValue(0);
        }
    }

    @Overwrite
    public IBlockState func_180495_p(BlockPos pos) {
        if (((BlockPosBridge)pos).bridge$isInvalidYPosition()) {
            return Blocks.field_150350_a.func_176223_P();
        }
        Chunk chunk = this.func_175726_f(pos);
        return chunk.func_177435_g(pos);
    }

    @Redirect(method={"getTileEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;isOutsideBuildHeight(Lnet/minecraft/util/math/BlockPos;)Z"))
    private boolean impl$useInlinedMethodInsteadisoutsideBuildHeight(World world, BlockPos pos) {
        return ((BlockPosBridge)pos).bridge$isInvalidYPosition();
    }

    @Inject(method={"getTileEntity"}, at={@At(value="FIELD", target="Lnet/minecraft/world/World;processingLoadedTiles:Z")}, cancellable=true)
    private void impl$checkForAsync(BlockPos pos, CallbackInfoReturnable<TileEntity> cir) {
        if (!this.bridge$isFake() && !SpongeImpl.getServer().func_152345_ab()) {
            cir.setReturnValue(this.func_175726_f(pos).func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK));
            return;
        }
        if (this.isTileMarkedForRemoval(pos) && !this.bridge$isFake()) {
            if (PhaseTracker.getInstance().getCurrentState().allowsGettingQueuedRemovedTiles()) {
                cir.setReturnValue(this.getQueuedRemovedTileFromProxy(pos));
                return;
            }
            cir.setReturnValue(null);
        }
    }

    @Redirect(method={"getTileEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/Chunk;getTileEntity(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/world/chunk/Chunk$EnumCreateEntityType;)Lnet/minecraft/tileentity/TileEntity;"))
    @Nullable
    TileEntity impl$getTileOrNullIfMarkedForRemoval(Chunk chunk, BlockPos pos, Chunk.EnumCreateEntityType creationMode) {
        return chunk.func_177424_a(pos, Chunk.EnumCreateEntityType.IMMEDIATE);
    }

    @Nullable
    protected TileEntity getQueuedRemovedTileFromProxy(BlockPos pos) {
        return null;
    }

    protected boolean isTileMarkedAsNull(BlockPos pos, @Nullable TileEntity tileentity) {
        return false;
    }

    protected boolean isTileMarkedForRemoval(BlockPos pos) {
        return false;
    }

    @Nullable
    protected TileEntity getProcessingTileFromProxy(BlockPos pos) {
        return null;
    }

    @Redirect(method={"checkLightFor"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;isAreaLoaded(Lnet/minecraft/util/math/BlockPos;IZ)Z"))
    protected boolean spongeIsAreaLoadedForCheckingLight(World thisWorld, BlockPos pos, int radius, boolean allowEmtpy, EnumSkyBlock lightType, BlockPos samePosition) {
        return this.func_175648_a(pos, radius, allowEmtpy);
    }

    @Overwrite
    public boolean func_175701_a(BlockPos pos) {
        return ((BlockPosBridge)pos).bridge$isValidPosition();
    }

    @Overwrite
    private boolean func_189509_E(BlockPos pos) {
        return ((BlockPosBridge)pos).bridge$isInvalidYPosition();
    }

    @Overwrite
    public int func_175642_b(EnumSkyBlock type, BlockPos pos) {
        if (pos.func_177956_o() < 0) {
            pos = new BlockPos(pos.func_177958_n(), 0, pos.func_177952_p());
        }
        if (!((BlockPosBridge)pos).bridge$isValidPosition()) {
            return type.field_77198_c;
        }
        Chunk chunk = this.func_175726_f(pos);
        return chunk.func_177413_a(type, pos);
    }

    @Overwrite
    public void func_175653_a(EnumSkyBlock type, BlockPos pos, int lightValue) {
        if (((BlockPosBridge)pos).bridge$isValidPosition() && this.func_175667_e(pos)) {
            Chunk chunk = this.func_175726_f(pos);
            chunk.func_177431_a(type, pos, lightValue);
            this.func_175679_n(pos);
        }
    }

    @Inject(method={"isAreaLoaded(IIIIIIZ)Z"}, at={@At(value="HEAD")}, cancellable=true)
    protected void impl$useWorldServerMethodForAvoidingLookups(int xStart, int yStart, int zStart, int xEnd, int yEnd, int zEnd, boolean allowEmpty, CallbackInfoReturnable<Boolean> cir) {
    }

    @Override
    public boolean bridge$isAreaLoaded(int xStart, int yStart, int zStart, int xEnd, int yEnd, int zEnd, boolean allowEmpty) {
        return this.func_175663_a(xStart, yStart, zStart, xEnd, yEnd, zEnd, allowEmpty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    public boolean func_184143_b(AxisAlignedBB bbox) {
        ArrayList list = Lists.newArrayList();
        int i = MathHelper.func_76128_c((double)bbox.field_72340_a) - 1;
        int j = MathHelper.func_76143_f((double)bbox.field_72336_d) + 1;
        int k = MathHelper.func_76128_c((double)bbox.field_72338_b) - 1;
        int l = MathHelper.func_76143_f((double)bbox.field_72337_e) + 1;
        int i1 = MathHelper.func_76128_c((double)bbox.field_72339_c) - 1;
        int j1 = MathHelper.func_76143_f((double)bbox.field_72334_f) + 1;
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        try {
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = i1; l1 < j1; ++l1) {
                    int i2 = (k1 != i && k1 != j - 1 ? 0 : 1) + (l1 != i1 && l1 != j1 - 1 ? 0 : 1);
                    if (i2 == 2 || !this.func_175667_e((BlockPos)blockpos$pooledmutableblockpos.func_181079_c(k1, 64, l1))) continue;
                    for (int j2 = k; j2 < l; ++j2) {
                        if (i2 > 0 && (j2 == k || j2 == l - 1)) continue;
                        blockpos$pooledmutableblockpos.func_181079_c(k1, j2, l1);
                        if (!((BlockPosBridge)blockpos$pooledmutableblockpos).bridge$isValidXZPosition()) {
                            boolean bl2 = true;
                            return bl2;
                        }
                        IBlockState iblockstate = this.func_180495_p((BlockPos)blockpos$pooledmutableblockpos);
                        iblockstate.func_185908_a((World)this, (BlockPos)blockpos$pooledmutableblockpos, bbox, list, (Entity)null, false);
                        if (list.isEmpty()) continue;
                        boolean bl3 = true;
                        return bl3;
                    }
                }
            }
            boolean bl4 = false;
            return bl4;
        }
        finally {
            blockpos$pooledmutableblockpos.func_185344_t();
        }
    }

    @Inject(method={"updateEntities"}, at={@At(value="INVOKE", target="Lnet/minecraft/profiler/Profiler;startSection(Ljava/lang/String;)V", shift=At.Shift.AFTER)}, slice={@Slice(from=@At(value="CONSTANT", args={"stringValue=global"}), to=@At(value="FIELD", target="Lnet/minecraft/world/World;weatherEffects:Ljava/util/List;", ordinal=0))})
    void impl$startEntityGlobalTimings(CallbackInfo ci) {
    }

    @Inject(method={"updateEntities"}, at={@At(value="INVOKE", target="Lnet/minecraft/crash/CrashReport;makeCrashReport(Ljava/lang/Throwable;Ljava/lang/String;)Lnet/minecraft/crash/CrashReport;", ordinal=0)}, locals=LocalCapture.CAPTURE_FAILHARD)
    void impl$stopTimingForWeatherEntityTickCrash(CallbackInfo ci, int index, Entity entity, Throwable throwable) {
    }

    @Inject(method={"updateEntities"}, at={@At(value="INVOKE", target="Lnet/minecraft/profiler/Profiler;endStartSection(Ljava/lang/String;)V", shift=At.Shift.BEFORE, by=2)}, slice={@Slice(from=@At(value="CONSTANT", args={"stringValue=remove"}), to=@At(value="FIELD", target="Lnet/minecraft/world/World;unloadedEntityList:Ljava/util/List;", opcode=180, ordinal=0))})
    void impl$stopEntityTickTiming(CallbackInfo ci) {
    }

    @Redirect(method={"updateEntities"}, at=@At(value="FIELD", target="Lnet/minecraft/entity/Entity;addedToChunk:Z"))
    private boolean impl$ReturnFalseUseActiveChunkReferant(Entity entity) {
        int l1 = entity.field_70176_ah;
        int i2 = entity.field_70164_aj;
        Chunk activeChunk = (Chunk)((ActiveChunkReferantBridge)entity).bridge$getActiveChunk();
        if (activeChunk == null) {
            this.func_72964_e(l1, i2).func_76622_b(entity);
        } else {
            activeChunk.func_76622_b(entity);
        }
        return false;
    }

    @Inject(method={"updateEntities"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;tickPlayers()V")})
    void impl$stopEntityRemovalTiming(CallbackInfo ci) {
    }

    @Inject(method={"updateEntities"}, at={@At(value="INVOKE", target="Lnet/minecraft/profiler/Profiler;endStartSection(Ljava/lang/String;)V", shift=At.Shift.AFTER)}, slice={@Slice(from=@At(value="CONSTANT", args={"stringValue=regular"}), to=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;getRidingEntity()Lnet/minecraft/entity/Entity;"))})
    protected void impl$entityActivationCheck(CallbackInfo ci) {
    }

    @Inject(method={"updateEntities"}, at={@At(value="INVOKE", target="Lnet/minecraft/profiler/Profiler;startSection(Ljava/lang/String;)V", shift=At.Shift.AFTER)}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;dismountRidingEntity()V"), to=@At(value="INVOKE", target="Lnet/minecraft/world/World;updateEntity(Lnet/minecraft/entity/Entity;)V"))})
    void impl$startEntityTickingForTick(CallbackInfo ci) {
    }

    @Inject(method={"updateEntities"}, at={@At(value="INVOKE", target="Lnet/minecraft/crash/CrashReport;makeCrashReport(Ljava/lang/Throwable;Ljava/lang/String;)Lnet/minecraft/crash/CrashReport;")}, slice={@Slice(from=@At(value="CONSTANT", args={"stringValue=Ticking entity"}, ordinal=1), to=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;addEntityCrashInfo(Lnet/minecraft/crash/CrashReportCategory;)V", ordinal=1))}, locals=LocalCapture.CAPTURE_FAILHARD)
    void impl$stopEntityAndThrowInfo(CallbackInfo ci, int index, Entity ticking, @Nullable Entity riding, Throwable throwable) {
    }

    @Surrogate
    void impl$stopEntityAndThrowInfo(CallbackInfo ci, int index, Entity ticking, Throwable throwable) {
        this.impl$stopEntityAndThrowInfo(ci, index, ticking, null, throwable);
    }

    @Inject(method={"updateEntities"}, at={@At(value="INVOKE", target="Lnet/minecraft/profiler/Profiler;endSection()V", shift=At.Shift.BEFORE, by=2)}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/World;updateEntity(Lnet/minecraft/entity/Entity;)V"), to=@At(value="CONSTANT", args={"stringValue=remove"}, ordinal=1))})
    void impl$startEntityRemovalTiming(CallbackInfo callbackInfo) {
    }

    @Inject(method={"updateEntities"}, at={@At(value="INVOKE", target="Lnet/minecraft/profiler/Profiler;endSection()V", shift=At.Shift.BEFORE, by=2)}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/World;onEntityRemoved(Lnet/minecraft/entity/Entity;)V", ordinal=1), to=@At(value="CONSTANT", args={"stringValue=blockEntities"}))})
    void impl$stopRemovalTimingAfterentityRemovals(CallbackInfo ci) {
    }

    @Inject(method={"updateEntities"}, at={@At(value="FIELD", target="Lnet/minecraft/world/World;processingLoadedTiles:Z", opcode=181)}, slice={@Slice(from=@At(value="CONSTANT", args={"stringValue=blockEntities"}), to=@At(value="INVOKE", target="Lnet/minecraft/tileentity/TileEntity;hasWorld()Z"))})
    protected void impl$tileActivationStart(CallbackInfo callbackInfo) {
    }

    @Inject(method={"updateEntities"}, at={@At(value="INVOKE", target="Ljava/util/Iterator;next()Ljava/lang/Object;")}, slice={@Slice(from=@At(value="FIELD", target="Lnet/minecraft/world/World;tickableTileEntities:Ljava/util/List;", opcode=180, ordinal=1), to=@At(value="INVOKE", target="Lnet/minecraft/tileentity/TileEntity;hasWorld()Z"))})
    void impl$startTileTickTimer(CallbackInfo ci) {
    }

    @Inject(method={"updateEntities"}, at={@At(value="INVOKE", target="Lnet/minecraft/crash/CrashReport;makeCrashReport(Ljava/lang/Throwable;Ljava/lang/String;)Lnet/minecraft/crash/CrashReport;")}, slice={@Slice(from=@At(value="CONSTANT", args={"stringValue=Ticking block entity"}), to=@At(value="CONSTANT", args={"stringValue=Block entity being ticked"}))}, locals=LocalCapture.CAPTURE_FAILHARD)
    void impl$stopTileTickCrash(CallbackInfo ci, Iterator<TileEntity> iterator, TileEntity tickingTile, BlockPos pos, Throwable throwable) {
    }

    @Surrogate
    void impl$stopTileTickCrash(CallbackInfo ci, Iterator<TileEntity> iterator, TileEntity tickingTile, Throwable throwable) {
    }

    @Redirect(method={"updateEntities"}, at=@At(value="INVOKE", target="Lnet/minecraft/tileentity/TileEntity;hasWorld()Z"))
    private boolean impl$checkIfTileHasActiveChunk(TileEntity tileEntity) {
        return tileEntity.func_145830_o() && ((TileEntityBridge)tileEntity).bridge$shouldTick();
    }

    @Inject(method={"updateEntities"}, at={@At(value="INVOKE", target="Lnet/minecraft/tileentity/TileEntity;isInvalid()Z", shift=At.Shift.BEFORE, by=1)}, slice={@Slice(from=@At(value="CONSTANT", args={"stringValue=Block entity being ticked"}), to=@At(value="INVOKE", target="Ljava/util/Iterator;remove()V"))})
    void impl$stopTileTickAndStartRemoval(CallbackInfo callbackInfo) {
    }

    @Redirect(method={"updateEntities"}, at=@At(value="INVOKE", target="Ljava/util/List;remove(Ljava/lang/Object;)Z"))
    private boolean impl$removeTileFromLoadedList(List<?> loadedTileEntityList, Object tile) {
        boolean remove = loadedTileEntityList.remove(tile);
        TileEntity tileEntity = (TileEntity)tile;
        Chunk activeChunk = (Chunk)((ActiveChunkReferantBridge)tileEntity).bridge$getActiveChunk();
        if (activeChunk != null && activeChunk.func_177424_a(tileEntity.func_174877_v(), Chunk.EnumCreateEntityType.CHECK) == tileEntity) {
            activeChunk.func_177425_e(tileEntity.func_174877_v());
        }
        return remove;
    }

    @Redirect(method={"updateEntities"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;isBlockLoaded(Lnet/minecraft/util/math/BlockPos;)Z"), slice=@Slice(from=@At(value="INVOKE", target="Ljava/util/Iterator;remove()V", remap=false), to=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/Chunk;removeTileEntity(Lnet/minecraft/util/math/BlockPos;)V")))
    private boolean impl$ignoreisBlockLoaded(World self, BlockPos pos) {
        return false;
    }

    @Redirect(method={"updateEntities"}, at=@At(value="INVOKE", target="Ljava/util/Iterator;hasNext()Z"), slice=@Slice(from=@At(value="FIELD", target="Lnet/minecraft/world/World;tickableTileEntities:Ljava/util/List;", ordinal=1), to=@At(value="INVOKE", target="Lnet/minecraft/tileentity/TileEntity;hasWorld()Z")))
    boolean impl$stopTileRemovalTimingIfHasNext(Iterator<TileEntity> iterator) {
        return iterator.hasNext();
    }

    @Inject(method={"updateEntities"}, at={@At(value="CONSTANT", args={"stringValue=pendingBlockEntities"}, shift=At.Shift.BEFORE, by=2)})
    void impl$startPendingBlockEntities(CallbackInfo callbackInfo) {
    }

    @Inject(method={"updateEntities"}, at={@At(value="TAIL")})
    void impl$endPendingTileEntities(CallbackInfo ci) {
    }
}

