/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.status;

import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.imageio.ImageIO;
import org.spongepowered.api.network.status.Favicon;

public class SpongeFavicon
implements Favicon {
    private final String encoded;
    private final BufferedImage decoded;
    private static final String FAVICON_PREFIX = "data:image/png;base64,";

    public SpongeFavicon(BufferedImage decoded) throws IOException {
        this.decoded = Preconditions.checkNotNull(decoded, "decoded");
        this.encoded = SpongeFavicon.encode(decoded);
    }

    public SpongeFavicon(String encoded) throws IOException {
        this.encoded = Preconditions.checkNotNull(encoded, "encoded");
        this.decoded = SpongeFavicon.decode(encoded);
    }

    public String getEncoded() {
        return this.encoded;
    }

    @Override
    public BufferedImage getImage() {
        return this.decoded;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpongeFavicon)) {
            return false;
        }
        SpongeFavicon that = (SpongeFavicon)o;
        return Objects.equal(this.encoded, that.encoded);
    }

    public int hashCode() {
        return this.encoded.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).addValue(this.decoded).toString();
    }

    public static Favicon load(String raw) throws IOException {
        return new SpongeFavicon(raw);
    }

    public static Favicon load(Path path) throws IOException {
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            Favicon favicon = SpongeFavicon.load(in);
            return favicon;
        }
    }

    public static Favicon load(URL url) throws IOException {
        return SpongeFavicon.load(ImageIO.read(url));
    }

    public static Favicon load(InputStream in) throws IOException {
        return SpongeFavicon.load(ImageIO.read(in));
    }

    public static Favicon load(BufferedImage image) throws IOException {
        return new SpongeFavicon(image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String encode(BufferedImage favicon) throws IOException {
        Preconditions.checkArgument(favicon.getWidth() == 64, "favicon must be 64 pixels wide");
        Preconditions.checkArgument(favicon.getHeight() == 64, "favicon must be 64 pixels high");
        ByteBuf buf = Unpooled.buffer();
        try {
            String string;
            ImageIO.write((RenderedImage)favicon, "PNG", new ByteBufOutputStream(buf));
            ByteBuf base64 = Base64.encode(buf);
            try {
                string = FAVICON_PREFIX + base64.toString(Charsets.UTF_8);
            }
            catch (Throwable throwable) {
                base64.release();
                throw throwable;
            }
            base64.release();
            return string;
        }
        finally {
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage decode(String encoded) throws IOException {
        Preconditions.checkArgument(encoded.startsWith(FAVICON_PREFIX), "Unknown favicon format");
        ByteBuf base64 = Unpooled.copiedBuffer(encoded.substring(FAVICON_PREFIX.length()), Charsets.UTF_8);
        try {
            BufferedImage bufferedImage;
            ByteBuf buf = Base64.decode(base64);
            try {
                BufferedImage result = ImageIO.read(new ByteBufInputStream(buf));
                Preconditions.checkState(result.getWidth() == 64, "favicon must be 64 pixels wide");
                Preconditions.checkState(result.getHeight() == 64, "favicon must be 64 pixels high");
                bufferedImage = result;
            }
            catch (Throwable throwable) {
                buf.release();
                throw throwable;
            }
            buf.release();
            return bufferedImage;
        }
        finally {
            base64.release();
        }
    }
}

