/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.profile;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.properties.Property;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.profile.GameProfileCache;
import org.spongepowered.api.profile.GameProfileManager;
import org.spongepowered.api.profile.property.ProfileProperty;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.profile.query.GameProfileQuery;
import org.spongepowered.common.profile.query.NameQuery;
import org.spongepowered.common.profile.query.UniqueIdQuery;
import org.spongepowered.common.util.SpongeUsernameCache;

public final class SpongeProfileManager
implements GameProfileManager {
    private static final int LOOKUP_INTERVAL = SpongeImpl.getGlobalConfigAdapter().getConfig().getWorld().getGameProfileQueryTaskInterval();
    private final GameProfileCache defaultCache;
    private GameProfileCache cache;
    private ExecutorService gameLookupExecutorService;

    public SpongeProfileManager() {
        this.cache = this.defaultCache = (GameProfileCache)SpongeImpl.getServer().func_152358_ax();
        this.gameLookupExecutorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("Sponge - Async User Lookup Thread").build());
    }

    public void lookupUserAsync(UUID uuid) {
        this.gameLookupExecutorService.execute(() -> {
            if (SpongeUsernameCache.getLastKnownUsername(uuid) != null) {
                return;
            }
            try {
                Sponge.getServer().getGameProfileManager().get(Preconditions.checkNotNull(uuid, "uniqueId")).get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            try {
                Thread.sleep(LOOKUP_INTERVAL * 1000);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public GameProfile createProfile(UUID uniqueId, @Nullable String name) {
        Preconditions.checkNotNull(uniqueId, "unique id");
        return (GameProfile)((Object)new com.mojang.authlib.GameProfile(uniqueId, name));
    }

    @Override
    public ProfileProperty createProfileProperty(String name, String value, @Nullable String signature) {
        return (ProfileProperty)((Object)new Property(Preconditions.checkNotNull(name, "name"), Preconditions.checkNotNull(value, "value"), signature));
    }

    @Override
    public CompletableFuture<GameProfile> get(UUID uniqueId, boolean useCache) {
        return this.submitTask(new UniqueIdQuery.SingleGet(this.cache, Preconditions.checkNotNull(uniqueId, "unique id"), useCache));
    }

    @Override
    public CompletableFuture<Collection<GameProfile>> getAllById(Iterable<UUID> uniqueIds, boolean useCache) {
        return this.submitTask(new UniqueIdQuery.MultiGet(this.cache, Preconditions.checkNotNull(uniqueIds, "unique ids"), useCache));
    }

    @Override
    public CompletableFuture<GameProfile> get(String name, boolean useCache) {
        return this.submitTask(new NameQuery.SingleGet(this.cache, Preconditions.checkNotNull(name, "name"), useCache));
    }

    @Override
    public CompletableFuture<Collection<GameProfile>> getAllByName(Iterable<String> names, boolean useCache) {
        return this.submitTask(new NameQuery.MultiGet(this.cache, Preconditions.checkNotNull(names, "names"), useCache));
    }

    @Override
    public CompletableFuture<GameProfile> fill(GameProfile profile, boolean signed, boolean useCache) {
        return this.submitTask(new GameProfileQuery.SingleFill(this.cache, Preconditions.checkNotNull(profile, "profile"), signed, useCache));
    }

    @Override
    public GameProfileCache getCache() {
        return this.cache;
    }

    @Override
    public void setCache(GameProfileCache cache) {
        this.cache = Preconditions.checkNotNull(cache, "cache");
    }

    @Override
    public GameProfileCache getDefaultCache() {
        return this.defaultCache;
    }

    private <T> CompletableFuture<T> submitTask(Callable<T> callable) {
        return SpongeImpl.getScheduler().submitAsyncTask(callable);
    }
}

