/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.profile.callback;

import com.google.common.base.Preconditions;
import com.mojang.authlib.ProfileLookupCallback;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.profile.GameProfile;

public final class MapProfileLookupCallback
implements ProfileLookupCallback {
    private final Map<String, Optional<GameProfile>> profiles;

    public MapProfileLookupCallback(Map<String, Optional<GameProfile>> profiles) {
        this.profiles = Preconditions.checkNotNull(profiles, "profiles");
    }

    @Override
    public void onProfileLookupSucceeded(com.mojang.authlib.GameProfile profile) {
        this.profiles.put(profile.getName(), Optional.of((GameProfile)((Object)profile)));
    }

    @Override
    public void onProfileLookupFailed(com.mojang.authlib.GameProfile profile, Exception e) {
        this.profiles.put(profile.getName(), Optional.empty());
    }
}

