/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.passive.EntityVillager;
import org.spongepowered.api.data.type.Career;
import org.spongepowered.api.item.merchant.TradeOfferListMutator;
import org.spongepowered.api.item.merchant.VillagerRegistry;
import org.spongepowered.common.entity.SpongeCareer;
import org.spongepowered.common.entity.SpongeProfession;
import org.spongepowered.common.mixin.core.entity.passive.EntityVillagerAccessor;
import org.spongepowered.common.registry.type.entity.CareerRegistryModule;

public final class SpongeVillagerRegistry
implements VillagerRegistry {
    private final Map<Career, Multimap<Integer, TradeOfferListMutator>> careerGeneratorMap = new HashMap<Career, Multimap<Integer, TradeOfferListMutator>>();

    public static SpongeVillagerRegistry getInstance() {
        return Holder.INSTANCE;
    }

    SpongeVillagerRegistry() {
    }

    @Override
    public Multimap<Integer, TradeOfferListMutator> getTradeOfferLevelMap(Career career) {
        Multimap<Integer, TradeOfferListMutator> multimap = this.careerGeneratorMap.get(Preconditions.checkNotNull(career, "Career cannot be null!"));
        if (multimap == null) {
            return ImmutableMultimap.of();
        }
        return ImmutableMultimap.copyOf(multimap);
    }

    @Override
    public VillagerRegistry addMutator(Career career, int level, TradeOfferListMutator generator) {
        Preconditions.checkArgument(level > 0, "Career level must be at least greater than zero!");
        Preconditions.checkNotNull(career, "Career cannot be null!");
        Preconditions.checkNotNull(generator, "Generator cannot be null!");
        Multimap<Integer, TradeOfferListMutator> multimap = this.careerGeneratorMap.get(career);
        if (multimap == null) {
            multimap = ArrayListMultimap.create(3, 3);
            this.careerGeneratorMap.put(career, multimap);
        }
        multimap.put(level, generator);
        return this;
    }

    @Override
    public VillagerRegistry addMutators(Career career, int level, TradeOfferListMutator generator, TradeOfferListMutator ... generators) {
        Preconditions.checkArgument(level > 0, "Career level must be at least greater than zero!");
        Preconditions.checkNotNull(career, "Career cannot be null!");
        Preconditions.checkNotNull(generator, "Generator cannot be null!");
        Preconditions.checkNotNull(generators, "Generators cannot be null!");
        Multimap<Integer, TradeOfferListMutator> multimap = this.careerGeneratorMap.get(career);
        ArrayList<TradeOfferListMutator> list = new ArrayList<TradeOfferListMutator>();
        list.add(generator);
        for (TradeOfferListMutator element : generators) {
            list.add(Preconditions.checkNotNull(element, "TradeOfferListMutator cannot be null!"));
        }
        if (multimap == null) {
            multimap = ArrayListMultimap.create(3, list.size());
            this.careerGeneratorMap.put(career, multimap);
        }
        multimap.putAll(level, list);
        return this;
    }

    @Override
    public VillagerRegistry setMutators(Career career, int level, List<TradeOfferListMutator> generators) {
        Preconditions.checkArgument(level > 0, "Career level must be at least greater than zero!");
        Preconditions.checkNotNull(career, "Career cannot be null!");
        Preconditions.checkNotNull(generators, "Generators cannot be null!");
        Multimap<Integer, TradeOfferListMutator> multimap = this.careerGeneratorMap.get(career);
        if (multimap == null) {
            multimap = ArrayListMultimap.create(3, generators.size());
            this.careerGeneratorMap.put(career, multimap);
        }
        multimap.replaceValues(level, generators);
        return this;
    }

    @Override
    public VillagerRegistry setMutators(Career career, Multimap<Integer, TradeOfferListMutator> generatorMap) {
        Preconditions.checkNotNull(career, "Career cannot be null!");
        Preconditions.checkNotNull(generatorMap, "Generators cannot be null!");
        Multimap<Integer, TradeOfferListMutator> multimap = this.careerGeneratorMap.get(career);
        if (multimap != null) {
            multimap.clear();
        }
        multimap = ArrayListMultimap.create(generatorMap);
        this.careerGeneratorMap.put(career, multimap);
        return this;
    }

    static void registerVanillaTrades() {
        SpongeVillagerRegistry instance = SpongeVillagerRegistry.getInstance();
        for (Career career : CareerRegistryModule.getInstance().getAll()) {
            SpongeCareer spongeCareer = (SpongeCareer)career;
            EntityVillager.ITradeList[][] careerLevels = EntityVillagerAccessor.accessor$getDefaultTradeListMapping()[((SpongeProfession)spongeCareer.getProfession()).type][spongeCareer.type];
            for (int level = 0; level < careerLevels.length; ++level) {
                EntityVillager.ITradeList[] offers = careerLevels[level];
                ImmutableList.Builder builder = ImmutableList.builder();
                for (int i = 0; i < offers.length; ++i) {
                    builder.add(SpongeVillagerRegistry.generatorFor(offers[i]));
                }
                instance.setMutators(career, level + 1, (List<TradeOfferListMutator>)((Object)builder.build()));
            }
        }
    }

    private static TradeOfferListMutator generatorFor(EntityVillager.ITradeList iTradeList) {
        return (TradeOfferListMutator)iTradeList;
    }

    static final class Holder {
        static final SpongeVillagerRegistry INSTANCE = new SpongeVillagerRegistry();

        Holder() {
        }
    }
}

