/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.provider;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockBanner;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockBrewingStand;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockCake;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockConcretePowder;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDaylightDetector;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockEndPortalFrame;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.BlockJukebox;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockMycelium;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.BlockPressurePlate;
import net.minecraft.block.BlockPressurePlateWeighted;
import net.minecraft.block.BlockPrismarine;
import net.minecraft.block.BlockQuartz;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockRailDetector;
import net.minecraft.block.BlockRailPowered;
import net.minecraft.block.BlockRedSandstone;
import net.minecraft.block.BlockRedstoneComparator;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.BlockReed;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.BlockSponge;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.BlockStainedGlassPane;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStandingSign;
import net.minecraft.block.BlockStem;
import net.minecraft.block.BlockStone;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.BlockStoneSlabNew;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockTripWire;
import net.minecraft.block.BlockTripWireHook;
import net.minecraft.block.BlockVine;
import net.minecraft.block.BlockWall;
import net.minecraft.block.BlockWoodSlab;
import net.minecraft.block.properties.IProperty;
import org.apache.logging.log4j.LogManager;
import org.spongepowered.common.registry.TypeProvider;

public class BlockPropertyIdProvider
implements TypeProvider<IProperty<?>, String> {
    private final IdentityHashMap<IProperty<?>, String> propertyIdMap = new IdentityHashMap();
    private final HashMap<String, IProperty<?>> idPropertyMap = new HashMap();

    public static BlockPropertyIdProvider getInstance() {
        return Holder.INSTANCE;
    }

    public static String getIdFor(IProperty<?> iProperty) {
        return BlockPropertyIdProvider.getInstance().propertyIdMap.get(iProperty);
    }

    @Override
    public Optional<String> get(IProperty<?> key) {
        return Optional.ofNullable(this.propertyIdMap.get(Preconditions.checkNotNull(key, "Property cannot be null!")));
    }

    @Override
    public Optional<IProperty<?>> getKey(String value) {
        return Optional.ofNullable(this.idPropertyMap.get(Preconditions.checkNotNull(value, "Id cannot be null!").toLowerCase(Locale.ENGLISH)));
    }

    private boolean isRegistered(IProperty<?> property) {
        return this.propertyIdMap.containsKey(property);
    }

    public static String getIdAndTryRegistration(IProperty<?> property, Block block, String blockId) {
        BlockPropertyIdProvider instance = BlockPropertyIdProvider.getInstance();
        Preconditions.checkNotNull(property, "Property is null! Cannot retrieve a registration for a null property!");
        Preconditions.checkNotNull(block, "Block cannot be null!");
        Preconditions.checkNotNull(blockId, "Block id cannot be null!");
        Preconditions.checkArgument(!blockId.isEmpty(), "Block id cannot be empty!");
        if (instance.isRegistered(property)) {
            return instance.propertyIdMap.get(property);
        }
        String lowerCasedBlockId = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, blockId);
        String modId = lowerCasedBlockId.split(":")[0];
        String propertyName = property.func_177701_a();
        String lastAttemptId = lowerCasedBlockId + "_" + property.func_177701_a();
        try {
            String originalClass = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, block.getClass().getSimpleName());
            Class<?> blockClass = block.getClass();
            while (true) {
                if (blockClass == Object.class) {
                    String propertyId = modId + ":" + originalClass + "_" + property.func_177701_a();
                    LogManager.getLogger("Sponge").warn("Could not find {} owning class, assigning fallback id: {}", (Object)property.func_177701_a(), (Object)propertyId);
                    instance.register(property, propertyId);
                    return propertyId;
                }
                for (Field field : blockClass.getDeclaredFields()) {
                    Object o;
                    field.setAccessible(true);
                    boolean isStatic = Modifier.isStatic(field.getModifiers());
                    Object object = o = isStatic ? field.get(null) : field.get(block);
                    if (property != o) continue;
                    String className = field.getDeclaringClass().getSimpleName().replace("Block", "").replace("block", "");
                    String classNameId = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, className);
                    String propertyClassName = isStatic ? classNameId : originalClass;
                    String combinedId = modId + ":" + propertyClassName + "_" + propertyName.toLowerCase(Locale.ENGLISH);
                    if (instance.idPropertyMap.containsKey(combinedId)) {
                        if (instance.idPropertyMap.containsKey(lastAttemptId)) {
                            throw new IllegalArgumentException("Sorry! Someone is trying to re-register a block with the same property instances ofblock: " + blockId + " , with property: " + propertyName);
                        }
                        instance.register((IProperty)o, lastAttemptId);
                        return lastAttemptId;
                    }
                    instance.register((IProperty)o, combinedId);
                    return combinedId;
                }
                blockClass = blockClass.getSuperclass();
            }
        }
        catch (Exception e) {
            LogManager.getLogger("Sponge").warn("An exception was thrown while trying to resolve the property " + property.func_177701_a() + "'s owning class, assigning fallback id: " + lastAttemptId, (Throwable)e);
            instance.register(property, lastAttemptId);
            return lastAttemptId;
        }
    }

    private void register(IProperty<?> property, String id) {
        Preconditions.checkArgument(!this.propertyIdMap.containsKey(property), "Property is already registered! Property: " + property.func_177701_a() + " is registered as : " + this.propertyIdMap.get(property));
        this.propertyIdMap.put(property, id.toLowerCase(Locale.ENGLISH));
        this.idPropertyMap.put(id.toLowerCase(Locale.ENGLISH), property);
    }

    BlockPropertyIdProvider() {
        this.register((IProperty<?>)BlockHorizontal.field_185512_D, "minecraft:horizontal_facing");
        this.register((IProperty<?>)BlockRotatedPillar.field_176298_M, "minecraft:pillar_axis");
        this.register((IProperty<?>)BlockDirectional.field_176387_N, "minecraft:directional_facing");
        this.register((IProperty<?>)BlockLog.field_176299_a, "minecraft:log_axis");
        this.register((IProperty<?>)BlockNewLog.field_176300_b, "minecraft:new_log_variant");
        this.register((IProperty<?>)BlockOldLog.field_176301_b, "minecraft:log_variant");
        this.register((IProperty<?>)BlockFarmland.field_176531_a, "minecraft:farmland_moisture");
        this.register((IProperty<?>)BlockPistonBase.field_176320_b, "minecraft:piston_extended");
        this.register((IProperty<?>)BlockVine.field_176273_b, "minecraft:vine_north");
        this.register((IProperty<?>)BlockVine.field_176278_M, "minecraft:vine_east");
        this.register((IProperty<?>)BlockVine.field_176279_N, "minecraft:vine_south");
        this.register((IProperty<?>)BlockVine.field_176280_O, "minecraft:vine_west");
        this.register((IProperty<?>)BlockVine.field_176277_a, "minecraft:vine_up");
        this.register((IProperty<?>)BlockRedSandstone.field_176336_a, "minecraft:red_sandstone_type");
        this.register((IProperty<?>)BlockLiquid.field_176367_b, "minecraft:liquid_level");
        this.register((IProperty<?>)BlockReed.field_176355_a, "minecraft:reed_age");
        this.register((IProperty<?>)BlockMycelium.field_176384_a, "minecraft:mycelium_snowy");
        this.register((IProperty<?>)BlockColored.field_176581_a, "minecraft:dyed_color");
        this.register((IProperty<?>)BlockTorch.field_176596_a, "minecraft:torch_facing");
        this.register((IProperty<?>)BlockDirt.field_176385_b, "minecraft:dirt_snowy");
        this.register((IProperty<?>)BlockDirt.field_176386_a, "minecraft:dirt_variant");
        this.register((IProperty<?>)BlockEndPortalFrame.field_176507_b, "minecraft:end_portal_eye");
        this.register((IProperty<?>)BlockCarpet.field_176330_a, "minecraft:carpet_color");
        this.register((IProperty<?>)BlockStone.field_176247_a, "minecraft:stone_variant");
        this.register((IProperty<?>)BlockHugeMushroom.field_176380_a, "minecraft:huge_mushroom_variant");
        this.register((IProperty<?>)BlockSnow.field_176315_a, "minecraft:snow_layer");
        this.register((IProperty<?>)BlockWall.field_176256_a, "minecraft:wall_up");
        this.register((IProperty<?>)BlockWall.field_176254_b, "minecraft:wall_north");
        this.register((IProperty<?>)BlockWall.field_176257_M, "minecraft:wall_east");
        this.register((IProperty<?>)BlockWall.field_176258_N, "minecraft:wall_south");
        this.register((IProperty<?>)BlockWall.field_176259_O, "minecraft:wall_west");
        this.register((IProperty<?>)BlockWall.field_176255_P, "minecraft:wall_variant");
        this.register((IProperty<?>)BlockStairs.field_176308_b, "minecraft:stairs_half");
        this.register((IProperty<?>)BlockStairs.field_176310_M, "minecraft:stairs_shape");
        this.register((IProperty<?>)BlockButton.field_176584_b, "minecraft:button_powered");
        this.register((IProperty<?>)BlockCactus.field_176587_a, "minecraft:cactus_age");
        this.register((IProperty<?>)BlockCrops.field_176488_a, "minecraft:crops_age");
        this.register((IProperty<?>)BlockNetherWart.field_176486_a, "minecraft:nether_wart_age");
        this.register((IProperty<?>)BlockDoublePlant.field_176493_a, "minecraft:double_plant_variant");
        this.register((IProperty<?>)BlockDoublePlant.field_176492_b, "minecraft:double_plant_half");
        this.register((IProperty<?>)BlockStem.field_176484_a, "minecraft:stem_age");
        this.register((IProperty<?>)BlockTallGrass.field_176497_a, "minecraft:tall_grass_type");
        this.register((IProperty<?>)BlockSapling.field_176480_a, "minecraft:sapling_type");
        this.register((IProperty<?>)BlockSapling.field_176479_b, "minecraft:sapling_stage");
        this.register((IProperty<?>)BlockPrismarine.field_176332_a, "minecraft:prismarine_variant");
        this.register((IProperty<?>)BlockFence.field_176526_a, "minecraft:fence_north");
        this.register((IProperty<?>)BlockFence.field_176525_b, "minecraft:fence_east");
        this.register((IProperty<?>)BlockFence.field_176527_M, "minecraft:fence_south");
        this.register((IProperty<?>)BlockFence.field_176528_N, "minecraft:fence_west");
        this.register((IProperty<?>)BlockSilverfish.field_176378_a, "minecraft:disguised_variant");
        this.register((IProperty<?>)BlockPane.field_176241_b, "minecraft:pane_north");
        this.register((IProperty<?>)BlockPane.field_176242_M, "minecraft:pane_east");
        this.register((IProperty<?>)BlockPane.field_176243_N, "minecraft:pane_south");
        this.register((IProperty<?>)BlockPane.field_176244_O, "minecraft:pane_west");
        this.register((IProperty<?>)BlockStainedGlassPane.field_176245_a, "minecraft:stained_dyed_color");
        this.register((IProperty<?>)BlockQuartz.field_176335_a, "minecraft:quartz_variant");
        this.register((IProperty<?>)BlockPistonExtension.field_176325_b, "minecraft:piston_extension_type");
        this.register((IProperty<?>)BlockPistonExtension.field_176327_M, "minecraft:piston_extension_short");
        this.register((IProperty<?>)BlockSandStone.field_176297_a, "minecraft:sand_stone_type");
        this.register((IProperty<?>)BlockPlanks.field_176383_a, "minecraft:plank_variant");
        this.register((IProperty<?>)BlockPortal.field_176550_a, "minecraft:portal_axis");
        this.register((IProperty<?>)BlockStainedGlass.field_176547_a, "minecraft:stained_glass_color");
        this.register((IProperty<?>)BlockRail.field_176565_b, "minecraft:rail_shape");
        this.register((IProperty<?>)BlockRailPowered.field_176569_M, "minecraft:powered_rail_powered");
        this.register((IProperty<?>)BlockRailPowered.field_176568_b, "minecraft:powered_rail_shape");
        this.register((IProperty<?>)BlockRailDetector.field_176574_M, "minecraft:detector_rail_powered");
        this.register((IProperty<?>)BlockRailDetector.field_176573_b, "minecraft:detector_rail_shape");
        this.register((IProperty<?>)BlockLeaves.field_176237_a, "minecraft:leaves_decay");
        this.register((IProperty<?>)BlockLeaves.field_176236_b, "minecraft:leaves_check_decay");
        this.register((IProperty<?>)BlockOldLeaf.field_176239_P, "minecraft:old_leaves_variant");
        this.register((IProperty<?>)BlockNewLeaf.field_176240_P, "minecraft:new_leaves_variant");
        this.register((IProperty<?>)BlockGrass.field_176498_a, "minecraft:grass_snowy");
        this.register((IProperty<?>)BlockCauldron.field_176591_a, "minecraft:cauldron_level");
        this.register((IProperty<?>)BlockBanner.field_176448_b, "minecraft:banner_rotation");
        this.register((IProperty<?>)BlockSkull.field_176417_b, "minecraft:skull_no_drop");
        this.register((IProperty<?>)BlockStandingSign.field_176413_a, "minecraft:standing_sign_rotation");
        this.register((IProperty<?>)BlockBrewingStand.field_176451_a[0], "minecraft:brewing_stand_1_has_bottle");
        this.register((IProperty<?>)BlockBrewingStand.field_176451_a[1], "minecraft:brewing_stand_2_has_bottle");
        this.register((IProperty<?>)BlockBrewingStand.field_176451_a[2], "minecraft:brewing_stand_3_has_bottle");
        this.register((IProperty<?>)BlockHopper.field_176429_b, "minecraft:hopper_enabled");
        this.register((IProperty<?>)BlockHopper.field_176430_a, "minecraft:hopper_facing");
        this.register((IProperty<?>)BlockFlowerPot.field_176444_a, "minecraft:flower_pot_legacy");
        this.register((IProperty<?>)BlockFlowerPot.field_176443_b, "minecraft:flower_pot_contents");
        this.register((IProperty<?>)BlockDaylightDetector.field_176436_a, "minecraft:daylight_detector_power");
        this.register((IProperty<?>)BlockDispenser.field_176440_b, "minecraft:dispenser_triggered");
        this.register((IProperty<?>)BlockJukebox.field_176432_a, "minecraft:jukebox_has_record");
        this.register((IProperty<?>)BlockSand.field_176504_a, "minecraft:sand_variant");
        this.register((IProperty<?>)BlockAnvil.field_176505_b, "minecraft:anvil_damage");
        this.register((IProperty<?>)BlockCake.field_176589_a, "minecraft:cake_bites");
        this.register((IProperty<?>)BlockFire.field_176543_a, "minecraft:fire_age");
        this.register((IProperty<?>)BlockFire.field_176545_N, "minecraft:fire_north");
        this.register((IProperty<?>)BlockFire.field_176546_O, "minecraft:fire_east");
        this.register((IProperty<?>)BlockFire.field_176541_P, "minecraft:fire_south");
        this.register((IProperty<?>)BlockFire.field_176539_Q, "minecraft:fire_west");
        this.register((IProperty<?>)BlockFire.field_176542_R, "minecraft:fire_upper");
        this.register((IProperty<?>)BlockSlab.field_176554_a, "minecraft:slab_half");
        this.register((IProperty<?>)BlockStoneSlabNew.field_176558_b, "minecraft:stone_slab_new_seamless");
        this.register((IProperty<?>)BlockStoneSlabNew.field_176559_M, "minecraft:stone_slab_new_variant");
        this.register((IProperty<?>)BlockStoneSlab.field_176555_b, "minecraft:stone_slab_seamless");
        this.register((IProperty<?>)BlockStoneSlab.field_176556_M, "minecraft:stone_slab_variant");
        this.register((IProperty<?>)BlockWoodSlab.field_176557_b, "minecraft:wood_slab_variant");
        this.register((IProperty<?>)BlockSponge.field_176313_a, "minecraft:sponge_wet");
        this.register((IProperty<?>)BlockTripWireHook.field_176265_M, "minecraft:trip_wire_hook_attached");
        this.register((IProperty<?>)BlockTripWireHook.field_176263_b, "minecraft:trip_wire_hook_powered");
        this.register((IProperty<?>)BlockDoor.field_176519_b, "minecraft:door_open");
        this.register((IProperty<?>)BlockDoor.field_176521_M, "minecraft:door_hinge");
        this.register((IProperty<?>)BlockDoor.field_176522_N, "minecraft:door_powered");
        this.register((IProperty<?>)BlockDoor.field_176523_O, "minecraft:door_half");
        this.register((IProperty<?>)BlockStoneBrick.field_176249_a, "minecraft:stone_brick_variant");
        this.register((IProperty<?>)BlockLever.field_176360_a, "minecraft:lever_variant");
        this.register((IProperty<?>)BlockLever.field_176359_b, "minecraft:lever_powered");
        this.register((IProperty<?>)BlockTNT.field_176246_a, "minecraft:tnt_explode");
        this.register((IProperty<?>)BlockBed.field_176472_a, "minecraft:bed_part");
        this.register((IProperty<?>)BlockBed.field_176471_b, "minecraft:bed_occupied");
        this.register((IProperty<?>)BlockRedstoneComparator.field_176463_b, "minecraft:comparator_mode");
        this.register((IProperty<?>)BlockRedstoneComparator.field_176464_a, "minecraft:comparator_powered");
        this.register((IProperty<?>)BlockCocoa.field_176501_a, "minecraft:cocoa_age");
        this.register((IProperty<?>)BlockFenceGate.field_176467_M, "minecraft:fence_gate_in_wall");
        this.register((IProperty<?>)BlockFenceGate.field_176466_a, "minecraft:fence_gate_open");
        this.register((IProperty<?>)BlockFenceGate.field_176465_b, "minecraft:fence_gate_powered");
        this.register((IProperty<?>)BlockRedstoneWire.field_176348_a, "minecraft:redstone_north");
        this.register((IProperty<?>)BlockRedstoneWire.field_176347_b, "minecraft:redstone_east");
        this.register((IProperty<?>)BlockRedstoneWire.field_176349_M, "minecraft:redstone_south");
        this.register((IProperty<?>)BlockRedstoneWire.field_176350_N, "minecraft:redstone_west");
        this.register((IProperty<?>)BlockRedstoneWire.field_176351_O, "minecraft:redstone_power");
        this.register((IProperty<?>)BlockTripWire.field_176293_a, "minecraft:trip_wire_powered");
        this.register((IProperty<?>)BlockTripWire.field_176294_M, "minecraft:trip_wire_attached");
        this.register((IProperty<?>)BlockTripWire.field_176295_N, "minecraft:trip_wire_disarmed");
        this.register((IProperty<?>)BlockTripWire.field_176296_O, "minecraft:trip_wire_north");
        this.register((IProperty<?>)BlockTripWire.field_176291_P, "minecraft:trip_wire_east");
        this.register((IProperty<?>)BlockTripWire.field_176289_Q, "minecraft:trip_wire_south");
        this.register((IProperty<?>)BlockTripWire.field_176292_R, "minecraft:trip_wire_west");
        this.register((IProperty<?>)BlockPressurePlateWeighted.field_176579_a, "minecraft:weighted_pressure_plate_power");
        this.register((IProperty<?>)BlockPressurePlate.field_176580_a, "minecraft:pressure_plate_power");
        this.register((IProperty<?>)BlockTrapDoor.field_176283_b, "minecraft:trap_door_open");
        this.register((IProperty<?>)BlockTrapDoor.field_176285_M, "minecraft:trap_door_half");
        this.register((IProperty<?>)BlockRedstoneRepeater.field_176410_b, "minecraft:redstone_repeater_delay");
        this.register((IProperty<?>)BlockRedstoneRepeater.field_176411_a, "minecraft:redstone_repeater_locked");
        this.register((IProperty<?>)BlockConcretePowder.field_192426_a, "minecraft:concrete_powder_color");
    }

    private static final class Holder {
        static final BlockPropertyIdProvider INSTANCE = new BlockPropertyIdProvider();

        private Holder() {
        }
    }
}

