/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.provider;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.event.cause.entity.damage.DamageType;
import org.spongepowered.api.event.cause.entity.damage.DamageTypes;
import org.spongepowered.common.registry.TypeProvider;

public class DamageSourceToTypeProvider
implements TypeProvider<String, DamageType> {
    private final Map<String, DamageType> damageSourceToTypeMappings = new HashMap<String, DamageType>();

    public static DamageSourceToTypeProvider getInstance() {
        return Holder.INSTANCE;
    }

    DamageSourceToTypeProvider() {
        this.damageSourceToTypeMappings.put("anvil", DamageTypes.CONTACT);
        this.damageSourceToTypeMappings.put("arrow", DamageTypes.PROJECTILE);
        this.damageSourceToTypeMappings.put("cactus", DamageTypes.CONTACT);
        this.damageSourceToTypeMappings.put("cramming", DamageTypes.CONTACT);
        this.damageSourceToTypeMappings.put("dragonbreath", DamageTypes.MAGIC);
        this.damageSourceToTypeMappings.put("drown", DamageTypes.DROWN);
        this.damageSourceToTypeMappings.put("explosion.player", DamageTypes.EXPLOSIVE);
        this.damageSourceToTypeMappings.put("fall", DamageTypes.FALL);
        this.damageSourceToTypeMappings.put("fallingblock", DamageTypes.CONTACT);
        this.damageSourceToTypeMappings.put("fireworks", DamageTypes.EXPLOSIVE);
        this.damageSourceToTypeMappings.put("flyintowall", DamageTypes.CONTACT);
        this.damageSourceToTypeMappings.put("generic", DamageTypes.GENERIC);
        this.damageSourceToTypeMappings.put("hotfloor", DamageTypes.MAGMA);
        this.damageSourceToTypeMappings.put("indirectmagic", DamageTypes.MAGIC);
        this.damageSourceToTypeMappings.put("infire", DamageTypes.FIRE);
        this.damageSourceToTypeMappings.put("inwall", DamageTypes.SUFFOCATE);
        this.damageSourceToTypeMappings.put("lava", DamageTypes.FIRE);
        this.damageSourceToTypeMappings.put("lightningbolt", DamageTypes.PROJECTILE);
        this.damageSourceToTypeMappings.put("magic", DamageTypes.MAGIC);
        this.damageSourceToTypeMappings.put("mob", DamageTypes.ATTACK);
        this.damageSourceToTypeMappings.put("onfire", DamageTypes.FIRE);
        this.damageSourceToTypeMappings.put("outofworld", DamageTypes.VOID);
        this.damageSourceToTypeMappings.put("player", DamageTypes.ATTACK);
        this.damageSourceToTypeMappings.put("starve", DamageTypes.HUNGER);
        this.damageSourceToTypeMappings.put("thorns", DamageTypes.MAGIC);
        this.damageSourceToTypeMappings.put("thrown", DamageTypes.PROJECTILE);
        this.damageSourceToTypeMappings.put("wither", DamageTypes.MAGIC);
    }

    @Override
    public Optional<DamageType> get(String key) {
        return Optional.ofNullable(this.damageSourceToTypeMappings.get(Preconditions.checkNotNull(key).toLowerCase(Locale.ENGLISH)));
    }

    public DamageType getOrCustom(String key) {
        DamageType damageType = this.damageSourceToTypeMappings.get(Preconditions.checkNotNull(key).toLowerCase(Locale.ENGLISH));
        if (damageType == null) {
            this.addCustom(key);
            return DamageTypes.CUSTOM;
        }
        return damageType;
    }

    @Override
    public Optional<String> getKey(DamageType value) {
        throw new UnsupportedOperationException("We do not support this!");
    }

    public void addCustom(String in) {
        this.damageSourceToTypeMappings.put(in.toLowerCase(Locale.ENGLISH), DamageTypes.CUSTOM);
    }

    private static final class Holder {
        static final DamageSourceToTypeProvider INSTANCE = new DamageSourceToTypeProvider();

        private Holder() {
        }
    }
}

